/**
 * Copyright s8t1h12akj ( http://wonderfl.net/user/s8t1h12akj )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/SAz2
 */

// forked from greentec's Simple Sound Visualizer
package {
    import com.bit101.components.PushButton;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.ColorTransform;
    import flash.media.Sound;
    import flash.media.SoundChannel;
    import flash.media.SoundMixer;
    import flash.net.FileFilter;
    import flash.net.FileReference;
    import flash.net.URLRequest;
    import flash.utils.ByteArray;

    public class FlashTest extends Sprite {
        public var fr:FileReference;
        public var sound:Sound;
        public var soundChannel:SoundChannel;
        public var url:URLRequest;
        public var ba:ByteArray;
        
        public var bmd:BitmapData;
        public var shape:Shape;

        public function FlashTest() {
            // write as3 code here..
            addChild(new Bitmap(new BitmapData(465, 465, false, 0x000000)));
            
            bmd = new BitmapData(465, 465, true, 0x00ffffff);
            addChild(new Bitmap(bmd));
            
            var button:PushButton = new PushButton(this, 10, 465 - 30, "Yor Faile 自分のファイルから mp3 選択", onLoadSound);
        }
        
        private function onLoadSound(e:Event):void
        {
            fr = new FileReference();
            var fileFilter:FileFilter = new FileFilter("Sound File", "*.mp3");
            fr.addEventListener(Event.SELECT, onSelectSound);
            fr.browse([fileFilter]);
        }
        
        private function onSelectSound(e:Event):void
        {
            fr.addEventListener(Event.COMPLETE, onLoadSoundComplete);
            fr.load();
        }
        
        private function onLoadSoundComplete(e:Event):void
        {
            //url = new URLRequest(fr.name);
            var data:ByteArray = fr.data;
            
            if (soundChannel != null)
            {
                soundChannel.stop();
            }
            
            sound = new Sound();
            sound.loadCompressedDataFromByteArray(data, data.length);
            soundChannel = sound.play();
            
            ba = new ByteArray();
            shape = new Shape();
            
            addEventListener(Event.ENTER_FRAME, onLoop);
        }
        
        private function onLoop(e:Event):void
        {
            bmd.colorTransform(bmd.rect, new ColorTransform(0.8, 0.8, 0.9, 1));
            
            var i:int;
            var j:int;
            var num:Number;
            var indentX:int = (465 - 256) / 2;
            
            SoundMixer.computeSpectrum(ba, true, 0);
            
            shape.graphics.clear();
            shape.graphics.lineStyle(3, 0xffffff);
            
            var angle:Number;
            var angleMax:Number = 20;
            var startX:int = 465 / 2;
            var startY:int = 465 / 2;
            
            for (i = 0; i < 256; i += 1)
            {
                num = ba.readFloat() * 200;
                
                angle = num / 2;
                
                shape.graphics.moveTo(startX + Math.cos(angle * 180 / Math.PI) * num, startY + Math.sin(angle * 180 / Math.PI) * num);
                
                for (j = 0; j < angleMax; j += 1)
                {
                    angle += 0.001;
                    shape.graphics.lineTo(startX + Math.cos(angle * 180 / Math.PI) * num, startY + Math.sin(angle * 180 / Math.PI) * num);
                }
                //shape.graphics.drawCircle(465 / 2, 465 / 2, num);
                //bmd.setPixel32(indentX + i, num, 0xffffffff);
            }
            
            bmd.draw(shape);
        }
   }
}