/**
 * Copyright yonatan ( http://wonderfl.net/user/yonatan )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/S7J1
 */

// forked from shaktool's Andre Michelle's Karplus-Strong Guitar
package  
{
    import flash.display.Sprite;
    import flash.events.MouseEvent;
    import flash.events.SampleDataEvent;
    import flash.media.Sound;
    import flash.utils.*;

    /**
    * <PLUGGED STRING>
    * 
    * Very simple Karplus-Strong example for FFK09 '10 Hot Minutes' in cologne.
    * 
    * An advancement, more guitar-like implementation can be found here:
    * http://lab.andre-michelle.com/karplus-strong-guitar
    * 
    * @author Andre Michelle
    */
    [SWF(width='320',height='240',frameRate='255',backgroundColor='0xFFFFFF')]
    public class KarplusStrong extends Sprite 
    {
        private const NUM_SAMPLES: int = 3072; // 3072 seems the best numSamples to provide with respect to performance and low latency
        
        private var _sound: Sound;
        
        private var _periodN: int;
        private var _period: Vector.<Number>;
        private var _periodIndex: int;
        private var _sampleCount: int;
        
        private var _current: Number;
        
        public function KarplusStrong()
        {
            _periodN = 44100 / 110; // length = sampleRate / targetFrequency (ignoring fractional)
            _period = new Vector.<Number>( _periodN, true );
            _periodIndex = 0;
            
            _current = 0.0;
            
            _sound = new Sound();
            _sound.addEventListener( SampleDataEvent.SAMPLE_DATA, sampleData );
            
            setTimeout( _sound.play, 500 ); // delay start to avoid glitches
        }
        
        private var b0:Number = 0, b1:Number = 0, b2:Number = 0, b3:Number = 0, b4:Number = 0, b5:Number = 0, b6:Number = 0;
        private function sampleData(event: SampleDataEvent): void
        {
            for( var i: int = 0 ; i < NUM_SAMPLES ; ++i )
            {
                if( _periodIndex == _periodN ) // wrap around delay-line
                {
                    _periodIndex = 0;
                }

                // var att:Number = _sampleCount%10000 < 5000 ? 0.5 : 0;
                var att:Number = 0.33 * Math.pow(Math.sin(_sampleCount/20000), 3);
                var white:Number = Math.random()*2-1;
                var gaussian:Number = (Math.random()+Math.random()+Math.random())*0.666666-1;
                _period[ _periodIndex ] += att < 0 ? 0 : white * att;
                
                _current = _current * 0.99 + ( _period[ _periodIndex ] - _current ) * .5; // 1 pole lowpass (removing energie from the system)
                
                _period[ _periodIndex ] = _current; // write feedback
                
                // write amplitude to event > output
                event.data.writeFloat( _current );
                event.data.writeFloat( _current );
                
                ++_periodIndex;
                ++_sampleCount;
            }
        }
    }
}