/**
 * Copyright mjexpert381 ( http://wonderfl.net/user/mjexpert381 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/S3ee
 */

// forked from aecend1's forked from: Pattern Sketch 001
// forked from Aquioux's Pattern Sketch 001
package {
    import flash.display.Graphics;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Point;
    import frocessing.color.ColorHSV;
    [SWF(width = "465", height = "465", frameRate = "30", backgroundColor = "#000000")]
    /**
     * Pattern Sketch 001
     * @author Aquioux(Yoshida, Akio)
     */
    public class Main extends Sprite {
        
        private const RATE:Number = 1;
        private const LOOP:uint = 360 / RATE;
        private const RADIAN:Number = Math.PI / 180 * RATE;

        private const RADIUS:Number = 7.5;
        private const DIST:uint = 100;
        
        private const SW:Number = stage.stageWidth;
        private const SH:Number = stage.stageHeight;
        private const CX:Number = stage.stageWidth / 2;
        private const CY:Number = stage.stageHeight / 2;
        
        private var hsv:ColorHSV = new ColorHSV();
        private var elements:Array = [];
        private var p:Point = new Point();
        
        private var offsetX:Number = 1.0;
        private var offsetY:Number = 1.0;
        

        public function Main():void {
            setup();
            addEventListener(Event.ENTER_FRAME, update);
            stage.addEventListener(MouseEvent.MOUSE_MOVE, mouseMoveHandler);
        }
        
        private function setup():void {
            var back:Shape = new Shape();
            var g:Graphics = back.graphics;
            g.beginFill(0x000000);
            g.drawRect(0, 0, SW, SH);
            g.endFill();
            addChild(back);
            
            var container:Sprite = new Sprite();
            addChild(container);
            
            for (var i:int = 0; i < LOOP; i++) {
                hsv.h = i * RATE;
                p = Point.polar(DIST, i * RADIAN);
                var element:Element = new Element();
                element.setup(RADIUS, hsv.value);
                element.x = p.x + CX;
                element.y = p.y + CY;
                element.rotation = i * RADIAN * 180 / Math.PI;
                elements.push(element);
                container.addChild(element);
                element.update();
            }
            
            update(null);
        }
        
        private function update(e:Event):void {
            var len:uint = LOOP;
            for (var i:int = 0; i < len; i++) {
                var scale:Number = Math.sin(i * RADIAN * offsetX * 8) * offsetY * 8;
                var element:Element = elements[i];
                element.scaleX = scale;
                element.scaleY = scale;
            }
        }
        
        private function mouseMoveHandler(e:MouseEvent):void {
            offsetX = mouseX / SW;
            offsetY = mouseY / SH;
            if (offsetX <= 0.1) offsetX = 0.1;
            if (offsetY <= 0.1) offsetY = 0.1;
        }
    }
}


    import flash.display.Graphics;
    import flash.display.Shape;
    
    class Element extends Shape {
        
        public function get radius():Number { return _radius; }
        public function set radius(value:Number):void { _radius = value; }
        private var _radius:Number = 100;
        
        public function get color():uint { return _color; }
        public function set color(value:uint):void { _color = value; }
        private var _color:uint = 0xFFFFFF;


        public function Element() {
        }
        
        public function setup(radius:Number, color:uint):void {
            _radius = radius;
            _color  = color;
        }
        
        public function update():void {
            var g:Graphics = this.graphics;
            g.lineStyle(0, _color);
            g.drawCircle(_radius, 0, _radius);
        }
    }
