/**
 * Copyright tepe ( http://wonderfl.net/user/tepe )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/S06L
 */

package {
    import flash.display.Sprite;
    public class FlashTest extends Sprite {

        public function FlashTest() {           
            init();           
        }
        
        private function init():void{           
            // write as3 code here..
            var sb:SeekBar = new SeekBar();
            addChild(sb);
            sb.y = 100;
            sb.setSize(300,20);
            sb.length = 10000;
            sb.x = 50;
            sb.setColor(0x44aaff,0x333333);
        }

    }
}



//シークバー
    import flash.display.*;
    import flash.events.*;
    import flash.ui.*;
    import flash.text.*;
    import flash.geom.*;
    class SeekBar extends Sprite{
        private var thumb:Sprite=new Sprite();
     
        private var _width:Number = 300;
        private var _height:Number = 20;
        private var _value:Number = 1.0;
        private var color1:uint = 0x44aaff;
        private var color2:uint = 0x223388;//青
        private var color3:uint = 0xff0000;//シークポイント
        private var isSlide:Boolean;
        private var isOver:Boolean;
        private var _length:Number = 1.0;
        private var info:InfoLabel = new InfoLabel();
        public function SeekBar(){
            init();
            this.mouseChildren = false;
        }
        private function init():void{
            draw();
            this.addEventListener(MouseEvent.MOUSE_OVER,onMouse);
            this.addEventListener(MouseEvent.MOUSE_OUT,outMouse);
            this.addEventListener(MouseEvent.MOUSE_DOWN,onDown);
            this.addEventListener(MouseEvent.MOUSE_MOVE,onMove);
        }

        
        public function setSize(w:Number=300,h:Number=20):void{
            _width = w;
            _height= h;
            draw(_value);
        }
        public function setColor(c1:uint,c2:uint=0x333333,c3:uint=0xff0000):void{
            color1 = c1;
            color2 = c2;
            color3 = c3;
            draw(_value);
        }
        
        public function set length(n:Number):void{
            _length=n;
            _value = 0;
            draw(_value);
        }

        public function get length():Number{
            return _length;
        }


        
        public function set value(n:Number):void{
            if(isSlide)return;
            _value=n;
            if(n<0)_value=0;
            if(_length<n)_value=_length;
            draw(_value);
        }
        
        public function get value():Number{
            return _value;
        }
        

        //シークバー描画
        private function draw(n:Number=0):void{
            
            var p:Number=n;
            if(p<0)p=0;
            if(_length<p)p=_length;
            var par:Number = p/_length;
            
            with(this.graphics){
                clear();
                
                beginFill(color1,0);
                drawRect(-30,-20,_width+60,_height+40);
                endFill();
                
                beginFill(color1);
                drawRect(0,0,_width,_height);
                endFill();
                
                beginFill(color2);
                //drawRect(0,0,seekWidth*par,10);
                drawRect(_width*par,0,_width*(1.0-par),_height);
                endFill();
                
            }
        }
        
        //シークポイントの描画
        private function draw2():void{
            var sx:Number = this.mouseX;
            if(sx<0)sx=0;
            if(_width<sx)sx=_width;
            var t:Number = _length * (sx/_width);
            var s:int = Math.floor(t%60);
            var m:int = Math.floor((t/60)%60);
            var h:int = Math.floor(t/3600);
            var str:String = new String();
            if(3600<_length)str += h.toString()+":";
            if(60<_length)str += m.toString()+":";
            str += s.toString();
            
            info.text =str;
            info.x = sx;
            with(this.graphics){
                //clear();
                beginFill(color3);
                //drawRect(_width*par,-10,2,30);
                drawRect(sx,0,3,_height);
                endFill();
            }
        }

        
        //シーク
        private function onDown(e:MouseEvent):void{
            this.addEventListener(MouseEvent.MOUSE_UP, onUp, false, 0, true);
            stage.addEventListener(MouseEvent.MOUSE_UP, onUp, false, 0, true);
            stage.addEventListener(Event.MOUSE_LEAVE, leave, false, 0, true);
        
            value = _length * (this.mouseX/_width);
            isSlide=true;
            //this.addEventListener(MouseEvent.MOUSE_MOVE,onMove);
        }
        private function onUp(e:MouseEvent):void{
            var e2:CompoEvent = new CompoEvent(CompoEvent.SELECT, _value);
            dispatchEvent(e2);
            this.removeEventListener(MouseEvent.MOUSE_UP, onUp);
            stage.removeEventListener(MouseEvent.MOUSE_UP, onUp);
            stage.removeEventListener(Event.MOUSE_LEAVE, leave);
            isSlide=false;
            //this.removeEventListener(MouseEvent.MOUSE_MOVE,onMove);
        }
        private function leave(e:Event):void {
            //thumb.stopDrag();
            //checkValue();
            var e2:CompoEvent = new CompoEvent(CompoEvent.SELECT, _value);
            dispatchEvent(e2);
            this.removeEventListener(MouseEvent.MOUSE_UP, onUp);
            stage.removeEventListener(MouseEvent.MOUSE_UP, onUp);
            stage.removeEventListener(Event.MOUSE_LEAVE, leave);
            //isSlide=false;
        }
        private function onMove(e:MouseEvent):void{
            if(isSlide)_value = _length * (this.mouseX/_width);
            draw(_value);
            draw2();
        }



        
        private function onMouse(e:MouseEvent):void{
            Mouse.cursor = MouseCursor.BUTTON;
            isOver=true;
            this.addChild(info);
        }
        private function outMouse(e:MouseEvent):void{ 
            
            Mouse.cursor = MouseCursor.AUTO;
            isOver=false;
            draw(_value);
            this.removeChild(info);
        }


    }

//////////////////////////////////////////////////
// CompoEventクラス
//////////////////////////////////////////////////

import flash.events.Event;

class CompoEvent extends Event {
    public static const SELECT:String = "select";
    public static const CHANGE:String = "change";
    public var value:*;

    public function CompoEvent(type:String, value:*) {
        super(type);
        this.value = value;
    }

    public override function clone():Event {
        return new CompoEvent(type, value);
    }

}




//////////////////////////////////////////////////
//  吹出し
//////////////////////////////////////////////////

import flash.text.*;
import flash.display.*;
class InfoLabel extends Sprite{
    private var _text:String ="";
    public function InfoLabel(str:String=""){
        _text = str;
        this.mouseEnabled = this.mouseChildren = false;
        draw();
    }
    public function set text(str:String):void{
        _text = str;
        draw();
    }

    //描画
    private function draw():void{
        while(0<this.numChildren)this.removeChildAt(0);
        var tf:TextField = new TextField();
        tf = new TextField();
        tf.selectable = false;
        tf.text = _text;
        tf.width = tf.textWidth+5;
        tf.height = tf.textHeight+5;
        
        var c:uint = 0xdddddd;     
        var x1:Number= tf.width/2;
        var y1:Number= tf.height+15;
        var x2:Number= x1-5;
        var x3:Number= x1+5;
        var y2:Number= tf.height+5;
        
        
        var s:Sprite = new Sprite();
        with(s.graphics){
            clear();
            beginFill(c);
            drawRoundRect(-10,-5,tf.width+20,tf.height+10,10,10);

            endFill();
            beginFill(c);
            moveTo(x2,y2);
            lineTo(x3,y2)
            lineTo(x1,y1);
            lineTo(x2,y2);
            endFill();
        }
        s.addChild(tf);
        s.x = -x1;
        s.y = -y1;
        s.alpha = 0.8;
        this.addChild(s);
        
    }


}




