/**
 * Copyright adkOHTAH ( http://wonderfl.net/user/adkOHTAH )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/Rh3Q
 */

// forked from ProjectNya's SoundMixer.computeSpectrumとByteArray (6)
////////////////////////////////////////////////////////////////////////////////
// SoundMixer.computeSpectrumとByteArray (6)
////////////////////////////////////////////////////////////////////////////////

package {

    import flash.display.Sprite;
    import flash.display.Shape;
    import flash.events.Event;
    import flash.media.Sound;
    import flash.media.SoundChannel;
    import flash.media.SoundLoaderContext;
    import flash.media.SoundMixer;
    import flash.utils.ByteArray;
    import flash.net.URLRequest;
    import frocessing.color.ColorHSV;

    [SWF(backgroundColor="#000000", width="465", height="465", frameRate="30")]

    public class Main extends Sprite {
        private var sound:Sound;
        private var channel:SoundChannel;
        private static var soundPath:String = "http://www.andrewkostuik.com/rombo2.mp3";
        private var byteArray:ByteArray;
        private var rects:Array;
        private static var channels:uint = 256;
        private var color:ColorHSV;

        public function Main() {
            Wonderfl.capture_delay(10);
            init();
        }

        private function init():void {
            graphics.beginFill(0x000000);
            graphics.drawRect(0, 0, 465, 465);
            graphics.endFill();
            rects = new Array();
            for (var c:uint = 0; c < 2; c++) {
                for (var y:uint = 0; y < 16; y ++) {
                    for (var x:uint = 0; x < 16; x ++) {
                        var rect:Rect = new Rect(40);
                        addChild(rect);
                        rect.x = 25 + 40*c+ 25*x;
                        rect.y = 25 + 40*c + 25*y;
                        rect.scale = 0;
                        rects.push(rect);
                    }
                }
            }
            sound = new Sound();
            sound.addEventListener(Event.COMPLETE, complete, false, 0, true);
            sound.load(new URLRequest(soundPath), new SoundLoaderContext(10, true));
            byteArray = new ByteArray();
            color = new ColorHSV(0);
        }
        private function complete(evt:Event):void {
            evt.target.removeEventListener(Event.COMPLETE, complete);
            start();
        }
        private function start():void {
            channel = sound.play(0, 5);
            addEventListener(Event.ENTER_FRAME, update, false, 0, true);
        }
        private function update(evt:Event):void {
            SoundMixer.computeSpectrum(byteArray, true, 1);
            for (var c:uint = 0; c < 2; c++) {
                color.h = 200 + 40*c;
                for (var n:uint = 0; n < channels; n++) {
                    var p:Number = byteArray.readFloat();
                    var rect:Rect = rects[channels*c + n];
                    rect.scale = p;
                    color.v = p*2;
                    rect.color = color.value;
                }
            }
        }

    }

}


import flash.display.Shape;
import flash.geom.ColorTransform;

class Rect extends Shape {
    private var size:uint;
    private var _scale:Number = 1;
    private var colorTrans:ColorTransform = new ColorTransform();
    
    public function Rect(s:uint) {
        size = s;
        draw();
    }
    private function draw():void {
        graphics.beginFill(0xFFFFFF);
        graphics.drawRect(-size/2, -size/2, size, size);
        graphics.endFill();
    }
    public function get scale():Number {
        return _scale;
    }
    public function set scale(param:Number):void {
        _scale = param;
        scaleX = scaleY = _scale;
    }
    public function set color(param:Number):void {
        colorTrans.color = param;
        transform.colorTransform = colorTrans;
    }

}