/**
 * Copyright hakerlab ( http://wonderfl.net/user/hakerlab )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/QxAs
 */

// forked from okoi's マッキー的なもの
//
//    黒マジック的な
//
package 
{
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    
    [SWF(width = "465", height = "465")]
    
    /**
     * ...
     * @author 
     */
    public class Main extends Sprite 
    {
        private var _sprite:Sprite;
        
        private var _pen:Pen;
        
        public function Main():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            // entry point
            
            _sprite = new Sprite();
            addChild(_sprite );
            
            _pen = new Pen( _sprite );
            
            stage.addEventListener(MouseEvent.MOUSE_DOWN, MouseDown);
            stage.addEventListener(MouseEvent.MOUSE_UP, MouseUp);
            addEventListener(Event.ENTER_FRAME, EnterFrame);
        }
        
        private function MouseDown( e:MouseEvent ) : void
        {
            _pen.Start( stage.mouseX, stage.mouseY );
        }
        private function MouseUp( e:MouseEvent ) : void
        {
            _pen.End();
        }
        private    function EnterFrame(e:Event):void
        {
            //_sprite.graphics.clear();
            _pen.Move( stage.mouseX, stage.mouseY );
        }
        
    }
    
}
import flash.display.Sprite;
import flash.geom.Point;

class Pen {
    
    private var _before:Point;
    private var _beforeSize:Number;
    private var _now:Point;
    private var _nowSize:Number;
    
    private var _sprite:Sprite;
    private var _drawing:Boolean;
    public function get drawing():Boolean { return    _drawing;    }
    
    private static const DEF_SIZE:int = 1;
    
    public function Pen(sp:Sprite) {
        _before = new Point();
        _now = new Point();
        _sprite = sp;
        _drawing = false;
    }
    
    public function Start(mx:Number, my:Number) : void
    {
        _before.x = mx;
        _before.y = my;
        _now.x = mx;
        _now.y = my;
        _drawing = true;
        _nowSize = DEF_SIZE;
        _beforeSize = DEF_SIZE;
    }
    
    public function End() : void
    {
        _drawing = false;
    }
    
    public function Move(mx:Number, my:Number) : void
    {
        if ( !_drawing )    return;
        
        var length:Number = Math.sqrt( (_now.x - mx) * (_now.x - mx) + (_now.y - my) * (_now.y - my) );
        
        if ( length < 0.1 ) return;
        _before.x = _now.x;
        _before.y = _now.y;
        _now.x = mx;
        _now.y = my;
        
        
        //    サイズ決定
        _beforeSize = _nowSize;
        _nowSize = (((length / 20) * 5 + DEF_SIZE) - _beforeSize)*0.2 + _beforeSize;
        
        
        var angleRad:Number = Math.atan2( _now.y - _before.y, _now.x - _before.x );
        
        var path:/*Point*/Array = new Array();
        
        var point:Point = new Point();
        point.x = _before.x + Math.cos( angleRad + Math.PI/2 ) * _beforeSize;
        point.y = _before.y + Math.sin( angleRad + Math.PI/2 ) * _beforeSize;
        path.push( point );
        
        point = new Point();
        point.x = _before.x + Math.cos( angleRad - Math.PI/2 ) * _beforeSize;
        point.y = _before.y + Math.sin( angleRad - Math.PI/2 ) * _beforeSize;
        path.push( point );
        
        point = new Point();
        point.x = _now.x + Math.cos( angleRad - Math.PI/2 ) * _nowSize;
        point.y = _now.y + Math.sin( angleRad - Math.PI/2 ) * _nowSize;
        path.push( point );
        
        point = new Point();
        point.x = _now.x + Math.cos( angleRad + Math.PI/2 ) * _nowSize;
        point.y = _now.y + Math.sin( angleRad + Math.PI/2 ) * _nowSize;
        path.push( point );
        

        //    描画
        _sprite.graphics.lineStyle(1, 0);
        _sprite.graphics.beginFill(0);
        _sprite.graphics.drawCircle( _now.x, _now.y, _nowSize );
        _sprite.graphics.endFill();
        _sprite.graphics.beginFill(0);
        for ( var i:int = 0; i < path.length; i++ )
        {
            if ( i == 0 )    _sprite.graphics.moveTo( path[i].x, path[i].y );
            else             _sprite.graphics.lineTo( path[i].x, path[i].y );
        }
        _sprite.graphics.lineTo( path[0].x, path[0].y );
        _sprite.graphics.endFill();
        
    }
}

