/**
 * Copyright s8t1h12akj ( http://wonderfl.net/user/s8t1h12akj )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/Qry4
 */

// forked from Sami.Al-beik's forked from: scrollRect and mask performance check
// forked from clockmaker's scrollRect and mask performance check
/**
 * scrollRect and mask performance check
 * scrollRect と mask のパフォーマンステスト
 * 結論：scrollRect と mask では速度差異は確認できず
 * @author yasu
 */
package
{
    import com.bit101.components.RadioButton;
    import flash.display.DisplayObject;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.filters.BlurFilter;
    import flash.geom.Rectangle;
    import net.hires.debug.Stats;
    
    [SWF(width=465, height=465, frameRate=100)]
    public class Main extends Sprite
    {
        private static const MAX_NUM:uint = 40000;
        private static const TEST_RECT:Rectangle = new Rectangle(0, 0, 200, 200);
        private var _btnA:RadioButton;
        private var _btnB:RadioButton;
        private var _btnC:RadioButton;
        private var _btnD:RadioButton;
        private var _rects:Vector.<RectShape>;
        private var _container:Sprite;
        private var _maskSp:Shape;
        private var _scrollRect:Rectangle;
        private var _isBlur:Boolean = false;
        
        public function Main()
        {
            _btnA = new RadioButton(this, 100, 365, "None", true, _onClick);
            _btnB = new RadioButton(this, 100, 385, "scrollRect", false, _onClick);
            _btnC = new RadioButton(this, 100, 405, "mask", false, _onClick);
            _btnD = new RadioButton(this, 100, 445, "use BlurFilter", false, _onClick);
            
            graphics.beginFill(0x0);
            graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
            
            var stats:DisplayObject = addChild(new Stats);
            stats.y = 365;
            
            _container = new Sprite();
            _container.mouseChildren = false;
            _container.mouseEnabled = false;
            addChildAt(_container, 0);
            
            _rects = new Vector.<RectShape>(MAX_NUM, true);
            
            for (var i:int = 0; i < MAX_NUM; i++) 
            {
                var o:RectShape = new RectShape();
                o.x = stage.stageWidth * Math.random() >> 0;
                o.y = stage.stageHeight * Math.random() >> 0;
                o.vx = 10 * (Math.random() - 0.5);
                o.vy = 10 * (Math.random() - 0.5);
                _container.addChild(o);
                _rects[i] = o;
            }
            
            _maskSp = new Shape();
            _maskSp.graphics.beginFill(0x0);
            _maskSp.graphics.drawRect(TEST_RECT.x, TEST_RECT.y, TEST_RECT.width, TEST_RECT.height);
            
            _scrollRect = TEST_RECT.clone();;
            
            addEventListener(Event.ENTER_FRAME, _onEnterFrame);
        }
        
        private function _onClick(e:Event):void
        {
            switch(e.currentTarget)
            {
                case _btnA:
                    _container.mask = null;
                    _container.scrollRect = null;
                    
                    _btnA.selected = true;
                    _btnB.selected = false;
                    _btnC.selected = false;
                    break;
                
                case _btnB:
                    _container.mask = null;
                    _container.scrollRect = _scrollRect;
                    
                    _btnA.selected = false;
                    _btnB.selected = true;
                    _btnC.selected = false;
                    break;
                    
                case _btnC:
                    _container.mask = _maskSp;
                    _container.scrollRect = null;
                    
                    _btnA.selected = false;
                    _btnB.selected = false;
                    _btnC.selected = true;
                    break;
                    
                case _btnD:
                    _container.filters = !_isBlur ? [new BlurFilter(8, 8, 3)] : [];
                    _btnD.selected = _isBlur = !_isBlur;
                    break
            }
        }
        
        private function _onEnterFrame(e:Event):void 
        {
            var stageW:int = stage.stageWidth;
            var stageH:int = stage.stageHeight;
            
            for (var i:int = 0; i < _rects.length; i++) 
            {
                _rects[i].x += _rects[i].vx;
                _rects[i].y += _rects[i].vy;
                
                if (_rects[i].x < 0) _rects[i].x = stageW;
                else if (_rects[i].x > stageW)  _rects[i].x = 0;
                
                if (_rects[i].y < 0) _rects[i].y = stageH;
                else if(_rects[i].y > stageH)  _rects[i].y = 0;
            }
        }
    }
}

import flash.display.Shape;
final class RectShape extends Shape {
    public var vx:Number;
    public var vy:Number;
    public function RectShape()
    {
        graphics.beginFill(0x990000, Math.random());
        graphics.drawRect(0, 0, 5, 5);
    }
}