/**
 * Copyright bradsedito ( http://wonderfl.net/user/bradsedito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/QrQ4
 */

// forked from umhr's Progression4をControllerとして使う練習3
/*
Progression4の練習。3

シーンとかページとかとはちょっと違う構成、
例えば3D空間を移動するなどの時に
Progression4をControllerとして使うとすると、
どうしたらいいんだろう。

試行錯誤中

*/
package {
    import flash.display.*;
    import flash.events.MouseEvent;
    import flash.geom.PerspectiveProjection;
    import flash.geom.Point;
    import flash.text.TextField;
    import flash.text.TextFormat;
    
    import jp.progression.*;
    import jp.progression.config.*;
    import jp.progression.debug.*;
    import jp.progression.events.*;
    import jp.progression.executors.ExecutorObjectState;
    
    [SWF(width = 465, height = 465, backgroundColor = 0x000000, frameRate = 30)]
    public class Main extends Sprite {
        public var manager:Progression;
        private var _view:View;
        private var _tf:TextField;
        public function Main() {
            
            stage.transform.perspectiveProjection = new PerspectiveProjection();
            stage.transform.perspectiveProjection.projectionCenter = new Point(465/2,465/2);
            
            Progression.initialize( new BasicAppConfig() );
            manager = new Progression( "index", stage, IndexScene );
            
            //Debugger.addTarget( manager );
            addView();
            manager.goto( manager.root.sceneId );
            manager.addEventListener(ProcessEvent.PROCESS_START, onProcessStart);
        }
        private function addView():void{
            _view = new View();
            _view.x = 465/2;
            _view.y = 465/2;
            this.addChild(_view);
            stage.addEventListener(MouseEvent.CLICK, clickHandler);
            _tf = new TextField();
            _tf.defaultTextFormat = new TextFormat("_sans",18,0xFFFFFF);
            _tf.text = "index";
            _tf.autoSize = "left";
            this.addChild(_tf);
        }
        
        
        private function clickHandler(e:MouseEvent):void {
            if (manager.state > ExecutorObjectState.IDLING) {
                manager.stop();
            }
            if(e.target.name){
                manager.goto(manager.root.scenes[int(e.target.name)].sceneId);
                return;
            }
            /*
            if (manager.current.next) {
                manager.goto(manager.current.next.sceneId);
            } else {
                manager.goto(manager.root.scenes[0].sceneId);
            }
            */
        }
        private function onProcessStart(event:ProcessEvent):void {
            _tf.text = String(manager.destinedSceneId);
            for (var i:int = 0; i < 6; i++) {
                if(manager.destinedSceneId == manager.root.scenes[i].sceneId){
                    _view.pitchStep(i);
                }
            }
        }
    }
}




import jp.progression.casts.*;
import jp.progression.commands.*;
import jp.progression.commands.display.*;
import jp.progression.commands.lists.*;
import jp.progression.commands.managers.Goto;
import jp.progression.commands.net.*;
import jp.progression.commands.tweens.*;
import jp.progression.data.*;
import jp.progression.events.*;
import jp.progression.executors.ExecutorObjectState;
import jp.progression.scenes.*;

class IndexScene extends SceneObject {
    public function IndexScene() {
        var sp:CastSprite = new CastSprite();
        sp.id = "sqIndex";
    }
    
    protected override function atSceneLoad():void {
        addCommand(
            new AddChild( container, "sqIndex" ),
            function():void {
                for (var i:int = 0; i < 6; i++) {
                    var SO:SceneObject = new SceneObject("s"+String(i));
                    addScene(SO);
                }
            }
        );
    }
    protected override function atSceneInit():void {
        addCommand();
    }
    protected override function atSceneGoto():void {
        addCommand();
    }
}

import flash.display.*;
import org.libspark.betweenas3.BetweenAS3;
import org.libspark.betweenas3.easing.*;
import org.libspark.betweenas3.tweens.ITween;

import flash.display.Sprite;
class View extends Sprite{
    private var _canvas:ViewSprite;
    private var _t:ITween;
    private var _currentStep:int;
    public function View():void{
        _canvas = new ViewSprite();
        this.addChild(_canvas);
    }
    public function pitchStep(step:int):void{
        var degree:Number = (step/6)*360;
        if(((_currentStep/6)*360-degree)<-180){
            degree = -360+degree;
        }else if(((_currentStep/6)*360-degree)>180){
            degree = 360+degree;
        }
        if (_t != null) {
            _t.stop();
            if(_canvas.rotationY-degree > 180){
                degree = 360+degree;
            }
        }
        _t = BetweenAS3.serial(
            BetweenAS3.tween(_canvas, { depth:1}, null, 0.3, Expo.easeIn),
            BetweenAS3.tween(_canvas, { rotationY:degree}, null, 0.4),
            BetweenAS3.tween(_canvas, { depth:0}, null, 0.3, Expo.easeIn)
            );
        _t.onComplete = function():void{_canvas.rotationY = (degree+360)%360};
        _t.play();
        _currentStep = step;
    }
}
import flash.geom.PerspectiveProjection;
import flash.geom.Point;
import flash.geom.Vector3D;
import flash.geom.Matrix;
import flash.events.Event;
class ViewSprite extends Sprite{
    private var _sprites:Array;
    private var _rotationY:Number = 0;
    private var _depth:Number = 0;
    public function ViewSprite():void{
        this.addEventListener(Event.ADDED_TO_STAGE,onStage);
    }
    private function onStage(event:Event):void{
        this.removeEventListener(Event.ADDED_TO_STAGE,onStage);
        this.z = 0;
        _sprites = [];
        var colors:Array = [0xFF0000, 0x00FF00, 0x0000FF, 0xFFFF00, 0x00FFFF, 0xFF00FF];
        for (var i:int = 0; i < 6; i++) {
            var sp:Sprite = new Sprite();
            sp.graphics.lineStyle(3,0xFFFFFF);
            sp.graphics.beginGradientFill("linear",[colors[i],0x000000],[1,1],[0x00,0xFF],new Matrix(0.7,0,-1,0.7));
            sp.graphics.drawRect(-190,-190,380,380);
            sp.graphics.endFill();
            sp.name = String(i);
            this.addChild(sp);
            _sprites[i] = sp;
        }
        rotationY = 0;
        
        
    }
    public function get depth():Number{
        return _depth;
    }
    public function set depth(value:Number):void{
        _depth = value;
        rotationY = _rotationY;
    }
    override public function get rotationY():Number{
        return _rotationY;
    }
    override public function set rotationY(value:Number):void{
        _rotationY = (value+360)%360;
        var n:int = _sprites.length;
        for (var i:int = 0; i < n; i++) {
            _sprites[i].x = Math.cos(Math.PI*(i/3+(90-_rotationY)/180))*350*(1+(1-_depth)/3.2);
            _sprites[i].z = Math.sin(Math.PI*(i/3+(90-_rotationY)/180))*350*_depth;
            _sprites[i].rotationY = ((((360-360*i/6+_rotationY))%180+90)%180-90)*_depth;
        }
        zSort(this);
    }
    private function zSort(target:DisplayObjectContainer):void {
        if(!target.root){return};
        var n:int = target.numChildren;
        var array:Array = [];
        var reference:Array = [];
        for (var i:int = 0; i < n; i++) {
            var poz:Vector3D = target.getChildAt(i).transform.getRelativeMatrix3D(this.root.stage).position;
            var point:Point = stage.transform.perspectiveProjection.projectionCenter;
            array[i] = poz.subtract(new Vector3D(point.x,point.y,-stage.transform.perspectiveProjection.focalLength)).length;
            reference[i] = target.getChildAt(i);
        }
        var temp:Array = array.sort(Array.NUMERIC | Array.RETURNINDEXEDARRAY);
        for (i = 0; i < n; i++) {
            target.setChildIndex(reference[temp[i]],0);
            if(reference[temp[i]].numChildren > 1){
                zSort(reference[temp[i]]);
            }
        }
        var s:int = Math.round(_rotationY/60)%6;
        for (i = 0; i < n; i++) {
            if(_sprites[i].z == 0){
                _sprites[i].visible = (Math.abs(s-i)<=1 || Math.abs(s-i) == 5);
            }else{
                _sprites[i].visible = (_sprites[i].z > 0);
            }
        }
    }
}
