/**
 * Copyright WLAD ( http://wonderfl.net/user/WLAD )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/Qqow
 */

// forked from mutantleg's flash on 2017-1-25
package {
	
	import com.bit101.components.*;
    import flash.display.Sprite;
	import flash.text.TextField;
	
	public class Main extends Sprite
	{
		private var paused:Boolean = false;
		
		private var test:FlashTest;
		
		private var tf:TextField;
		
		// Global counters 
		private var maxSteps:int = 0;
		private var runCount:int = 0;
		
		// UI
		private var sliderW:HUISlider;
		private var sliderH:HUISlider;
		private var sliderSpeed:HUISlider;
		
		public function Main()
		{
			// Background color 
			graphics.beginFill( 0xFFFFFF );
			graphics.drawRect( 0, 0, 2000, 2000 );
			
			// UI
			sliderW = new HUISlider(this, 280, 0, "W", function(_:*=null):void {
				changeVals();
			});
			sliderW.setSliderParams( 10, 26, 26 );
			sliderW.labelPrecision = 0;
			
			sliderH = new HUISlider(this, 280, 15, "H", function(_:*=null):void {
				changeVals();
			});
			sliderH.setSliderParams( 10, 24, 24 );
			sliderH.labelPrecision = 0;
			
			sliderSpeed = new HUISlider(this, 280, 30, "Speed" );
			sliderSpeed.setSliderParams( 1, 50, 1 );
			sliderSpeed.labelPrecision = 0;
			
			// Output info 
			tf = new TextField();
			addChild( tf );
			tf.text = "";
			tf.multiline = true;
			tf.autoSize = "left";
			tf.textColor = 0;
			
			// UI slider will pause frame loop, resume on mouse up.
			stage.addEventListener( 'mouseUp', function(_:*):void {
				paused = false;
				restart();
			});
			
			// Global update 
			addEventListener( 'enterFrame', update );
			
			// First run 
			restart();
		}
		
		private function update(_:*):void
		{
			if ( paused ) return;
			
			// update Gird
			var c:int = sliderSpeed.value; 
			while( c-- > 1 ) test.update( false );
			test.update( true );
			
			if ( test.steps > maxSteps ) maxSteps = test.steps;
			
			// Output info 
			tf.text = "maxSteps: " + maxSteps + "   runCount: " + runCount + "\n\n"
			+ "size: " + test.mw + " x " + test.mh + "   " 
			+ "cx: " + test.cx + "\tcy: " + test.cy + "\tsteps: " + test.steps;
			
			// Auto-restart if ended 
			if ( test.end ) restart();
		}
		
		private function restart(_:*=null):void
		{
			runCount ++; 
			if ( test ) removeChild( test );
			test = new FlashTest( sliderW.value, sliderH.value );
			test.y = 40;
			addChild( test );
		}
		
		private function changeVals():void
		{
			runCount = 0;
			maxSteps = 0;
			paused = true;
		}
	}
}
	
    import flash.display.Sprite;

	
	class FlashTest extends Sprite {
        
		public var color:uint = 0x000000;
		
        public var mw:int = 16;
        public var mh:int = 16;
		
		public var end:Boolean = false;
		
		public function FlashTest( w:int = 16, h:int = 16 ) {
            
			mw = w; mh = h;
            
            vecHeight = new Vector.<Number>(mw*mh,false);
            var i:int; var num:int; num=mw*mh;
            for (i=0; i<num;i+=1)
            { vecHeight[i] = Math.random()<0.5?1:0; }
            
            vecMark = new Vector.<int>(mw*mh,false);
            for (i=0; i<num;i+=1)
            { vecMark[i] = 0; }
        }//ctor
		
        
        public var vecHeight:Vector.<Number>;
        public var vecMark:Vector.<int>;
        
        public function getMark(ax:int, ay:int):int        
        { if (ax<0||ax>=mw||ay<0||ay>=mh){return 1;} return vecMark[ax+(ay*mw)]; }
        
        public function setMark(ax:int, ay:int, t:int):void        
        { if (ax<0||ax>=mw||ay<0||ay>=mh){return;}  vecMark[ax+(ay*mw)] = t; }

        public function getHeight(ax:int, ay:int):Number
        { if (ax<0||ax>=mw||ay<0||ay>=mh){return 0;} return vecHeight[ax+(ay*mw)]; }
        
        public function getFlag(ax:int, ay:int):int
        {
          var f:int;
           f = 0;
          if (getHeight(ax+1, ay) > 0) { f|=1; }  
          if (getHeight(ax-1, ay) > 0) { f|=2; }  
          if (getHeight(ax, ay+1) > 0) { f|=4; }  
          if (getHeight(ax, ay-1) > 0) { f|=8; }  
            
          if (f ==15){ return 0; }  
            
          return f;
        }//getflag
        
        public var cx:int = 0;
        public var cy:int = 0;
		
		public var steps:int = 0;
		
		private var pcx:int = -1;
		private var pcy:int = -1;
        
        public function update( draw:Boolean ):void
        {
            if ( draw ) 
			{
				graphics.clear();
				graphics.lineStyle(2, color);
			}
            
            var i:int; var k:int;
            for (i=0;i<mh;i+=1)
            {
             for(k=0;k<mw;k+=1)
             {   
               var h:Number;
               h = getHeight(k,i);
               if (h > 0)
			   { 
				   if ( draw ) graphics.drawCircle(32+k*16,32+i*16,4);
			   }
               if (h >0 && getMark(k,i)>0)
               {
				   if ( draw ) 
				   {
						graphics.beginFill(color, 1);
						graphics.drawCircle(32+k*16,32+i*16,4);
						graphics.endFill();
				   }
               }//endif
             
             }//nextk   
            }//nexti
            
            if ( draw ) graphics.drawCircle(32+cx*16,32+cy*16,8);
            
            if (getMark(cx,cy)==0)
            {  
              setMark(cx,cy, 1);
              
              if (getMark(cx+1, cy)==0 && getFlag(cx+1,cy) > 0)
              { cx+=1;   }
              else if (getMark(cx, cy+1)==0 && getFlag(cx,cy+1) > 0)
              { cy+=1;}
              else if (getMark(cx-1, cy)==0 && getFlag(cx-1,cy) > 0)
              { cx-=1;}
              else if (getMark(cx, cy-1)==0 && getFlag(cx,cy-1) > 0)
              { cy-=1;}
              
              //cx+=1; if (cx>=mw){cx=0;cy+=1; }
              
            }//endif
            
			if ( pcx > -1 && pcy > -1 && pcx == cx && pcy == cy ) 
			{
				end = true;
			}
            
			pcx = cx;
			pcy = cy;
			
			if( !end ) steps ++;
			
        }//onenter
        
    }//classend