/**
 * Copyright insocium ( http://wonderfl.net/user/insocium )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/QlM0
 */

// forked from k3lab's EnvironmentMaterialBox_a3d
package 
{
    import alternativ7.engine3d.controllers.SimpleObjectController;
    import alternativ7.engine3d.core.Camera3D;
    import alternativ7.engine3d.core.Object3DContainer;
    import alternativ7.engine3d.core.View;
    import alternativ7.engine3d.materials.SphericalEnvironmentMaterial;
    import alternativ7.engine3d.primitives.Box;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Loader;
    import flash.display.Sprite;
    import flash.events.ErrorEvent;
    import flash.events.Event;
    import flash.events.IOErrorEvent;
    import flash.events.SecurityErrorEvent;
    import flash.filters.BlurFilter;
    import flash.geom.Matrix;
    import flash.geom.Point;
    import flash.net.URLRequest;
    import flash.system.LoaderContext;
    /**
     * ...
     * @author k3lab
     */
    [SWF(width="465", height="465", frameRate="60", backgroundColor="0")] 
    public class Main extends Sprite 
    {
        private var TEX_URL:String = "http://www.k3lab.com/wonderfl/Amphisbaena/photo1.jpg";
        private var _loader:Loader;
        private var _scene:Object3DContainer;
        private var _camera:Camera3D;
        private var _controller:SimpleObjectController;
        private var _box:Box;
        public function Main():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            _scene = new Object3DContainer();
            _camera = _scene.addChild( new Camera3D() ) as Camera3D;
            _camera.view = addChild( new View( stage.stageWidth, stage.stageHeight ) ) as View;
            _controller = new SimpleObjectController(stage, _camera, 1);
            _camera.rotationX = -90 * Math.PI / 180;
            _camera.y = -200;
            _loader = new Loader();
            _loader.contentLoaderInfo.addEventListener(Event.COMPLETE, onLoadTexture);
            _loader.contentLoaderInfo.addEventListener(IOErrorEvent.IO_ERROR, onErrorAsset);
            _loader.contentLoaderInfo.addEventListener(SecurityErrorEvent.SECURITY_ERROR, onErrorAsset);
            _loader.load(new URLRequest(TEX_URL),new LoaderContext(true));
        }
        private function onErrorAsset(e:ErrorEvent):void {}
        private function onLoadTexture(e:Event):void {
            var bmd:BitmapData = new BitmapData(_loader.width, _loader.height);
            bmd.draw(_loader);
            var bmc:BitmapData = bmd.clone();
            var blur:BlurFilter = new BlurFilter(30, 30, 1);
            bmc.applyFilter(bmc, bmc.rect, new Point(0, 0), blur)
            var bmp:Bitmap = addChildAt(new Bitmap(bmc), 0) as Bitmap;
            bmp.x = (stage.stageWidth - bmp.width )/ 2;
            bmp.y = (stage.stageHeight - bmp.height) / 2;
            var sm:SphericalEnvironmentMaterial = new SphericalEnvironmentMaterial(null,bmd);
            _box = new Box(100, 100, 100);
            _box.setMaterialToAllFaces(sm);
            _box.calculateVerticesNormals();
            _scene.addChild(_box);
            addEventListener(Event.ENTER_FRAME, loop);
        }
        
        private function loop(e:Event):void {
            _box.rotationX += .04;
            _box.rotationY += .04;
            _box.rotationZ += .04;
            _camera.render();
        }
        
        
    }
    
}