/**
 * Copyright greentec ( http://wonderfl.net/user/greentec )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/QlAe
 */

package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Rectangle;
    import flash.net.URLLoader;
    import flash.net.URLRequest;
    import flash.utils.ByteArray;
    
    public class FlashTest extends Sprite {
        
        public var _width:int = 233;
        public var _height:int = 233;
        
        public var dotArray:Array;
        public var voronoiBitmapData:BitmapData;
        
        public var colorArray:Array;
        public var isEnded:Boolean = false;
        
        public function FlashTest() {
            // write as3 code here..
            
            var back:BitmapData = new BitmapData(465, 465, false, 0x292929);
            addChild(new Bitmap(back));
            
            voronoiBitmapData = new BitmapData(465, 465, false, 0x292929);
            addChild(new Bitmap(voronoiBitmapData));
            
            var loader:URLLoader = new URLLoader();
            loader.addEventListener(Event.COMPLETE, colorTableLoadComplete);
            loader.load(new URLRequest("http://www.colourlovers.com/api/colors/new"));
            
        }
        
        private function colorTableLoadComplete(e:Event):void
        {
            var xml:XML = new XML(e.currentTarget.data);
            var len:int = xml.color.length();
            var i:int;
            var code:uint;
            
            colorArray = [];
            
            for (i = 0; i < len; i += 1)
            {
                code = parseInt(xml.color[i].hex, 16);
                colorArray.push(code);
            }
            
            initDot();
            placeDot();
            
            addEventListener(Event.ENTER_FRAME, onLoop);
            stage.addEventListener(MouseEvent.CLICK, onReset);
        }
        
        private function onReset(e:MouseEvent):void
        {
            if (isEnded == true)
            {
                var i:int;
                var j:int;
                
                for (i = 0; i < _width; i += 1)
                {
                    for (j = 0; j < _height; j += 1)
                    {
                        dotArray[i][j] = -1;
                    }
                }
                
                placeDot();
                
                voronoiBitmapData.fillRect(voronoiBitmapData.rect, 0x292929);
                
                isEnded = false;
                addEventListener(Event.ENTER_FRAME, onLoop);
            }
        }
        
        private function initDot():void
        {
            var i:int;
            var j:int;
            
            dotArray = [];
            
            for (i = 0; i < _width; i += 1)
            {
                dotArray[i] = [];
                
                for (j = 0; j < _height; j += 1)
                {
                    dotArray[i].push( -1);
                }
            }
        }
        
        private function placeDot():void
        {
            var i:int;
            var len:int = colorArray.length * 4;
            var randX:int;
            var randY:int;
            
            for (i = 0; i < len; i += 1)
            {
                randX = Math.random() * _width;
                randY = Math.random() * _height;
                
                if (dotArray[randX][randY] == -1)
                {
                    dotArray[randX][randY] = int(i / 4);
                }
            }
            
        }
        
        private function onLoop(e:Event):void
        {
            if (isEnded == false)
            {
                addDot();
                draw();
            }
        }
        
        private function addDot():void
        {
            var i:int;
            var j:int;
            
            var cloneDotArray:Array;
            cloneDotArray = clone(dotArray);
            
            var neighbor:Array;
            var randNeighbor:int;
            var changedCell:int = 0;
            
            for (i = 0; i < _width; i += 1)
            {
                for (j = 0; j < _height; j += 1)
                {
                    if (dotArray[i][j] != -1)
                    {
                        continue;
                    }
                    
                    neighbor = [];
                    
                    if (i > 0 && dotArray[i - 1][j] != -1)
                    {
                        neighbor.push(dotArray[i - 1][j]);
                    }
                    if (i < _width - 1 && dotArray[i + 1][j] != -1)
                    {
                        neighbor.push(dotArray[i + 1][j]);
                    }
                    if (j > 0 && dotArray[i][j - 1] != -1)
                    {
                        neighbor.push(dotArray[i][j - 1]);
                    }
                    if (j < _height - 1 && dotArray[i][j + 1] != -1)
                    {
                        neighbor.push(dotArray[i][j + 1]);
                    }
                    
                    if (neighbor.length == 0)
                    {
                        continue;
                    }
                    
                    randNeighbor = neighbor[int(Math.random() * neighbor.length)];
                    
                    cloneDotArray[i][j] = randNeighbor;
                    changedCell += 1;
                }
            }
            
            if (changedCell == 0)
            {
                isEnded = true;
                removeEventListener(Event.ENTER_FRAME, onLoop);
                return;
            }
            
            dotArray = clone(cloneDotArray);
        }
        
        private function draw():void
        {
            var i:int;
            var j:int;
            
            for (i = 0; i < _width; i += 1)
            {
                for (j = 0; j < _height; j += 1)
                {
                    if (dotArray[i][j] != -1)
                    {
                        voronoiBitmapData.fillRect(new Rectangle(i * 2, j * 2, 2, 2), colorArray[dotArray[i][j]]);
                    }
                }
            }
        }
        
        public function clone(source:Object):*
        {
            var myBA:ByteArray = new ByteArray();
            myBA.writeObject(source);
            myBA.position = 0;
            return(myBA.readObject()); 
        }
    }
}