/**
 * Copyright jmbyh521 ( http://wonderfl.net/user/jmbyh521 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/QfaP
 */

// forked from HaraMakoto's MCのスケールをBitmapDataの色の値にする
package {

    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.MovieClip;
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.ColorTransform;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    
    import mx.core.BitmapAsset;
        
    [SWF(width="465", height="465", backgroundColor="0x000000", frameRate="40")]
    public class TileClock2 extends Sprite {
        
        
        private var vectorDat:BitmapData;
        private var bmp:Bitmap;
        private var bmpW:Number = 465;
        private var bmpH:Number = 465;
        /**
         * Tile
         */
        //タイルを入れる配列
        private var tileArray:Array = new Array();
        private var tileW:int = 30;
        private var tileH:int = 30;
        private var tileNum:Number = tileW * tileH;
        private var tileBase:Sprite = new Sprite();
        private var speed:Array = new Array();
        private var back:Sprite = new Sprite();
        
        /**
         * param
         */
        private var scaleNum:Number; //bmpDataの拡大率・・というかbmpd取得座標の縮小率
        /**
         * Anime
         */
        private var rand:Number = Math.floor(Math.random() * 0xFFFF);
        private var offset:Array = [
            new Point(0,0),
            new Point(0,0)
        ];

        public function TileClock2() {
            initialize();
            addChild(back);
            addChild(tileBase);
            addEventListener(Event.ADDED_TO_STAGE, addStageHandler);
        }
        
        private function addStageHandler(e:Event):void
        {
            removeEventListener(Event.ADDED_TO_STAGE, addStageHandler);
            stageResizeHandler(null);
            makeTiles();
        }
        private function stageResizeHandler(e:Event):void
        {
            var W:Number = stage.stageWidth;
            var H:Number = stage.stageHeight;
            var tempScw:Number = bmpW / W;
            var tempSch:Number = bmpH / H;
            scaleNum = Math.min(tempScw, tempSch);
            back.graphics.clear()
            back.graphics.beginFill(0x000000);
            back.graphics.drawRect(0,0,W,H);
            back.graphics.endFill();
        }
        
        private function makeTiles():void
        {
            var margin:Number = 10;
            var stW:Number = stage.stageWidth - margin/2;
            var stH:Number = stage.stageHeight - margin/2;
            var wUnit:Number = stW / tileW;
            var hUnit:Number = stH / tileH;
            for( var i:int=0; i<tileNum; i++) {
                var mc:tileUnit = new tileUnit();
                tileBase.addChild(mc);
                tileArray.push( mc );
                mc.x = margin + wUnit * (i%tileW);
                mc.y = margin + hUnit * int(i/tileW);
            }
        }
        
        private function initialize():void {

            stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode = StageScaleMode.NO_SCALE;

            //ビットマップ配置
            vectorDat = new BitmapData(456,456);
            bmp= new Bitmap( vectorDat );
            
            addEventListener( Event.ENTER_FRAME, loop );
        }
        private function loop( e:Event ):void {
            var i:int;
            
            // オフセットを少しだけ移動
            offset[0].x += 2;
            offset[1].y += 5;
            
            // Perlinノイズを発生させる
            vectorDat.perlinNoise(64 ,64 , 2 , rand , false , true , (8|4|2|1) , true , offset);
            
            //タイルの数だけくりかえし
            for(i=0; i< tileNum; i++) {
                var mm:tileUnit = tileArray[i];
                
                var col:Number = vectorDat.getPixel( mm.x*scaleNum, mm.y*scaleNum );
                var r:uint = col >> 16 & 0xff;
                var g:uint = col >> 8 & 0xff;
                var b:uint = col & 0xff;
                
                //タイルのスケール = 色の数値
                mm.myScale = ( r ) * 0.004;
                mm.handleEnterFrame();
            }
            
        }

    }
}

import flash.geom.Point;
import flash.display.MovieClip;

class tileUnit extends MovieClip {
    // ばね係数
    private var SPRING_CONST:Number = 0.11;
    // 慣性
    private var FRICTION:Number = 0.89;
    private var v:Number = 0;
    public var myScale:Number;
    
    public function tileUnit()
    {
        drawMe();
    }
    
    private function drawMe():void
    {
        this.graphics.beginFill(0xFFFFFF);
        this.graphics.drawCircle(0,0,4);
        this.graphics.endFill();
    }
    public function handleEnterFrame():void
    {
        applyScale();
    }
    private function applyScale():void
    {
        var scaledis:Number = myScale - this.scaleX;
        var a:Number = SPRING_CONST * scaledis; //加速度
        v += a; //加速度を速度に加算
        v *= FRICTION;
        
        this.scaleX += v;
        this.scaleY += v;
    }
}