/**
 * Copyright applicott ( http://wonderfl.net/user/applicott )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/Qcl4
 */

package
{
	import flash.display.BitmapData;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.TimerEvent;
	import flash.filters.BlurFilter;
	import flash.geom.ColorTransform;
	import flash.geom.Matrix;
	import flash.geom.Point;
	import flash.geom.Rectangle;
	import flash.utils.Timer;
	import frocessing.color.ColorHSV;
	import frocessing.color.FColor;
	import org.papervision3d.cameras.CameraType;
	import org.papervision3d.cameras.SpringCamera3D;
	import org.papervision3d.core.geom.Lines3D;
	import org.papervision3d.core.geom.Pixels;
	import org.papervision3d.core.geom.renderables.Line3D;
	import org.papervision3d.core.geom.renderables.Pixel3D;
	import org.papervision3d.materials.WireframeMaterial;
	import org.papervision3d.materials.special.LineMaterial;
	import org.papervision3d.materials.special.ParticleMaterial;
	import org.papervision3d.objects.primitives.Sphere;
	import org.papervision3d.objects.special.ParticleField;
	import org.papervision3d.view.BasicView;
	import org.papervision3d.view.layer.BitmapEffectLayer;
	
	[SWF(backgroundColor=0x000000, frameRate = "30")]
	public class Main extends BasicView{
		private var sphere:Sphere;
		private var line:Lines3D;
		private var angle:Number=0;
		private var hsv:ColorHSV = new ColorHSV(0,1,1);
		
		private const p:int=1;
		private const q:int=1;
		private const a:int=1300;
		private const l:Number=0.9;
		private const m:Number=1.1;
		private var c:int=0;
		private var cc:FColor=new FColor;
		
		//hanabi
		private var sx:Number;
		private var sy:Number;
		private const WIDTH:Number = 350;
		private const HEIGH:Number = 198;		
		private var _particles:Array;
		private var _canvas:BitmapData;
		private var _glow:BitmapData;
		private var _rect:Rectangle;
		private var cTra:ColorTransform;
		private var timer:Timer;
		
		private var pixels:Pixels;
		public function Main(){
			super(640,480,true,false,CameraType.SPRING);
			sphere=new Sphere(new WireframeMaterial(0x0000ff),10);
			scene.addChild(sphere);
			sphere.x=500;
			
			// レイヤー作成。PV3Dでエフェクト使うときはこれを最初に作ります
			var layer:BitmapEffectLayer=new BitmapEffectLayer(viewport, 1200, 1000, true, 0, "clear_pre", true);
			layer.clearBeforeRender=true;
			viewport.containerSprite.addLayer(layer);
			
			camera.z=-900;
			
			for (var i:Number=0; i <= 6; i+=0.02){
			var xx:Number=(2 + Math.sin(q / p * i)) * Math.cos(i) * a;
			var yy:Number=Math.cos(q / p * i) * a * 1.6;
			var zz:Number=(2 + Math.sin(q / p * i)) * Math.sin(i) * a;
		
			// Pixelsの初期化
			pixels=new Pixels(layer);
			scene.addChild(pixels);
			
			var particles:ParticleField = new ParticleField(new ParticleMaterial(0xffffff,1),1);
			scene.addChild(particles);
			
			camera.target=sphere;
			SpringCamera3D(camera).mass = 30;
			SpringCamera3D(camera).damping = 10;
			SpringCamera3D(camera).stiffness = 1;
			//Lineの色の設定
			var lineMat:LineMaterial = new LineMaterial(0x00ff00);
			//Lineを生成
			line = new Lines3D(lineMat);
			//c++;
			cc.hsv(c, 0, 1);
			var color:uint=cc.value32;
				for (var j:int=0; j < 4; j++)
				{
					var px:Pixel3D=new Pixel3D(color, xx * ((m - l) * Math.random() + l), yy * ((m - l) * Math.random() + l), zz * ((m - l) * Math.random() + l));
					pixels.addPixel3D(px);
				}
			}
			scene.addChild(line);
			startRendering();
			addEventListener(Event.ENTER_FRAME, onFrame);
					
		}
		private function onFrame(e:Event):void{
			var preX:Number = sphere.x;
			var preY:Number = sphere.y;
			var preZ:Number = sphere.z;
			//進む距離
			var dx:Number,dy:Number,dz:Number;		
			
			sphere.x = 500*Math.cos(angle);
			sphere.y = Math.sin(angle/0.99)*100;
			sphere.z = 1000*Math.tan(angle/10);
			hsv.h++;
			var i:int=0;
			var rgb:uint =hsv.toRGB().value;
//			line.materials= new LineMaterial(rgb);
			line.material = new LineMaterial(rgb);
			//新たにLineを生成する。
			//座標(preX, preY, preZ)から(sphere.x, sphere.y, sphere.z)までサイズ2の線を引く。
			line.addNewLine(2, preX, preY, preZ, sphere.x, sphere.y, sphere.z);
			angle+=0.033;
			if(angle>150)angle=-angle;
			i= line.lines.length;
			while(i--){
				var l:Line3D=line.lines[i];
				l.material.lineAlpha-=0.0012;
				if(l.material.lineAlpha<=0)
					line.removeLine(l);
				
			}
		}
		
		
		

	}
}

class Particle
{
	public var x:Number;
	public var y:Number;
	public var vx:Number;
	public var vy:Number;
	public var c:uint;
	
	public function Particle()
	{
		this.x = 0;
		this.y = 0;
		this.vx = 0;
		this.vy = 0;
		this.c = 0xFFFFFF;
	}
}