/**
 * Copyright umhr ( http://wonderfl.net/user/umhr )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/QQDc
 */

package 

{

    

    import flash.display.Shape;

    import flash.display.Sprite;

    import flash.events.Event;

    import flash.geom.PerspectiveProjection;

    import flash.geom.Point;

    import frocessing.color.FColor;

    /**

     * ...

     * @author umhr

     */

    [SWF(width = 465, height = 465, backgroundColor = 0x000000, frameRate = 60)]

    public class Canvas extends Sprite 

    {

        private var _field:Sprite = new Sprite();

        private var _shapeList:Array/*Shape*/ = [];

        private var _count:int = 0;

        private var RADTODEG:Number = 57.29577951308232;

        public function Canvas() 

        {

            init();

        }

        private function init():void 

        {

            if (stage) onInit();

            else addEventListener(Event.ADDED_TO_STAGE, onInit);

        }



        private function onInit(event:Event = null):void 

        {

            removeEventListener(Event.ADDED_TO_STAGE, onInit);

            // entry point

            graphics.beginFill(0x000000);

            graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);

            graphics.endFill();

            

            _field.x = stage.stageWidth * 0.5;

            _field.y = stage.stageHeight * 0.5;

            _field.z = 0;

            var pp:PerspectiveProjection = new PerspectiveProjection();

            pp.projectionCenter = new Point(_field.x, _field.y);

            _field.transform.perspectiveProjection = pp;

            addChild(_field);

            

            var kn:int = 4;

            for (var k:int = 0; k < kn; k++) 

            {

                var r:Number = (k + 1) * 40;

                var n:int = 10;

                for (var i:int = 0; i < n; i++) 

                {

                    var shapeY:Number = r * Math.cos(Math.PI * 1 * (i / n));

                    var dx:Number = Math.sqrt(r * r - shapeY * shapeY);

                    var m:int = 20 * (dx / r);

                    for (var j:int = 0; j < m; j++) 

                    {

                        var radian:Number = Math.PI * 2 * (j / m);

                        var shape:Shape = new Shape();

                        shape.graphics.beginFill(FColor.HSVtoValue(j * (360 / m), i / n, (k + 1) / kn), 1);

                        shape.graphics.drawCircle(0, 0, 25 * ((k + 1) / kn));

                        shape.graphics.endFill();

                        shape.x = r * (dx / r) * Math.cos(radian);

                        shape.y = shapeY;

                        shape.rotationX = -(180 * i / n+90);

                        shape.rotationY = -(radian * RADTODEG + 90);

                        shape.z = r * (dx / r) * Math.sin(radian);

                        shape.scaleX = shape.scaleY = 0.5;

                        _field.addChild(shape);

                        _shapeList.push(shape);

                    }

                }

            }

            

            trace(_shapeList.length);

            stage.addEventListener(Event.ENTER_FRAME, stage_enterFrame);

        }

        

        private function stage_enterFrame(e:Event):void 

        {

            _count ++;

            

            var index:int = 0;

            

            var kn:int = 4;

            for (var k:int = 0; k < kn; k++) 

            {

                var r:Number = (k + 1) * (55 + Math.sin(_count * 0.005) * 40);

                var n:int = 10;

                for (var i:int = 0; i < n; i++) 

                {

                    var shapeY:Number = r * Math.cos(Math.PI * 1 * (i / n));

                    var dx:Number = Math.sqrt(r * r - shapeY * shapeY);

                    var m:int = 20 * (dx / r);

                    for (var j:int = 0; j < m; j++) 

                    {

                        var radian:Number = Math.PI * 2 * (j / m) + _count * 0.005;

                        var shape:Shape = _shapeList[index];

                        shape.x = r * (dx / r) * Math.cos(radian);

                        shape.y = shapeY;

                        shape.rotationY = -(radian * RADTODEG + 90 + Math.sin(_count * 0.01) * 360);

                        shape.z = dx * Math.sin(radian);

                        index ++;

                    }

                }

            }

            zSort();

        }

        

        private function zSort():void {

            var n:int = _field.numChildren;

            var array:Array = [];

            var reference:Array = [];

            for (var i:int = 0; i < n; i++) {

                array[i] = _field.getChildAt(i).z;

                reference[i] = _field.getChildAt(i);

            }

            var temp:Array = array.sort(Array.NUMERIC | Array.RETURNINDEXEDARRAY);

            for (i = 0; i < n; i++) {

                _field.setChildIndex(reference[temp[i]],0)

            }

        }

    }

    

}