/**
 * Copyright s8t1h12akj ( http://wonderfl.net/user/s8t1h12akj )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/QPgm
 */

// forked from christian's PAN
package
{
    /*
    CLICK TO REDRAW
    ---------------
    SOUND (LENGTH 12'') IS
    LEFT  CHANNEL SAMPLED FROM _ ROBERT HOOD : WHO TAUGHT YOU MATH
    RIGHT CHANNEL SAMPLED FROM _ OVAL : LINE EXTENSION
    */

    import flash.media.*;
    import flash.events.*;
    import flash.display.*;
    import flash.net.URLRequest;
    import flash.text.TextField;

    /**  @author SPANVEGA // CHRISTIAN  **/

    [ SWF (width = '465', height = '465', backgroundColor = '0x000000', frameRate = '30')]

    public class PAN extends Sprite
    {
        private var URL : String = 'http://kouetu.sakura.ne.jp/mp3/tam-y02.mp3';

        private var W : Number, H : Number;

        private var trans : SoundTransform;
        private var chans : SoundChannel;
        private var sound : Sound;

        //

        private var lines : Shape = new Shape ();
        private var controller : Sprite;
        private var image : BitmapData;
        private var output : TextField;
        private var status : String;

        //

        private var CUR_CYCLE : Number = 0;
        private var NUM_CYCLE : uint = 8;

        private var VX : Number = 1.5;
        private var VD : Number = 1.0;
        private var _V : Number = 0;
        private var DG : Number = 0; 
        private var RD : Number;


        public function PAN ()
        {
            Wonderfl.disable_capture ();

            stage ? init () : addEventListener (Event.ADDED_TO_STAGE, init);
        }

        private function init (e : Event = null) : void
        {
            if (hasEventListener (Event.ADDED_TO_STAGE))
            {removeEventListener (Event.ADDED_TO_STAGE, init);}

            H = stage.stageHeight / 2;
            W = stage.stageWidth  / 2;

            stage.scaleMode = 'noScale';

            graphics.beginFill (0, 1);
            graphics.drawRect  (0, 0, W * 2, H * 2);

            //

            addChild (new Bitmap (image = new BitmapData (W*2, H*2, true, 0)));

            addChild (controller = new Sprite ());
            controller.graphics.beginFill (0xFFFFFF, 0.65);
            controller.graphics.drawCircle (0, 0, 5);
            controller.x = W; controller.y = H;

            addChild (output = new TextField ());
            output.textColor = 0x333333;
            output.autoSize = 'left';

            //

            sound = new Sound ();
            chans = new SoundChannel ();
            trans = new SoundTransform (1, 0);

            sound.addEventListener (Event.COMPLETE, play);
            sound.addEventListener (IOErrorEvent.IO_ERROR, ioError);
            sound.addEventListener (SecurityErrorEvent.SECURITY_ERROR, securityError);

            sound.load (new URLRequest (URL), new SoundLoaderContext (1000, false));
        }

        private function play (e : Event) : void
        {
            chans = sound.play (0, 1000);

            channels (1, 1, 1, 1);

            stage.addEventListener (MouseEvent.CLICK, reset);
            stage.addEventListener (Event.ENTER_FRAME, panning);
        }

        private function panning (e : Event) : void
        {
            RD = DG * (Math.PI / 180);

            controller.x = W + (_V * Math.cos (RD));
            controller.y = H + (_V * Math.sin (RD));

            //

            var L : Number = 1 - Math.abs ((controller.x - W) / W);
            var R : Number = 1 - Math.abs ((controller.y - H) / H);

            channels (L, L, R, R);

            //

            lines.graphics.clear ();
            lines.graphics.lineStyle (1, hsv2rgb (Math.abs (DG % 360)), L * R);
            lines.graphics.moveTo (W, H);
            lines.graphics.lineTo (controller.x, controller.y);

            image.draw (lines);

            //

            _V += VX;
            DG -= VD;

            if (_V < 0 || _V > W)
            {
                VX = -VX;

                if ((CUR_CYCLE += 0.5) == NUM_CYCLE)
                {
                    stage.removeEventListener (Event.ENTER_FRAME, panning);
                }
            }

            //

            status = Math.floor (CUR_CYCLE) + '  /  ' + NUM_CYCLE;

            output.text = 'PAN  LL / LR  |  ' + L.toFixed (2) + '  | RR / RL  |  ' + R.toFixed (2) + '  |  DRAW CYCLES  |  ' + status;
        }

        private function channels (LTL : Number = 1, LTR : Number = 0, RTR : Number = 1, RTL : Number = 0) : void
        {
            trans.leftToLeft   = LTL;
            trans.leftToRight  = LTR;
            trans.rightToRight = RTR;
            trans.rightToLeft  = RTL;

            chans.soundTransform = trans;
        }
        
        private function reset (e : MouseEvent) : void
        {
            image.fillRect (image.rect, 0);

            CUR_CYCLE = _V = DG = 0;

            VX = Math.abs (VX);

            if (!stage.hasEventListener (Event.ENTER_FRAME))
            {
                stage.addEventListener (Event.ENTER_FRAME, panning);
            }
        }

        private function hsv2rgb (h : Number = 0, s : Number = 1, v : Number = 1) : uint
        {
            var i : int = int (h / 60);
            var f : Number = h / 60 - i;
            var p : Number = v * (1 - s);
            var q : Number = v * (1 - s * f);
            var t : Number = v * (1 - s * (1 - f));

            switch (i)
            {
                case 0: return v * 0xFF << 16 | t * 0xFF << 8 | p * 0xFF << 0;
                case 1: return q * 0xFF << 16 | v * 0xFF << 8 | p * 0xFF << 0;
                case 2: return p * 0xFF << 16 | v * 0xFF << 8 | t * 0xFF << 0;
                case 3: return p * 0xFF << 16 | q * 0xFF << 8 | v * 0xFF << 0;
                case 4: return t * 0xFF << 16 | p * 0xFF << 8 | v * 0xFF << 0;
                case 5: return v * 0xFF << 16 | p * 0xFF << 8 | q * 0xFF << 0;
            }

            return 0;

            //  http://wonderfl.net/c/dtn8
        }

        private function ioError (e : IOErrorEvent) : void {}

        private function securityError (e : SecurityErrorEvent) : void {}
    }
}