/**
 * Copyright christian ( http://wonderfl.net/user/christian )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/Q0Na
 */

package 
{
    import flash.display.*;
    import flash.events.MouseEvent;
    import com.bit101.components.*;

    public class Main extends Sprite
    {
        private var slider : HUISlider;

        public function Main () 
        {
            var noise : SMOOTHNOISE = new SMOOTHNOISE (465, 465);

            addChild (new Bitmap (noise));

            with (Style) { BACKGROUND = DROPSHADOW = 0xFFFFFF; LABEL_TEXT = BUTTON_FACE = PROGRESS_BAR = 0x000000; }

            with (slider = new HUISlider (this, 10, 10, 'SIZE', function () : void { noise.generate (slider.value); }))
            { setSliderParams (1, 128, 64); labelPrecision = 0; y = stage.stageHeight - 25; width = stage.stageWidth + 10; tick = 1; }

            noise.generate (slider.value);
  
            stage.addEventListener (MouseEvent.CLICK, function () : void { noise.generate (slider.value) });
        }
    }
}

import flash.display.BitmapData;

// http://lodev.org/cgtutor/randomnoise.html (based on Smooth Noise & Turbulence parts)
    
class SMOOTHNOISE extends BitmapData
{
    private var values : Vector.<Number>;

    private var length : int;

    public function SMOOTHNOISE (width : int, height : int) : void
    {
        super (width, height, false, 0);

        length = width * height;

        values = new Vector.<Number>(length, true);
    }

    public function generate (size : int = 16) : void
    {
        randomize ();

        // smooth values

        var color : uint;

        var temp : Vector.<uint> = new Vector.<uint>(length, true);

        for (var i : int = 0; i < length; i++)
        {
            // color = smoothNoise (i / 8, j / 8) * 0xFF;

            color = turbulence (i % width, int (i / width), size) * 0x80;

            temp [i] = color << 16 | color << 8 | color;
        }

        setVector (rect, temp);
    }

    private function turbulence (x : Number, y : Number, size : Number) : Number
    {
        var value : Number = 0.0, initialSize : Number = size;

        while (size >= 1)
        {
            value += smoothNoise (x / size, y / size) * size;

            size /= 2.0;
        }

        return (value / initialSize);
    }

    private function smoothNoise (x : Number, y : Number) : Number
    {
        // get fractional part of x and y
        var fractX : Number = x % 1;
        var fractY : Number = y % 1;

        // wrap around
        var x1 : int = int (x);
        var y1 : int = int (y);

        // neighbor values
        var x2 : int = (x1 + width  - 1) % width;
        var y2 : int = (y1 + height - 1) % height;

        // smooth the noise with bilinear interpolation
        var value : Number = 0.0;
        value += fractX       * fractY       * values [y1 * width + x1];
        value += (1 - fractX) * fractY       * values [y1 * width + x2];
        value += fractX       * (1 - fractY) * values [y2 * width + x1];
        value += (1 - fractX) * (1 - fractY) * values [y2 * width + x2];

        return value; 
    }

    private function randomize () : void
    {
        for (var i : int = 0; i < length; i++) 

        values [i] = Math.random ();
    }
}