/**
 * Copyright nijitaro ( http://wonderfl.net/user/nijitaro )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/PdXD
 */

/**
 * Papervision3dメモ
 */
package {
	import flash.accessibility.Accessibility;
	// Eventクラス onRenderTickで使う
	import flash.events.*;
	// 簡単にPapervisionを使うためのクラス、本プログラムのSuperクラス
	import org.papervision3d.view.BasicView;
	// 球体
	import org.papervision3d.objects.primitives.Sphere;
	// ワイヤーフレーム
	import org.papervision3d.materials.WireframeMaterial;

	/* --------------------------------------------------
	[MEMO]
		SpriteではなくBasicViewをextendsする。BasicViewはSpriteのサブクラス
	-------------------------------------------------- */
	public class Main extends BasicView {
		// 球体用プライベート変数
		private var sphere:Sphere;
		
		// コンストラクタ
		public function Main ()
		{
			/* --------------------------------------------------
			[MEMO]
			 	sphere = new Sphere(
					// テクスチャ
					new WireframeMaterial(
						0xCC0000, // 線の色
						0.1       // 線の太さ
					),
					200,  // サイズ
					16,   // 縦の分割数
					16    // 横の分割数
				);

				// var material = new WirframeMateria(0xCC0000, 0.1);
				// sphere = new Sphere ( mateial, 200, 16, 16 );
			-------------------------------------------------- */
			// 新しい球体を作成し、sphereとする
			sphere = new Sphere( new WireframeMaterial( 0xCC0000, 0.1 ), 200, 16, 16 );
			// scene(予めBasicViewで定義されている表示エリア)に作成したsphereを追加する
			scene.addChild(sphere);
			// BasicViewの描画を開始する
			startRendering();
		}
		/* --------------------------------------------------
		[MEMO]
			BasicViewのEvent.ENTER_FRAMEのようなもの。
			これをoverrideしてフレーム毎の挙動を定義する。
		-------------------------------------------------- */
		override protected function onRenderTick (event :Event = null):void
		{
			/* --------------------------------------------------
			[MEMO]
				Papervision3dは左手座標系。
				左手をGoodの状態(親指を立てる)にして
				親指を正の方向に向けた際の、4本指指の巻き方向がそれぞれ回転方向となる
			-------------------------------------------------- */
			// X軸回転はpitch
			sphere.pitch(3);
			// Y軸回転はyaw
			sphere.yaw(1);
			// Z軸回転はroll
			sphere.roll(0.5);

			/* --------------------------------------------------
			[MEMO]
				BasicViewのonRenderTickも実行する。
				これがないと、onRenderTickが単純に上書きされてしまうので、
				もともともonRenderTickの機能を果たさない。
			-------------------------------------------------- */
			super.onRenderTick(event);
		}
	}
}