/**
 * Copyright bradsedito ( http://wonderfl.net/user/bradsedito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/Ow1e
 */

package {
    import flash.display.Sprite;
    import flash.events.MouseEvent
    public class FlashTest extends Sprite {
        public function FlashTest() {
            // write as3 code here..
            
            gamepadStick = new GamepadStick()
            gamepadStick.x = 225
            gamepadStick.y = 225
            
            addChild( gamepadStick )
            stage.focus = gamepadStick
            stage.addEventListener( MouseEvent.MOUSE_MOVE, mouseMoveHandler )
            stage.addEventListener( MouseEvent.MOUSE_UP, mouseUpHandler )
            stage.addEventListener( MouseEvent.MOUSE_DOWN, mouseDownHandler )
        }
        private var gamepadStick:GamepadStick

        private function mouseUpHandler( event:MouseEvent ):void
        {
            gamepadStick.pointerDown = false
        }
        private function mouseDownHandler( event:MouseEvent ):void
        {
            gamepadStick.pointerDown = true
        }
        private function mouseMoveHandler( event:MouseEvent ):void
        {
            gamepadStick.pointerX = mouseX
            gamepadStick.pointerY = mouseY
        }
    }
}


    
    import flash.display.Sprite
    import flash.events.Event
    import flash.events.MouseEvent
    class GamepadStick
    extends Sprite
    {
        public function GamepadStick()
        {
            core = new GamepadStickCore()
            view = new GamepadStickView(core)
            addChild( view )
            
            
            addEventListener( Event.ENTER_FRAME, _enterFrameHandler )
        }
        public var pointerX:Number = 0
        public var pointerY:Number = 0
        public var pointerDown:Boolean = false
        public var core:GamepadStickCore
        public var view:GamepadStickView
        private function _enterFrameHandler(event:Event):void
        {
            core.pointerX = pointerX
            core.pointerY = pointerY
            core.pointerDown = pointerDown
            core.centerX = this.x
            core.centerY = this.y
            core.update()
            view.update()
        }
    }
    
    class GamepadStickCore
    {
        public function GamepadStickCore(){}
        public function update():void
        {
            if( pointerDown )
            {
                var diffX:int
                var diffY:int
                
                diffX = pointerX - centerX
                diffY = pointerY - centerY
                
                radians = Math.atan2( diffY, diffX )
                
                //diffX = diffX < 0 ? -diffX : diffX
                //diffY = diffY < 0 ? -diffY : diffY
                
                radius = Math.sqrt( diffX * diffX + diffY * diffY )
                
                
                if( innerRadius < radius )
                {
                    commandYm = ( radiansYmA < radians && radians < radiansYmB ) ? true : false;
                    commandXp = ( radiansXpA < radians && radians < radiansXpB ) ? true : false;
                    commandYp = ( radiansYpA < radians && radians < radiansYpB ) ? true : false;
                    commandXm = ( radiansXmA < radians || radians < radiansXmB ) ? true : false;
                }
                
                if( outerRadius < radius )
                {
                    commandXm = false
                    commandXp = false
                    commandYm = false
                    commandYp = false
                }
            }
            else
            {
                commandXm = false
                commandXp = false
                commandYm = false
                commandYp = false
            }
        }
        public var centerX:int = 0
        public var centerY:int = 0
        public var commandXm:Boolean = false
        public var commandXp:Boolean = false
        public var commandYm:Boolean = false
        public var commandYp:Boolean = false
        public var innerRadius:int = 15
        public var outerRadius:int = 50
        public var pointerDown:Boolean = false
        public var pointerX:uint = 0
        public var pointerY:uint = 0
        public var radians:Number = 0
        /**
        スティックの各方向として取得する範囲を設定します
        たとえば radiansXmA から radiansXmB の範囲は左の入力になります。
            -0.5
        -1.0        -0.0
        +1.0        +0.0
            0.5
        */
        public var radiansXmA:Number = +0.6 * Math.PI
        public var radiansXmB:Number = -0.6 * Math.PI
        public var radiansXpA:Number = -0.4 * Math.PI
        public var radiansXpB:Number = +0.4 * Math.PI
        public var radiansYmA:Number = -0.85 * Math.PI
        public var radiansYmB:Number = -0.125 * Math.PI
        public var radiansYpA:Number = +0.125 * Math.PI
        public var radiansYpB:Number = +0.85 * Math.PI
        public var radius:Number = 0
    }
    
    
    
    import flash.display.Shape
    import flash.display.Sprite
    import flash.display.LineScaleMode
    import flash.display.CapsStyle
    import flash.display.JointStyle
    class GamepadStickView
    extends Sprite
    {
        public function GamepadStickView( core:GamepadStickCore )
        {
            this.core = core
            
            var aInnerX:Number
            var aInnerY:Number
            var aOuterX:Number
            var aOuterY:Number
            var bInnerX:Number
            var bInnerY:Number
            var bOuterX:Number
            var bOuterY:Number
            var innerRadius:Number
            var outerRadius:Number
            var radians:Number
            
            var areaColorRRGGBB:uint
            
            var borderColorRRGGBB:uint
            var borderWidth:Number
            var borderAlpha:Number
            var borderHintingEnabled:Boolean
            var borderLineScaleMode:String
            var borderCapsStyle:String
            var borderJointStyle:String
            var vertexList:Array
            
            
            borderWidth = 1
            borderAlpha = 0.5
            borderColorRRGGBB = 0x000000
            borderHintingEnabled = true
            borderCapsStyle = CapsStyle.ROUND
            borderJointStyle = JointStyle.ROUND
            borderLineScaleMode = LineScaleMode.NORMAL
            
            innerRadius = core.innerRadius
            outerRadius = core.outerRadius
            
            vertexList = []
            
            var radiansList:Array = []
            radiansList.push( core.radiansXmA )
            radiansList.push( core.radiansXmB )
            radiansList.push( core.radiansXpA )
            radiansList.push( core.radiansXpB )
            radiansList.push( core.radiansYmA )
            radiansList.push( core.radiansYmB )
            radiansList.push( core.radiansYpA )
            radiansList.push( core.radiansYpB )
            
            radians = radiansList[0]
            vertexList.push( [Math.cos(radians)*innerRadius, Math.sin(radians)*innerRadius] )
            vertexList.push( [Math.cos(radians)*outerRadius, Math.sin(radians)*outerRadius] )
            radians = radiansList[1]
            vertexList.push( [Math.cos(radians)*innerRadius, Math.sin(radians)*innerRadius] )
            vertexList.push( [Math.cos(radians)*outerRadius, Math.sin(radians)*outerRadius] )
            
            radians = radiansList[2]
            vertexList.push( [Math.cos(radians)*innerRadius, Math.sin(radians)*innerRadius] )
            vertexList.push( [Math.cos(radians)*outerRadius, Math.sin(radians)*outerRadius] )
            radians = radiansList[3]
            vertexList.push( [Math.cos(radians)*innerRadius, Math.sin(radians)*innerRadius] )
            vertexList.push( [Math.cos(radians)*outerRadius, Math.sin(radians)*outerRadius] )
            
            radians = radiansList[4]
            vertexList.push( [Math.cos(radians)*innerRadius, Math.sin(radians)*innerRadius] )
            vertexList.push( [Math.cos(radians)*outerRadius, Math.sin(radians)*outerRadius] )
            radians = radiansList[5]
            vertexList.push( [Math.cos(radians)*innerRadius, Math.sin(radians)*innerRadius] )
            vertexList.push( [Math.cos(radians)*outerRadius, Math.sin(radians)*outerRadius] )
            
            radians = radiansList[6]
            vertexList.push( [Math.cos(radians)*innerRadius, Math.sin(radians)*innerRadius] )
            vertexList.push( [Math.cos(radians)*outerRadius, Math.sin(radians)*outerRadius] )
            radians = radiansList[7]
            vertexList.push( [Math.cos(radians)*innerRadius, Math.sin(radians)*innerRadius] )
            vertexList.push( [Math.cos(radians)*outerRadius, Math.sin(radians)*outerRadius] )
            
            var shape:Shape
            shape = new Shape()
            shape.graphics.lineStyle (borderWidth, borderColorRRGGBB, borderAlpha, borderHintingEnabled, borderLineScaleMode, borderCapsStyle, borderJointStyle)
            for( var i:int=0; i<16; ++i )
            {
                shape.graphics.moveTo( vertexList[i][0], vertexList[i][1] )
                ++i
                shape.graphics.lineTo( vertexList[i][0], vertexList[i][1] )
            }
            
            shape.graphics.drawCircle(0,0,innerRadius)
            shape.graphics.drawCircle(0,0,outerRadius)
            
            shape.alpha = 0.1
            
            buttonXmAreaView = shape
            
            addChild(buttonXmAreaView)
            
            
            //
            var centerX:int = -0
            var centerY:int = -0
            
            buttonXm = new PadButton()
            buttonXp = new PadButton()
            buttonYm = new PadButton()
            buttonYp = new PadButton()
            
            buttonXm.x = - (buttonXm.width  >> 1 ) + centerX -10
            buttonXm.y = - (buttonXm.height >> 1 ) + centerY
            
            buttonXp.x = - (buttonXp.width  >> 1 ) + centerX +10
            buttonXp.y = - (buttonXp.height >> 1 ) + centerY    
            
            buttonYm.x = - (buttonYm.width  >> 1 ) + centerX
            buttonYm.y = - (buttonYm.height >> 1 ) + centerY -10
            
            buttonYp.x = - (buttonYp.width  >> 1 ) + centerX
            buttonYp.y = - (buttonYp.height >> 1 ) + centerY +10
            
            addChild( buttonXm )
            addChild( buttonXp )
            addChild( buttonYm )
            addChild( buttonYp )
        }
        public function update():void
        {
            var commandXm:Boolean
            var commandXp:Boolean
            var commandYm:Boolean
            var commandYp:Boolean
            var alphaXm:Number
            var alphaXp:Number
            var alphaYm:Number
            var alphaYp:Number
            commandXm = core.commandXm
            commandXp = core.commandXp
            commandYm = core.commandYm
            commandYp = core.commandYp
            alphaXm = 1.0
            alphaXp = 1.0
            alphaYm = 1.0
            alphaYp = 1.0
            if( commandXm ){ alphaXm = 0.5 }
            if( commandXp ){ alphaXp = 0.5 }
            if( commandYm ){ alphaYm = 0.5 }
            if( commandYp ){ alphaYp = 0.5 }
            buttonXm.alpha = alphaXm
            buttonXp.alpha = alphaXp
            buttonYm.alpha = alphaYm
            buttonYp.alpha = alphaYp
        }
        public var core:GamepadStickCore
        public var freeplayAreaView:Shape
        public var buttonXmAreaView:Shape
        public var buttonXpAreaView:Shape
        public var buttonYmAreaView:Shape
        public var buttonYpAreaView:Shape
        public var buttonXm:PadButton
        public var buttonXp:PadButton
        public var buttonYm:PadButton
        public var buttonYp:PadButton
        
    }
    
    import flash.display.Shape
    import flash.display.Sprite
    import flash.events.MouseEvent
    class PadButton
    extends Sprite
    {
        public function PadButton()
        {
            this.graphics.beginFill( 0x333333 )
            this.graphics.drawRect( 0,0,10,10 )
            this.graphics.endFill()
            //this.addEventListener( MouseEvent.
        }
    }