/**
 * Copyright Thy ( http://wonderfl.net/user/Thy )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/OskM
 */

package 
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Graphics;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.text.TextFormat;
    
    /**
     * ...
     * @author Thi
     */
    public class Main extends Sprite 
    {
        
        public function Main():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            
            // entry point
            layers()
            drawStage()
            variaveis()
            //
            interações()
        }
        
        private var layer0:Sprite = new Sprite()
        private var layer1:Sprite = new Sprite()
        private var layer2:Sprite = new Sprite()
        
        private function layers():void
        {
            stage.addChild(layer0) // background
            stage.addChild(layer1) // botões
            stage.addChild(layer2) // objetos
        }
        
        
        private var D:BitmapData = new BitmapData(720,540,false,0xFFFFFF)
        private var B:Bitmap = new Bitmap(D)
        private function drawStage():void
        {
            var S:Shape = new Shape()
            var G:Graphics = S.graphics
            var TF:TextField = new TextField()
            var TFo:TextFormat = new TextFormat()
            
            stage.scaleMode = StageScaleMode.NO_SCALE

            
            TFo.font = "Verdana"
            TFo.size = 18
            TF.autoSize = TextFieldAutoSize.LEFT
            TF.defaultTextFormat = TFo
            
            layer0.addChild(B)
            layer0.addChild(S)
            layer0.addChild(TF)
            
            //frame (60, 30; 600, 380)
            //stage (720 . 540)
            G.lineStyle(1, 0, 1, true)
            //G.drawRect(0, 0, 464, 245)
            
            //chão
            G.lineStyle(1, 0xFF0000, 1, true)
            G.moveTo(0, 220)
            G.lineTo(465, 220)
            G.lineStyle(1, 0, 1, true)
            
            //Texto (Tipo de espelho)
            TF.text = "Tipo de Espelho:"
            TF.x = 60
            TF.y = 310
            D.draw(stage)
            
            TFo.size = 16
            TF.defaultTextFormat = TFo
            TF.text = "Plano"
            TF.x = 80
            TF.y = 330
            D.draw(stage)
            
            TF.text = "Côncavo"
            TF.x = 80
            TF.y = 350
            D.draw(stage)
            
            TF.text = "Convexo"
            TF.x = 80
            TF.y = 370
            D.draw(stage)
            
            //Texto (Incidência dos Raios)
            TFo.size = 18
            TF.defaultTextFormat = TFo
            TF.text = "Incidência:"
            TF.x = 240
            TF.y = 310
            D.draw(stage)
            
            TFo.size = 16
            TF.defaultTextFormat = TFo
            TF.text = "Vértice"
            TF.x = 260
            TF.y = 330
            D.draw(stage)
            
            TF.text = "Centro"
            TF.x = 260
            TF.y = 350
            D.draw(stage)
            
            TF.text = "Foco"
            TF.x = 260
            TF.y = 370
            D.draw(stage)
            
            TF.text = "Paralelo"
            TF.x = 260
            TF.y = 390
            D.draw(stage)
            
            
            layer0.removeChild(TF)
            TF = null
            
        }
        
        private var Op1:Number
        private var Op2:Vector.<Boolean>
        private var O11:Sprite, O12:Sprite, O13:Sprite
        private var O21:Sprite, O22:Sprite, O23:Sprite, O24:Sprite
        
        private var vX:Number
        private var fX:Number
        private var cX:Number
        private var fD:Number
        private var vS:Shape, fS:Shape, cS:Shape
        private var vT:TextField, fT:TextField, cT:TextField
        
        private var espX:Number
        private var espS:Shape
        private var espD:Number
        
        private var objX:Number
        private var objH:Number
        private var objS:Sprite
        
        private var imgX:Number
        private var imgH:Number
        private var imgS:Shape
        
        private var I0S:Shape, I1S:Shape, I2S:Shape, I3S:Shape

        
        private function variaveis():void
        {
            // Opções (caixas).
            Op1 = 0 // 0 = plano, 1 = côncavo, 2 = convexo; tipo de espelho
            Op2 = new Vector.<Boolean>(4)
            Op2[0] = true
            //
            O11 = new Sprite()
            O12 = new Sprite()
            O13 = new Sprite()
            O21 = new Sprite()
            O22 = new Sprite()
            O23 = new Sprite()
            O24 = new Sprite()
            layer0.addChild(O11)
            layer0.addChild(O12)
            layer0.addChild(O13)
            layer0.addChild(O21)
            layer0.addChild(O22)
            layer0.addChild(O23)
            layer0.addChild(O24)
            // manda desenhar as opções
            optRefresh()
            
            // temporário
            var TFo:TextFormat = new TextFormat()
            TFo.font = "Verdana"
            TFo.size = 18
            
            // pontos.
            vX = stage.stageWidth*.5 // posição X do ponto Vértice (base do espelho)
            fD = 70 // distância do Vértice e do Foco
            fX = vX - fD // posição X do ponto Foco
            cX = vX - (2 * fD) // posição X do ponto Vértice
            //
            vS = new Shape()
            fS = new Shape()
            cS = new Shape()
            layer1.addChild(vS)
            layer1.addChild(fS)
            layer1.addChild(cS)
            vT = new TextField()
            fT = new TextField()
            cT = new TextField()
            vT.defaultTextFormat = TFo
            fT.defaultTextFormat = TFo
            cT.defaultTextFormat = TFo
            vT.autoSize = TextFieldAutoSize.LEFT
            fT.autoSize = TextFieldAutoSize.LEFT
            cT.autoSize = TextFieldAutoSize.LEFT
            vT.selectable = false
            fT.selectable = false
            cT.selectable = false
            vT.text = "V"
            fT.text = "F"
            cT.text = "C"
            vT.y = 220
            fT.y = 220
            cT.y = 220
            layer1.addChild(vT)
            layer1.addChild(fT)
            layer1.addChild(cT)
            // Manda desenhar os pontos
            pontRefresh()
            
            //
            
            // espelho. 
            espX = stage.stageWidth * .5 // posição X inicial do espelho
            espS = new Shape()
            layer1.addChild(espS)
            // Manda desenha o espelho
            espRefresh()
            
            //
            
            // objeto.
            objS = new Sprite()
            layer2.addChild(objS)
            objX = (stage.stageWidth * .5 - 60 ) * .5 + 60 // posição X inicial do objeto
            objH = 50 // altura H inicial do objeto
            //Manda desenha o objeto
            objRefresh()
            
            //
            
            // imagem.
            imgS = new Shape()
            layer2.addChild(imgS)
            //Manda desenha o objeto
            imgRefresh()
            
            //
            
            // raios incidentes
            I0S = new Shape()
            I1S = new Shape()
            I2S = new Shape()
            I3S = new Shape()
            layer1.addChild(I0S)
            layer1.addChild(I1S)
            layer1.addChild(I2S)
            layer1.addChild(I3S)
            // Manda desenhar as linhas
            inciRefresh()
            
            
        }
        
        private function optRefresh():void
        {
            O11.graphics.clear()
            O12.graphics.clear()
            O13.graphics.clear()
            O21.graphics.clear()
            O22.graphics.clear()
            O23.graphics.clear()
            O24.graphics.clear()
            
            O11.graphics.beginFill(0xFFFFFF)
            O12.graphics.beginFill(0xFFFFFF)
            O13.graphics.beginFill(0xFFFFFF)
            if (Op1 == 0)
            {
                O11.graphics.beginFill(0x00FF00)
            } else if (Op1 == 1)
            {
                O12.graphics.beginFill(0x00FF00)
            } else if (Op1 == 2)
            {
                O13.graphics.beginFill(0x00FF00)
            }
            
            O11.graphics.lineStyle(1, 0, 1, true)
            O12.graphics.lineStyle(1, 0, 1, true)
            O13.graphics.lineStyle(1, 0, 1, true)
            
            
            O21.graphics.beginFill(0xFFFFFF)
            O22.graphics.beginFill(0xFFFFFF)
            O23.graphics.beginFill(0xFFFFFF)
            O24.graphics.beginFill(0xFFFFFF)
            
            if (Op2[0])
            {
                O21.graphics.beginFill(0x00FF00)
            } 
            if (Op2[1])
            {
                O22.graphics.beginFill(0xFF0000)
            } 
            if (Op2[2])
            {
                O23.graphics.beginFill(0x0000FF)
            }
            if (Op2[3])
            {
                O24.graphics.beginFill(0x000000)
            }

            
            O21.graphics.lineStyle(1, 0, 1, true)
            O22.graphics.lineStyle(1, 0, 1, true)
            O23.graphics.lineStyle(1, 0, 1, true)
            O24.graphics.lineStyle(1, 0, 1, true)
            
            //Opções (Tipo de espelho)
            O11.graphics.drawRoundRect(60, 340, 10, 10, 2, 2)
            O12.graphics.drawRoundRect(60, 360, 10, 10, 2, 2)
            O13.graphics.drawRoundRect(60, 380, 10, 10, 2, 2)
            
            //Opções (Incidência)
            O21.graphics.drawRoundRect(240, 340, 10, 10, 2, 2)
            O22.graphics.drawRoundRect(240, 360, 10, 10, 2, 2)
            O23.graphics.drawRoundRect(240, 380, 10, 10, 2, 2)
            O24.graphics.drawRoundRect(240, 400, 10, 10, 2, 2)
        }
        
        private function pontRefresh():void
        {
            var G:Graphics
            
            if (Op1 == 0)
            {
                fX = 0xFFFFFF // posição X do ponto Foco
                cX = 0xFFFFFF // posição X do ponto Vértice
                //notar que a diferênça de um espelho plano pra um côncavo é que
                //seu foco e Centro valem '-infinito'
                //ao mesmo tempo que a diferêça para um convexo é que seu
                //foco e centro valem '+infinito'
            } else if (Op1 == 1)
            {
                fX = vX - fD // posição X do ponto Foco
                cX = vX - (2 * fD) // posição X do ponto Vértice
            } else 
            {
                fX = vX + fD // posição X do ponto Foco
                cX = vX + (2 * fD) // posição X do ponto Vértice
            }
            
            
            //vértice
            G = vS.graphics
            G.clear()
            G.lineStyle(1, 0)
            G.moveTo(vX, 222)
            G.lineTo(vX, 218)
            
            //foco
            G = fS.graphics
            G.clear()
            G.lineStyle(1, 0)
            G.moveTo(fX, 222)
            G.lineTo(fX, 218)
            
            //centro
            G = cS.graphics
            G.clear()
            G.lineStyle(1, 0)
            G.moveTo(cX, 222)
            G.lineTo(cX, 218)
            
            // posição X dos textos
            vT.x = vX
            fT.x = fX
            cT.x = cX
            
        }
        
        
        private function espRefresh():void
        {
            var G:Graphics = espS.graphics
            G.clear()
            G.lineStyle(1, 0)
            if (Op1 == 0)
            {
                G.moveTo(espX, 220)
                G.lineTo(espX, 30)
                //fazer o símbolo de opacidade
                G.moveTo(espX + 5, 35)
                G.lineTo(espX + 2, 32)
                G.moveTo(espX + 5, 38)
                G.lineTo(espX + 2, 35)
            } else if (Op1 == 1)
            {
                G.moveTo(espX - 5, 220)
                G.lineTo(espX,215)
                G.lineTo(espX, 35)
                G.lineTo(espX - 5, 30)
                //fazer o símbolo de opacidade
                G.moveTo(espX + 5, 40)
                G.lineTo(espX + 2, 37)
                G.moveTo(espX + 5, 43)
                G.lineTo(espX + 2, 40)
            } else 
            {
                G.moveTo(espX + 5, 220)
                G.lineTo(espX, 215)
                G.lineTo(espX, 35)
                G.lineTo(espX + 5, 30)
                //fazer o símbolo de opacidade
                G.moveTo(espX + 5, 40)
                G.lineTo(espX + 2, 37)
                G.moveTo(espX + 5, 43)
                G.lineTo(espX + 2, 40)
            }
        }
        
        private function objRefresh():void
        {
            var G:Graphics = objS.graphics
            G.clear()
            G.lineStyle(3, 0x1356A9, 1, true)
            //desenha o objeto
            G.moveTo(objX, 220)
            G.lineTo(objX, 220 - objH + 5)
            //desenhar a flecha
            G.lineTo(objX - 5, 220 - objH + 5)
            G.lineTo(objX + 5, 220 - objH + 5)
            G.lineTo(objX , 220 - objH)
            G.lineTo(objX - 5, 220 - objH + 5)
        }
        
        private function imgRefresh():void
        {
            var objD:Number = vX - objX
            var A:Number = (vX-fX) / ((vX-fX) - objD)
            
            
            // posição X e altura H da imagem
            imgX = vX + objD * A
            imgH = objH * A
            
            var G:Graphics = imgS.graphics
            G.clear()
            G.lineStyle(1, 0, .5)
            
            if (A > 0)
            {
                // Imagem virtual
                //desenha a imagem
                G.moveTo(imgX, 220)
                G.lineTo(imgX, 220 - imgH + 5)
                //desenhar a flecha
                G.lineTo(imgX - 5, 220 - imgH + 5)
                G.lineTo(imgX + 5, 220 - imgH + 5)
                G.lineTo(imgX , 220 - imgH)
                G.lineTo(imgX - 5, 220 - imgH + 5)
            } else 
            {
                // Imagem real
                //desenha a imagem
                G.moveTo(imgX, 220)
                G.lineTo(imgX, 220 - imgH - 5)
                //desenhar a flecha
                G.lineTo(imgX - 5, 220 - imgH - 5)
                G.lineTo(imgX + 5, 220 - imgH - 5)
                G.lineTo(imgX , 220 - imgH)
                G.lineTo(imgX - 5, 220 - imgH - 5)
            }
            
            
        }
        
        
        private function inciRefresh():void
        {
            var G:Graphics
            var dX:Number
            var dY:Number
            
            G = I0S.graphics
            G.clear()
            
            if (Op2[0] && imgX != Infinity)
            {
                G.lineStyle(.5, 0x00FF00, 1, true)
                G.moveTo(objX, 220 - objH)
                G.lineTo(vX, 220)
                
                dX = vX - imgX
                dY = imgH
                
                
                
                G.lineTo(vX - dX, 220 - dY)
                if (dY < 220)
                {
                    G.lineTo((vX - dX) - dX, (220 - dY) - dY)
                }
                
            }
            
            G = I1S.graphics
            G.clear()
            
            if (Op2[1] && cX > -800 && cX < 800)
            {
                G.lineStyle(.5, 0xFF0000, 1, true)
                G.moveTo(objX, 220 - objH)
                
                dX = cX - imgX
                dY = imgH
                
                
                
                
                if (imgH > 0 && imgH != Infinity)
                {
                    G.lineTo(cX, 220)
                    G.moveTo(objX, 220 - objH)
                    G.lineTo(cX - dX, 220 - dY)
                    
                    if (dY < 200)
                    {
                        G.lineTo((cX - dX) - dX, (220 - dY) - dY)
                    }
                } else if (imgH != Infinity)
                {
                    G.lineTo(cX - dX, 220 - dY)
                    if (dY < 200)
                    {
                        G.lineTo((cX - dX) - dX, (220 - dY) - dY)
                    }
                    //G.moveTo(objX, 220 - objH)
                    //G.lineTo(cX + dX, 220 - dY)
                    
                    
                }
                
                
            }
            
            G = I2S.graphics
            G.clear()
            
            if (Op2[2] && cX > -800 && cX < 800 && imgH != Infinity)
            {
                G.lineStyle(.5, 0x0000FF, 1, true)
                G.moveTo(objX, 220 - objH)
                
                G.lineTo(fX, 220)
                
                G.moveTo(objX, 220 - objH)
                G.lineTo(vX, 220 - imgH)
                
                dX = vX - imgX
                dY = imgH
                
                G.lineTo(vX - dX, 220 - dY)
                
                if (dY < 220)
                {
                    G.lineTo((vX - dX) - dX, 220 - dY)
                }
                
            }
            
            //C1,A2
            
            G = I3S.graphics
            G.clear()
            
            if (Op2[3] && cX > -800 && cX < 800 && imgH != Infinity)
            {
                G.lineStyle(.5, 0x000000, 1, true)
                G.moveTo(objX, 220 - objH)
                
                G.lineTo(vX, 220-objH)
                
                G.lineTo(fX, 220)
                
                dX = fX - imgX
                dY = imgH
                
                
                G.lineTo(fX - dX, 220 - dY)
                
                
                if (dY < 220)
                {
                    G.lineTo((fX - dX) - dX, (220 - dY) - dY)
                }
                
                
            }
            
            
            
            
        }
        
        
        
        //----------------------------------------------------------------------------------------------------
        
        private var mouseUp:Boolean
        private var objDown:Boolean
        
        private function interações():void
        {
            // Cliques nos botões
            O11.addEventListener(MouseEvent.CLICK, Oc1)
            O12.addEventListener(MouseEvent.CLICK, Oc1)
            O13.addEventListener(MouseEvent.CLICK, Oc1)
            //
            O21.addEventListener(MouseEvent.CLICK, Oc2)
            O22.addEventListener(MouseEvent.CLICK, Oc2)
            O23.addEventListener(MouseEvent.CLICK, Oc2)
            O24.addEventListener(MouseEvent.CLICK, Oc2)
            
            stage.addEventListener(MouseEvent.MOUSE_UP, mouse_up)
            
            // Arrastar o objeto
            objS.addEventListener(MouseEvent.MOUSE_DOWN, obD)
            
        }
        
        private function Oc1(e:MouseEvent):void
        {
            if (e.target == O11)
            {
                Op1 = 0
            } else if (e.target == O12)
            {
                Op1 = 1
            } else 
            {
                Op1 = 2
            }
            optRefresh()
            espRefresh()
            pontRefresh()
            imgRefresh()
            inciRefresh()
            
        }
        
        private function Oc2(e:MouseEvent):void
        {
            if (e.target == O21)
            {
                Op2[0] = !Op2[0]
            } else if (e.target == O22)
            {
                Op2[1] = !Op2[1]
            } else if (e.target == O23)
            {
                Op2[2] = !Op2[2]
            } else {
                Op2[3] = !Op2[3]
            }
            
            optRefresh()
            inciRefresh()
        }
        
        private function mouse_up(e:MouseEvent):void
        {
            mouseUp = true
            if (objDown)
            {
                objS.removeEventListener(Event.ENTER_FRAME, moverObj)
            }
        }
        
        private var objY:Number
        private function obD(e:MouseEvent = null):void
        {
            mouseUp = false
            objDown = true
            objY = mouseY
            objS.addEventListener(Event.ENTER_FRAME, moverObj)
            
        }
        
        private function moverObj(e:Event = null):void
        {
            objX = mouseX<60? 60 : mouseX > vX? vX : mouseX
            objH += objY - mouseY
            objH = objH<0? 0 : objH > 190?190 : objH
            objY = mouseY
            objRefresh()
            imgRefresh()
            inciRefresh()
        }
        
        
        
        
        
    }
    
}