/**
 * Copyright yangliu9812 ( http://wonderfl.net/user/yangliu9812 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/OhBk
 */

// forked from ProjectNya's forked from: [F-site] Sample 02 - Papervision3D
// forked from clockmaker's forked from: flash on 2010-5-30
package {

    import flash.events.Event;
    import org.papervision3d.lights.PointLight3D;
    import org.papervision3d.materials.shadematerials.FlatShadeMaterial;
    import org.papervision3d.materials.utils.MaterialsList;
    import org.papervision3d.objects.DisplayObject3D;
    import org.papervision3d.objects.primitives.Cube;
    import org.papervision3d.view.BasicView;
    import frocessing.color.ColorHSV;

    [SWF(backgroundColor="#000000", width="465", height="465", frameRate="30")]

    public class Main extends BasicView {
        private var wrap:DisplayObject3D;
        private static var radius:uint = 5000;
        private var angle:Number = 90;
        private var degree:Number = 0;
        private static var radian:Number = Math.PI/180;

        public function Main() {
            graphics.beginFill(0x000000);
            graphics.drawRect(0, 0, 465, 465);
            graphics.endFill();
            wrap = new DisplayObject3D();
            scene.addChild(wrap);
            var lighten:ColorHSV = new ColorHSV(0, 1, 1);
            var darken:ColorHSV = new ColorHSV(0, 1, 0.4);
            var light:PointLight3D = new PointLight3D();
            var m:FlatShadeMaterial;
            var ml:MaterialsList;
            for (var i:int = 0; i < 50; i++){
                //lighten.h = darken.h = 210 - 1.6*i;
                m = new FlatShadeMaterial(light, lighten.value, darken.value);
                ml = new MaterialsList({all: m});
                var cube:Cube = new Cube(ml);
                cube.x = 10000 * (Math.random() - 0.5);
                cube.y = 10000 * (Math.random() - 0.5);
                cube.z = 10000 * (Math.random() - 0.5);
                wrap.addChild(cube);
            }
            startRendering();
            camera.z = -5000;
            addEventListener(Event.ENTER_FRAME, loop, false, 0, true);
        }

        private function loop(e:Event):void {
            wrap.rotationY += 10 * (mouseX / stage.stageWidth - 0.5);
            angle --;
            degree ++;
            camera.x = Math.cos(angle*radian)*radius;
            camera.y = Math.cos(degree*radian)*radius;
            camera.z = Math.sin(angle*radian)*Math.cos(degree*radian)*radius;
        }

    }

}
