/**
 * Copyright Zebestov ( http://wonderfl.net/user/Zebestov )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/Oggw
 */

package {
    import flash.geom.Matrix;
    import flash.display.GradientType;
    import flash.display.Shape;
    import flash.geom.Point;
    import flash.events.Event;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.geom.ColorTransform;
    import flash.filters.BlurFilter;
    import flash.geom.Rectangle;
    import flash.display.Sprite;

    public class Trail extends Sprite {
        private var shapes:Array = [];
        private var phases:Array = [];
        private var shifts:Array = [];
        private var freqs:Array = [];
        private var amps:Array = [];
        private var t:Number = 0.0;
        private var ballsContainer:Sprite = new Sprite();
        private var screen:BitmapData;
        private var colorTransform:ColorTransform = new ColorTransform(1, 1, 1, 0.9);
        private var blurFilter:BlurFilter = new BlurFilter(3.0, 3.0, 1);
        private var destPoint:Point;
        private var rect:Rectangle;

        public function Trail() {
            var mtx:Matrix = new Matrix();
            mtx.createGradientBox(stage.stageWidth * 1.5, stage.stageHeight * 1.5, 0, -stage.stageWidth * 0.25, -stage.stageHeight * 0.25);

            var background:Shape = new Shape();
            background.graphics.beginGradientFill(GradientType.RADIAL, [0xffff30, 0xff0000], [1.0, 1.0],[0, 255], mtx);
            background.graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
            background.graphics.endFill();
            addChild(background);
            
            addChild(ballsContainer);
            
            for (var i:int = 0; i < 123; i++) {
                shapes[i] = createBall();
                phases[i] = Math.random() * Math.PI * 2.0;
                shifts[i] = Math.random() * stage.stageWidth;
                freqs[i] = Math.random() * 0.2 + 0.9;
                amps[i] = (0.2 + Math.random() * 0.7) * stage.stageHeight;
            
                ballsContainer.addChild(shapes[i]);
            }
            
            screen = new BitmapData(stage.stageWidth, stage.stageHeight, true, 0x00ffffff);
            var bmp:Bitmap = new Bitmap(screen);
            addChild(bmp);
            
            destPoint = new Point();
            rect = screen.rect;
            
            addEventListener(Event.ENTER_FRAME, onEnterFrameHandler);
        }

        private function onEnterFrameHandler(event:Event):void {
            t += 0.02;
            var shape:Shape;
            for (var i:int = 0; i < 123; i++) {
                shape = shapes[i];
                shape.x = shifts[i] + t * 100 * freqs[i];
                shape.x = shape.x % (stage.stageWidth + 40) - 20;
                shape.y = stage.stageHeight - Math.abs(Math.cos((t + phases[i]) * freqs[i]) * amps[i]);
            }

            screen.colorTransform(rect, colorTransform);
            screen.applyFilter(screen, rect, destPoint, blurFilter);
            screen.draw(ballsContainer, null, null, null, null, true);
        }

        private function createBall():Shape {
            var result:Shape = new Shape();
            result.graphics.beginFill(int(0xffffff * (Math.random() * 0.25 + 0.7)));
            result.graphics.drawCircle(0, 0, 5 + Math.random() * 10);
            return result;
        }
    }
}