/**
 * Copyright mutantleg ( http://wonderfl.net/user/mutantleg )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/OaUM
 */

package {
    import flash.text.TextField;
    import flash.events.MouseEvent;
    import flash.events.Event;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        public function FlashTest() {
 
         deb = new TextField();
          deb.width=320; deb.height=240;
          deb.mouseEnabled=false;
         addChild(deb);
 
         stage.addEventListener(MouseEvent.MOUSE_DOWN, onMdown);
         stage.addEventListener(MouseEvent.MOUSE_UP, onMup);
         stage.addEventListener(Event.ENTER_FRAME, onEnter);           
        }//ctor
        
        public function onMdown(e:MouseEvent):void { mbutton = 1; }
        public function onMup(e:MouseEvent):void { mbutton = 0; }
        
        public var mbutton:int = 0;
        
        public var vecThing:Vector.<xThing> = new Vector.<xThing>(4,false);
        
        public function getTile(ax:int):int
        {
          var k:int;
            k = ax / 4;
            if (k<0 || k>=4) {return -1;}
            ax -= k*4;
            if (ax<0){return -1;}
            var a:xThing;
            a = vecThing[k];
            if (a==null){ return -1;}
            return a.vecGrid[ax];
        }//gettile
 
        public function setTile(ax:int, t:int):void
        {
          var k:int;
            k = ax / 4;
            if (k<0 || k>=4) { return; }
            ax -= k*4;
            if (ax<0){return;}
           var a:xThing;
            a = vecThing[k];
            if (a==null) { 
            a = new xThing();
            vecThing[k] = a; }
            deb.text=" "+k+" "+ax;
            a.vecGrid[ax] = t;
            
        }//settile
        
        public var deb:TextField;
        
        public function onEnter(e:Event):void
        {
          var mx:Number;

          mx = stage.mouseX;

          mx  = Math.floor(mx/16)*16;
         
            
          graphics.clear();
          graphics.lineStyle(2,0);
          
          graphics.drawRect(0,128, 256, 16);
          
          graphics.drawRect(mx,16,16,16);
 
         if (mbutton > 0) { setTile(mx/16, 0xFFffFF*Math.random() ); }
          
          var i:int; var t:int;
          for (i=0;i<16;i+=1)
          {
            t = getTile(i);
            if (t<0){continue;}
            if (t>0)
            {
             graphics.beginFill(t, 1);
              graphics.drawRect(i*16,128,16,16);
             graphics.endFill();
             continue;   
            }
            graphics.drawRect(i*16,128,16,16);
          }
        }//onenter
        
    }//classend
}

internal class xThing
{
  public var vecGrid:Vector.<int> = new Vector.<int>(4, false);  
    
}//xthing
