/**
 * Copyright FLASHMAFIA ( http://wonderfl.net/user/FLASHMAFIA )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/OUjm
 */

package 
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.geom.Rectangle;


    public class ColorSpectrum extends Sprite
    {
        private var _cr : uint;
        private var _cg : uint;
        private var _cb : uint;

        private var _bmd : BitmapData;


        function ColorSpectrum()
        {
            addChild(new Bitmap(_bmd = new BitmapData(400, 360, false, 0x0)));

            drawSpectrum(1.0);
        }


        public function drawSpectrum(lum : Number) : void
        {
            _bmd.lock();


            // HSL SPECTRUM

            var size : int = (360 * 360) >> 1;

            for (var i : int = 0; i < size; i++)
            {
                var xp : int = i % 360;
                var yp : int = i / 360;

                var t : Number = yp / 180;

                hsl2rgb(xp, 1, t * lum);

                _bmd.setPixel(xp, yp, _cr << 16 | _cg << 8 | _cb);

                hsl2rgb(xp, 1 - t, 1 * lum);

                _bmd.setPixel(xp, yp + 180, _cr << 16 | _cg << 8 | _cb);
            }


            // GRAYSCALE

            var drawRect : Rectangle = new Rectangle(360, 0, 40, 1);

            for (i = 0; i < 360; i++)
            {
                drawRect.y = i;

                t = i / 360;

                hsl2rgb(0, 0, t);

                _bmd.fillRect(drawRect, _cr << 16 | _cg << 8 | _cb);
            }

            _bmd.unlock();
        }




        [Inline]
        final private function hsl2rgb(hue : Number, sat : Number, lum : Number) : void
        {
            var r : Number, g : Number, b : Number;
            var f : Number, p : Number, q : Number, t : Number;

            if (sat == 0)
            {
                r = g = b = lum;
                
                _cr = Math.round(r * 255);
                _cg = Math.round(g * 255);
                _cb = Math.round(b * 255);

                return;
            }

            hue /= 60;

            var i : int = hue;

            f = hue - i;
            p = lum * (1 - sat);
            q = lum * (1 - sat * f);
            t = lum * (1 - sat * (1 - f));

            switch (i)
            {
                case 0:
                    r = lum;
                    g = t;
                    b = p;
                    break;
                case 1:
                    r = q;
                    g = lum;
                    b = p;
                    break;
                case 2:
                    r = p;
                    g = lum;
                    b = t;
                    break;
                case 3:
                    r = p;
                    g = q;
                    b = lum;
                    break;
                case 4:
                    r = t;
                    g = p;
                    b = lum;
                    break;
                default:        // case 5:
                    r = lum;
                    g = p;
                    b = q;
                    break;
            }

            _cr = Math.round(r * 255);
            _cg = Math.round(g * 255);
            _cb = Math.round(b * 255);
        }
    }
}