/**
 * Copyright Cheshir ( http://wonderfl.net/user/Cheshir )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/OQVV
 */

package {
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.display.Graphics;
    import flash.events.Event;
    import flash.display.Sprite;
    
    public class FlashTest extends Sprite {
        
        private var start:uint = 0xFF6A00;
        private var end:uint = 0xB6FF00;
        private var step:uint = 1;
        private var steps:uint = 100;
        private var display:uint = 0xFF6A00; 
        
        public function FlashTest() {
            // Окей, давай попробуем написать функцию
            // Которая будет плавно изменять цвет FF6A00 -> B6FF00
            stage.addEventListener(Event.ENTER_FRAME, stepFunc);
        }
        private function stepFunc(e:Event):void{
            graphics.beginFill(start);
            graphics.drawRect(10,10, 50, 50);
            graphics.beginFill(end);
            graphics.drawRect(180,10,50,50);
         
            // Сперва раскладываем цвета на составляющие и вычисляем разницу между ними
            // после чего делим на количество шагов...          
            var step_R:Number = (getRed(display) - getRed(end)) / steps;
            var step_G:Number = (getGreen(display) - getGreen(end)) / steps;
            var step_B:Number = (getBlue(display) - getBlue(end)) / steps;
    
            if(step<steps){
                display = getRGB(step_R, step_G, step_B);
                step++;
            }
            graphics.beginFill(display);
            graphics.drawRect(70,10, 100,100);
        }
        private function getRed(col:uint):uint{
            return (( col >> 16 ) & 0xFF);
        }
        private function getGreen(col:uint):uint{
            return ((col >> 8) & 0xFF);
        }
        private function getBlue(col:uint):uint{
            return (col & 0xFF);
        }
        private function getRGB(r:uint, g:uint, b:uint):uint{
            return ((r << 16) | (g << 8) | b);
        }

    }
}