/**
 * Copyright mutantleg ( http://wonderfl.net/user/mutantleg )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/OFa3
 */

package {
    import flash.ui.Keyboard;
    import flash.events.KeyboardEvent;
    import flash.events.Event;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        public function FlashTest() {
            
            mw=12; mh=12;
            vecGrid = new Vector.<int>(mw*mh, false);
            
            var i:int;
            for(i=0;i<mw;i+=1)
            {
                 setWall(i,0,1); setWall(0,i,1); 
            }
            
            for (i=0;i<16;i+=1)
            { setWall(Math.random()*mw, Math.random()*mh,1); }
            
            setWall(3,3, 1);
            setWall(5,3, 1);
            setWall(3,5, 1);
            
            stage.addEventListener(KeyboardEvent.KEY_DOWN, onKdown);
            stage.addEventListener(KeyboardEvent.KEY_UP, onKup);
            stage.addEventListener(Event.ENTER_FRAME, onEnter);
        }//ctor

        public function onKdown(e:KeyboardEvent):void { vecKey[e.keyCode] = true; }
        public function onKup(e:KeyboardEvent):void { vecKey[e.keyCode] = false; }
        public function isKey(k:int):Boolean { return vecKey[k]; }
        public var vecKey:Vector.<Boolean> = new Vector.<Boolean>(512, false); 
        
        public var vecGrid:Vector.<int>;
        public var mw:int = 8;
        public var mh:int = 8;
        
        public function isWallTile(ax:int, ay:int):Boolean
        { if(ax<0||ax>=mw||ay<0||ay>=mh){return true;} return vecGrid[ax+(ay*mw)] > 0; }
        
        public function setWall(ax:int, ay:int, t:int):void
        { if(ax<0||ax>=mw||ay<0||ay>=mh){return;}  vecGrid[ax+(ay*mw)] = t; }

        public function isWall(ax:Number, ay:Number):Boolean
        { return isWallTile(Math.floor(ax/cw), Math.floor(ay/ch)); }


        public var cw:Number=32;
        public var ch:Number=32;
        public var cx:Number = 128+16+3;
        public var cy:Number = 128+16+1;        
        
        public function onEnter(e:Event):void
        {
           graphics.clear();
           graphics.lineStyle(2, 0);
            
           graphics.drawRect(0,0, mw*cw, mh*ch); 
            
           var i:int; var k:int;
           var yt:int; var t:int;
           for (i=0;i<mh;i+=1)
           {
               yt = mw*i;
               for (k=0;k<mw;k+=1)
               {
                   t = vecGrid[yt+k];
                   if (t<=0){ continue; }
                   if (t==2){ continue; }
                   graphics.beginFill(0x808080,1);
                   graphics.drawRect(k*cw,i*ch,cw,ch);
                   graphics.endFill();
               } //nextk
           } //nexti
           
           var ms:Number;
           var vx:Number; var vy:Number;
           vx=0; vy=0; ms = 2; ms = 4;  //  ms = 3.3;
           if (isKey(Keyboard.UP))    { vy =-ms; }
           if (isKey(Keyboard.DOWN))  { vy = ms; }
           if (isKey(Keyboard.LEFT))  { vx =-ms; }
           if (isKey(Keyboard.RIGHT)) { vx = ms; }
           
           
           
 
         var r:Number; 
         var wh:int;

         r = 16;
         r = 15;
         
         
         wh = 0;
         if (vx>0&&isWall(cx+r+vx,cy-r)) {  wh |=1; }
         if (vx>0&&isWall(cx+r+vx,cy+r)) {  wh |=2; }
         if (vx<0&&isWall(cx-r+vx,cy-r)) {  wh |=1; }
         if (vx<0&&isWall(cx-r+vx,cy+r)) {  wh |=2; }
 
         if (vy>0&&isWall(cx+r,cy+r+vy)) {  wh |= 8; }
         if (vy>0&&isWall(cx-r,cy+r+vy)) {  wh |= 4; }
         if (vy<0&&isWall(cx+r,cy-r+vy)) {  wh |= 8; }
         if (vy<0&&isWall(cx-r,cy-r+vy)) {  wh |= 4; }
         
         if (wh == 1 && vy == 0 ) { vy = ms; }
         if (wh == 2 && vy == 0 ) { vy = -ms; }
         if (wh == 4 && vx == 0 ) { vx = ms; }
         if (wh == 8 && vx == 0 ) { vx = -ms; }
         
         if (wh == 1 || wh == 2) { cx = Math.floor(cx/4)*4; cy = Math.floor(cy/4)*4; }
         if (wh == 4 || wh == 8) { cy = Math.floor(cy/4)*4; cx = Math.floor(cx/4)*4; }

         if (isWall(cx,cy)) { cx+=vx;cy+=vy;} 
 
 
         if (vx>0&&isWall(cx+r+vx,cy-r)) { vx = 0; }
         if (vx>0&&isWall(cx+r+vx,cy+r)) { vx = 0; }
         if (vx<0&&isWall(cx-r+vx,cy-r)) { vx = 0; }
         if (vx<0&&isWall(cx-r+vx,cy+r)) { vx = 0; }
 
         if (vy>0&&isWall(cx+r,cy+r+vy)) { vy = 0; }
         if (vy>0&&isWall(cx-r,cy+r+vy)) { vy = 0; }
         if (vy<0&&isWall(cx+r,cy-r+vy)) { vy = 0; }
         if (vy<0&&isWall(cx-r,cy-r+vy)) { vy = 0; }
         
         
         cx += vx;
         cy += vy;

         /*
         var ax:Number; var ay:Number;        
         ax = Math.floor(cx/4)*4;
         ay = Math.floor(cy/4)*4;
         if (vx==0 && vy != 0) { cx+=(ax-cx)*0.25; }
         if (vx!=0 && vy == 0) { cy+=(ay-cy)*0.25; }
         */

         graphics.drawCircle(cx,cy, r);
 
             
           
        }//onenter
        
    }//classend
}