/**
 * Copyright Akiyah ( http://wonderfl.net/user/Akiyah )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/OAlk
 */

package{
    import net.hires.debug.Stats;
    import flash.display.*;
    import flash.events.*;
    import flash.net.*;
    import flash.system.*;
    import flash.filters.*;
    import flash.geom.*;
    import org.papervision3d.lights.*;
    import org.papervision3d.core.data.UserData;
    import org.papervision3d.core.effects.view.ReflectionView;
    import org.papervision3d.core.geom.TriangleMesh3D;
    import org.papervision3d.core.proto.MaterialObject3D;
    import org.papervision3d.events.*;
    import org.papervision3d.materials.*;
    import org.papervision3d.materials.special.*;
    import org.papervision3d.materials.shadematerials.*;
    import org.papervision3d.materials.utils.MaterialsList;
    import org.papervision3d.objects.DisplayObject3D;
    import org.papervision3d.objects.primitives.*;
    import org.papervision3d.cameras.CameraType;
    import org.papervision3d.view.BasicView;

    [SWF(backgroundColor="0x303030")]
    public class Sample extends ReflectionView {
        private var loader1:Loader;
        private var loader2:Loader;
        private var loader3:Loader;
        private var drawing:Boolean = false;
        //static private var BITMAP_WIDTH:int = 800;
        static private var SEGMENT:int = 8;

        Security.loadPolicyFile("http://assets.wonderfl.net/crossdomain.xml");
        public var path:String = "http://assets.wonderfl.net/images/related_images";
        public var filename1:String = path + "/e/ed/ed1c/ed1cadf0fdd830922653b0fa2a5667315bb85ef5";
        public var filename2:String = path + "/2/29/2944/2944a982d2a8d7928f0e8add944f8d28158090e3";
        public var filename3:String = path + "/3/3c/3c5d/3c5d8408df46a3c3aa34cdfb06a938c2d7f820a1"

        public function Sample() {
            loader1 = new Loader();
            loader1.contentLoaderInfo.addEventListener(Event.COMPLETE, compHandler);
            loader1.load(new URLRequest(filename1), new LoaderContext(true));

            loader2 = new Loader();
            loader2.contentLoaderInfo.addEventListener(Event.COMPLETE, compHandler);
            loader2.load(new URLRequest(filename2), new LoaderContext(true));

            loader3 = new Loader();
            loader3.contentLoaderInfo.addEventListener(Event.COMPLETE, compHandler);
            loader3.load(new URLRequest(filename3), new LoaderContext(true));
        }

        private function compHandler(e:Event):void {
            if (loader1.content == null || loader2.content == null || loader3.content == null) {
                return;
            }

            addChild(new Stats());
            viewport.interactive = true;
            viewportReflection.filters = [new BlurFilter()];

            var obj:Cube;
            obj = createBoard(0, 50, 0, 200, 200, 0xffff0000);
            scene.addChild(obj);
            obj = createBoard(50, 100, 50, 200, 200, 0xff00ff00);
            scene.addChild(obj);
            obj = createBoard(100, 150, 100, 200, 200, 0xff0000ff);
            //obj.scaleX = 2;
            scene.addChild(obj);

            stage.addEventListener(MouseEvent.MOUSE_UP, released);
            addEventListener(Event.ENTER_FRAME, update);
        }

        public function createBoard(x:int, y:int, z:int, len1:int, len2:int, c:Number):Cube {
            //var bmpData:BitmapData = bmpData_original;//.clone();
            //var bmpData:BitmapData = Bitmap(loader1.content).bitmapData;//.clone();
            //var material1:BitmapMaterial = new BitmapMaterial(bmpData);
            //material1.interactive = true;
            //var bmpData:BitmapData = bmpData_original;//.clone();
            var bmpData:BitmapData = Bitmap(loader1.content).bitmapData.clone();
            var bmp:Bitmap = new Bitmap(bmpData);
            var material1:BitmapMaterial = new BitmapMaterial(bmp.bitmapData);
            material1.interactive = true;


            var material2:BitmapMaterial = new BitmapMaterial(Bitmap(loader2.content).bitmapData);
            var material3:BitmapMaterial = new BitmapMaterial(Bitmap(loader3.content).bitmapData);
            var materials:MaterialsList = new MaterialsList({all: material2, top:material1, bottom:material3});
            var obj:Cube = new Cube(materials, len1, len2, 5, SEGMENT, 1, SEGMENT);
            obj.x = x;
            obj.y = y;
            obj.z = z;
            var sprite:Sprite = new Sprite();
            obj.extra = sprite;
            sprite.graphics.lineStyle(5, c);
            addChild(sprite);
            obj.addEventListener(InteractiveScene3DEvent.OBJECT_PRESS, pressed);
            obj.addEventListener(InteractiveScene3DEvent.OBJECT_MOVE, moved);
            return obj;
        }

        public function pressed(event:InteractiveScene3DEvent):void {
            drawing = true;
        }
        public function released(event:MouseEvent):void {
            drawing = false;
        }

        public function moved(event:InteractiveScene3DEvent):void {
            var x:Number = event.x;
            var y:Number = event.y;
            var obj:DisplayObject3D = event.displayObject3D;
            var sprite:Sprite = Sprite(obj.extra);
            if (drawing) {
                var material:BitmapMaterial = BitmapMaterial(obj.materials.getMaterialByName("top"));
                var bmpData:BitmapData = BitmapData(material.texture);
 
                //sprite.graphics.lineStyle(5, 0xff000000);
                sprite.graphics.lineTo(x, y);
                bmpData.draw(sprite);
            }
            sprite.graphics.moveTo(x, y);
        }

        public function update(e:Event):void {
            if (!drawing) {
                var camera_length:Number = 400;
                var c:Number = (mouseX / stage.width - 1) * (Math.PI);
                var d:Number = (mouseY / stage.height + 0.5) * (Math.PI / 2 / 2);
                camera.x = Math.sin(c) * Math.cos(d) * camera_length;
                camera.z = Math.cos(c) * Math.cos(d) * camera_length;
                camera.y = Math.sin(d) * camera_length;
            }
            singleRender();
        }
    }
}

