/**
 * Copyright kihon ( http://wonderfl.net/user/kihon )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/O7FH
 */

package
{
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.KeyboardEvent;
	import flash.geom.Point;
 
	public class Main extends Sprite
	{
		private var Z_MAX:Number = 1000;
 
		private var zpos:Number = 0;
		private var vp:Point = new Point(stage.stageWidth / 2, stage.stageHeight / 2);
		private var rect:Sprite;
		private var rx:Number = 182;
		private var ry:Number = 182;
 
		public function Main()
		{
			rect = new Sprite();
			rect.graphics.lineStyle(5.0);
			rect.graphics.drawRect(0, 0, 100, 100);
			rect.graphics.endFill();
			addChild(rect);
			
			stage.addEventListener(KeyboardEvent.KEY_DOWN, onKeyDown);
			addEventListener(Event.ENTER_FRAME, onEnterFrame);
		}
		
		private function onEnterFrame(event:Event):void 
		{
			var scale:Number = (zpos - Camera.z) / Z_MAX;
			rect.scaleX = rect.scaleY = 1.0 - scale;
			rect.x = rx + (vp.x - rx) * scale;
			rect.y = ry + (vp.y - ry) * scale;
		}
		
		private function onKeyDown(event:KeyboardEvent):void 
		{
			if (event.keyCode == 38) Camera.z += 3;
			if (event.keyCode == 40) Camera.z -= 3;
		}
	}
}
 
class Camera
{
	public static var x:Number = 0;	// x,yはまだ使用しない
	public static var y:Number = 0;
	public static var z:Number = -500;
}
 