/**
 * Copyright jmbyh521 ( http://wonderfl.net/user/jmbyh521 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/O4VZ
 */

// forked from sekiryou's forked from: Creek challenge
// forked from checkmate's Creek challenge
package {
    import flash.display.MovieClip;
    import flash.events.Event;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.geom.Matrix;
    import flash.geom.Point;
    import flash.display.BlendMode;
    import flash.display.PixelSnapping;
    import flash.geom.Rectangle;
    import flash.geom.ColorTransform;
    import flash.filters.BlurFilter;

    [SWF(width = "465", height = "465", backgroundColor = "0x000000", frameRate = "30")]

    public class BeneathSpark extends MovieClip {
        private var _canvas:BitmapData;
        private var bmp:Bitmap;
        private var _particles:Array;
        private var _glow:BitmapData;
        private var _rect:Rectangle;
        private var cTra:ColorTransform;

        private var FocalLength:Number = 200;
        private var bullets:Array = [];
        private const bulletAmount:uint = 20;
        private var particles:Array = [];

        private const STAGE_WIDTH = stage.stageWidth;
        private const STAGE_HEIGHT = stage.stageHeight;
        private const STAGE_CENTER_X = stage.stageWidth / 2;
        private const STAGE_CENTER_Y = stage.stageHeight / 2;

        public function BeneathSpark()
        {
            init()
        }
        private function init():void
        {
            _particles = [];
            _canvas = new BitmapData (STAGE_WIDTH, STAGE_HEIGHT, true, 0xFFFFFF);
            bmp = new Bitmap (_canvas);
            addChild (bmp);

            _glow = new BitmapData( STAGE_WIDTH/4, STAGE_HEIGHT/4, false, 0x0);
            var bm:Bitmap = addChild(new Bitmap(_glow, PixelSnapping.NEVER, true)) as Bitmap;
            bm.scaleX = bm.scaleY = 4;
            bm.blendMode = BlendMode.ADD;

            _rect = new Rectangle(0, 0, STAGE_WIDTH, STAGE_HEIGHT);
            cTra = new ColorTransform( 0.95, 0.95, 0.95, 1.2 );

            for ( var i = 0; i < bulletAmount; i++ )
            {
                var p:bullet = new bullet();
                bullets.push( p );
                purposePoint( p );

                p.PositionY -= 280;
            }

            addEventListener(Event.ENTER_FRAME, onEventHandler);
        }
        private function createParticle( sx:Number, sy:Number, sz:Number ):void
        {
            var i:int = 120;
            while (i--) {
                var p:Particle = new Particle();
                p.PositionX = sx;
                p.PositionY = sy;
                p.PositionZ = sz;

                var radius:Number = Math.sqrt(Math.random()) * 1.3;
                var angle:Number = Math.random() * Math.PI * 2;
                var angle2:Number = Math.random() * Math.PI * 2;

                p.vx = Math.cos( angle ) * radius;
                p.vy = Math.sin( angle2 ) * radius;
                p.vz = Math.sin( angle ) * radius;

                _particles.push(p);
            }
        }
        private function purposePoint( t )
        {
            t.PurposeX = Math.random() * 120 -60;
            t.PurposeY = Math.random() * 40 -160
            t.PurposeZ = Math.random() * 120 -60;

            var rnd:Number = ( Math.random() * 2 + 2 ) / 400;
            t.vx = ( t.PurposeX - t.PositionX ) * rnd;
            t.vy = ( t.PurposeY - t.PositionY ) * rnd;
            t.vz = ( t.PurposeZ - t.PositionZ ) * rnd;
        }
        private function WtoS( t ):void
        {
            if ( t.PositionY > -FocalLength ) {
                t.scale = FocalLength / (FocalLength + t.PositionY);
                t.px = STAGE_CENTER_X + t.PositionX * t.scale;
                t.py = STAGE_CENTER_Y + t.PositionZ * t.scale;
                t.visible = true;
            } else {
                t.visible = false;
            }
        }

        private var cRot:Number = 0;
        private function onEventHandler(eventObject:Event):void
        {
            var variation:Number = 0.04;
            var ctx =  mouseX / 465;
            var cty = mouseY / 465;
            if ( ctx > 0.95 ) {
                ctx = 0.95;
            } else if ( ctx < 0.05 ) {
                ctx = 0.05;
            }
            if ( cty > 0.95 ) {
                cty = 0.95;
            } else if ( cty < 0.05 ) {
                cty = 0.05;
            }
            if ( ctx > cTra.redMultiplier ) {
                cTra.redMultiplier += variation;
            } else {
                cTra.redMultiplier -= variation;
            }
            if ( cty > cTra.greenMultiplier ) {
                cTra.greenMultiplier += variation;
            } else {
                cTra.greenMultiplier -= variation;
            }

            cTra.blueMultiplier = ( Math.sin(cRot) + 1 ) / 2 * 0.95;
            cRot += 0.01;

            var i:uint = bullets.length;
            while (i--) {
                if ( bullets[ i ].PositionY < bullets[ i ].PurposeY ) {
                    createParticle( bullets[ i ].PurposeX, bullets[ i ].PurposeY, bullets[ i ].PurposeZ );
                    bullets[ i ].launchPoint();
                    purposePoint( bullets[ i ] );
                } else {
                    bullets[ i ].PositionX += bullets[ i ].vx;
                    bullets[ i ].PositionY += bullets[ i ].vy;
                    bullets[ i ].PositionZ += bullets[ i ].vz;
                }
            }

            _canvas.lock();
            _canvas.applyFilter( _canvas, _rect, new Point(), new BlurFilter( 2.4, 2.4 ) );
            _canvas.colorTransform(_rect, cTra);

            i = _particles.length;
            while (i--) {
                var p:Particle = _particles[i];
                p.vy -= 0.06;

                p.vx *= 0.9;
                p.vy *= 0.9;
                p.vz *= 0.9;

                p.PositionX += p.vx;
                p.PositionY += p.vy;
                p.PositionZ += p.vz;

                WtoS( p );
                p.x = p.px;
                p.y = p.py;

                _canvas.setPixel32(p.x, p.y, p.c);
                if ( (p.x > stage.stageWidth || p.x < 0) || (p.y < 0 || p.y > stage.stageHeight) || Math.abs(p.vy) < -1.0 )
                {
                    this._particles.splice(i, 1);
                }
            }
            _canvas.unlock();
            _glow.draw(_canvas, new Matrix(0.25, 0, 0, 0.25));
        }
    }
}

import flash.display.Sprite;
class bullet extends Sprite
{
    public var scale:Number;

    public var PositionX:Number;
    public var PositionY:Number;
    public var PositionZ:Number;
    public var PurposeX:Number;
    public var PurposeY:Number;
    public var PurposeZ:Number;

    public var px:Number;
    public var py:Number;
    public var pz:Number;
    public var vx:Number;
    public var vy:Number;
    public var vz:Number;

    public function bullet()
    {
        launchPoint();
    }
    public function launchPoint():void {
        PositionX =  0;
        PositionY = 250
        PositionZ = 200;
    }
}

class Particle
{
    public var x:Number;
    public var y:Number;
    public var visible:Boolean;
    public var scale:Number;

    public var PositionX:Number;
    public var PositionY:Number;
    public var PositionZ:Number;

    public var px:Number;
    public var py:Number;
    public var pz:Number;
    public var vx:Number;
    public var vy:Number;
    public var vz:Number;
    public var c:uint;

    public function Particle()
    {
        this.x = 0;
        this.y = 0;
        this.vx = 0;
        this.vy = 0;
        this.vz = 0;
        this.c = 0xffffffff;
    }
}