/**
 * Copyright greentec ( http://wonderfl.net/user/greentec )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/O0wO
 */

package {
    import away3d.entities.Mesh;
    import away3d.materials.ColorMaterial;
    import away3d.primitives.CubeGeometry;
    import away3d.primitives.PlaneGeometry;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.display.StageScaleMode;
    import flash.display.StageAlign;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import away3d.cameras.Camera3D;
    import away3d.containers.Scene3D;
    import away3d.containers.View3D;
    import away3d.controllers.HoverController;
    import away3d.debug.AwayStats;
    import away3d.lights.DirectionalLight;
    import away3d.materials.lightpickers.StaticLightPicker;

    public class FlashTest extends Sprite {
        
        private var view:View3D;
        private var scene:Scene3D;
        private var camera:Camera3D;
        private var awayStats:AwayStats;
        
        private var cameraController:HoverController;
        
        private var light:DirectionalLight;
        private var lightPicker:StaticLightPicker;
        
        private var colorMaterial:ColorMaterial;
        private var cubeGeometry:CubeGeometry;
        
        //navigation variables
        private var move:Boolean = false;
        private var lastPanAngle:Number;
        private var lastTiltAngle:Number;
        private var lastMouseX:Number;
        private var lastMouseY:Number;

        //private var source:BitmapData = new BitmapData(465, 465, false, 0x000000);       

        
        public function FlashTest() {
            // write as3 code here..
            
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            
            Wonderfl.disable_capture();

            //addChild(new Bitmap(source));
           
            initEngine();
            initLight();
            initMaterial();
            initObject();
            initListener();
        }
        
        private function render(e:Event):void
        {
            if (move)
            {
                cameraController.panAngle = 0.3 * (stage.mouseX - lastMouseX) + lastPanAngle;
                cameraController.tiltAngle = 0.3 * (stage.mouseY - lastMouseY) + lastTiltAngle;
            }
            
            view.render();
            //view.renderer.queueSnapshot(source);
        }
        
        private function initMaterial():void 
        {
            colorMaterial = new ColorMaterial(0x333333);
            colorMaterial.lightPicker = lightPicker;
            colorMaterial.ambient = .2;
            colorMaterial.specular = .5;
            
            cubeGeometry = new CubeGeometry(10, 10, 10, 1, 1, 1, false);
        }
        
        private function initListener():void
        {
            stage.addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
            stage.addEventListener(MouseEvent.MOUSE_UP, onMouseUp);
            stage.addEventListener(Event.RESIZE, resizeHandler);
            addEventListener(Event.ENTER_FRAME, render);
            
            
            addChild(view);
            addChild(awayStats);
        }
        
        private function initObject():void
        {
            
            var i:int;
            var j:int;
            var cube:Mesh;
            var radius:int = 200;
            var circleRadius:int;
            var angle:Number = 0;
            var h:Number;
            
            
            cube = new Mesh(cubeGeometry, colorMaterial);
            cube.y = radius;
            scene.addChild(cube);
            
            for (i = 5; i < 180; i += 5)
            {
                h = radius * Math.sin((90 - i) / 180 * Math.PI);
                circleRadius = Math.sqrt(radius * radius - h * h);
                //trace(circleRadius);
                
                for (j = 0; j < 360; j += int(radius / circleRadius) * 8)
                {
                    cube = new Mesh(cubeGeometry, colorMaterial);
                    cube.y = h;
                    cube.x = Math.cos(j / 180 * Math.PI) * circleRadius;
                    cube.z = Math.sin(j / 180 * Math.PI) * circleRadius;
                    
                    scene.addChild(cube);
                }
                
            }
            
            cube = new Mesh(cubeGeometry, colorMaterial);
            cube.y = -radius;
            scene.addChild(cube);
            
            
            with(scene.addChild (new Mesh (new PlaneGeometry (10000, 10000), new ColorMaterial(0xcccccc))))
            { y = -400; rotationY = -45; }
            
        }
        
        private function initLight():void
        {
            light = new DirectionalLight( -0.5, -1, -1);
            light.color = 0xffffff;
            light.ambient = 1;
            scene.addChild(light);
            
            lightPicker = new StaticLightPicker([light]);
        }
        
        private function initEngine():void
        {
            view = new View3D();
            view.antiAlias = 4;
            
            scene = view.scene;
            camera = view.camera;
            camera.lens.far = 5000;
            
            cameraController = new HoverController(camera);
            cameraController.distance = 500;
            cameraController.panAngle = 45;
            cameraController.tiltAngle = 20;
            
            awayStats = new AwayStats(view);
            
        }
        
        private function onMouseDown(e:MouseEvent):void
        {
            lastPanAngle = cameraController.panAngle;
            lastTiltAngle = cameraController.tiltAngle;
            lastMouseX = stage.mouseX;
            lastMouseY = stage.mouseY;
            move = true;
           
        }
        
        private function onMouseUp(e:MouseEvent):void
        {
            move = false;
        }
        
        private function resizeHandler(e:Event):void
        {
            view.width = stage.stageWidth;
            view.height = stage.stageHeight;
        }
    }
}