/**
 * Copyright n0wri ( http://wonderfl.net/user/n0wri )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/NspJ
 */

//FP10
package {
	import flash.geom.Matrix;
	import flash.events.MouseEvent;
	import flash.display.DisplayObject;
	import caurina.transitions.Tweener;
	import jp.progression.commands.tweens.DoTweener;

	import flash.display.BitmapData;
	import jp.progression.commands.net.LoadBitmapData;
	import flash.events.Event;
	import flash.display.Loader;
	import jp.progression.commands.lists.LoaderList;
	import flash.system.LoaderContext;
	import flash.system.ApplicationDomain;
	import flash.display.Sprite;
	import flash.net.URLRequest;
	import net.wonderfl.utils.WonderflAPI;
	public class RayEffectDocument extends Sprite
	{
		public const ClassName:String = "RayEffect";
		public const RAY_EFFECT_URL:String = "http://swf.wonderfl.net/swf/usercode/b/b1/b107/b1070a1dc09603dfd16f02b94aa299f010883885.swf";
		public const IMG_URL:String = "http://assets.wonderfl.net/images/related_images/0/04/046f/046f75490aee5deb1b88daac464c394ea8ef9cc3";
		public var Lib:Class;
		
		private var rayFunc : Function
		private var raySpr : Object;
		
		public function RayEffectDocument()
		{
			imports();
		}
		    
		//外部SWFからクラスを取得する
        public function imports():void
		{
			var params:Object = loaderInfo.parameters;
			var api:WonderflAPI = new WonderflAPI(params);
			
            //アプリケーションドメインの設定
            var appDomain:ApplicationDomain = ApplicationDomain.currentDomain;
            var loader:Loader = new Loader();
            //読み込み時にアプリケーションドメインを指定
            loader.load(new URLRequest(RAY_EFFECT_URL), new LoaderContext(true, appDomain));
            trace("読み込み中");
            loader.contentLoaderInfo.addEventListener(Event.COMPLETE, function (event:Event):void{
                trace("complete");
                event.target.removeEventListener(Event.COMPLETE, arguments.callee);
                //アプリケーションドメインに指定したクラスがあるか
                if(appDomain.hasDefinition(ClassName)){
                    //取得したクラスをClass型変数に代入
                    Lib = appDomain.getDefinition(ClassName) as Class;
                    trace("外部SWFファイルから"+ClassName+"クラスをインポートしました");
					
					setRayEffect();
                }
                else{
                    trace("外部SWFファイルには"+ClassName+"クラスは存在しません");
                }
            });
            
		}

		private function setRayEffect() : void 
		{
			
			var lst:LoaderList = new LoaderList();
			lst.addCommand
			(
				new LoadBitmapData
				(	new URLRequest(IMG_URL),
					{context:new LoaderContext(true)}
				),
				function():void
				{
					var ef:Function = Lib.bmData;
					var bmd:BitmapData = BitmapData(this.latestData);
					bmd = resize(bmd, 465/bmd.height, 465/bmd.height);
					raySpr = ef(bmd);
					addChild(raySpr as DisplayObject);
					ray();
					stage.addEventListener(MouseEvent.CLICK, ray);
				}
			);
			lst.execute();
		}

		private function ray(e:MouseEvent=null) : void 
		{
			Tweener.removeTweens(raySpr);
			raySpr["rate"]=0;
			Tweener.addTween(raySpr, {rate:1, time:3, transition:"easeOutSine"});
		}
		
		/**
		 *
		 * BitmapData のリサイズ
		 *
		 * @param       BitmapData      src         元となる BitmapData オブジェクト
		 * @param       Number          hRatio      水平方向のリサイズ比率
		 * @param       Number          vRatio      垂直方向のリサイズ比率
		 * @return      BitmapData      リサイズされた BitmapData オブジェクト
		 *
		 */
		public function resize(src:BitmapData, hRatio:Number, vRatio:Number):BitmapData
		{
		  var res:BitmapData = new BitmapData(
		    Math.ceil(src.width * hRatio), Math.ceil(src.height * vRatio)
		  );
		  res.draw(src, new Matrix(hRatio, 0, 0, vRatio), null, null, null, true);
		  return res;
		}
	}
}




 