/**
 * Copyright _ryotaros ( http://wonderfl.net/user/_ryotaros )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/Nrg7
 */

// forked from _ryotaros's flash on 2010-2-21
package {
    import flash.display.Sprite;
    import jp.nium.utils.*;
    import flash.text.TextField;
    import flash.events.Event;
    
    import flash.text.TextFormat;
    import flash.geom.Point;
    public class calender extends Sprite {
    		
    		public var dateLength:int;
    		public var dat:int;
    		public var day:int;
    		public var firstDay:int;
    		public var ball:Ball;
    		
    		public var size:int =20;
    		
    		public var spring:Number = 0.2;
    		public var friction:Number = 0.9;
    		public var gravity:Number = 1;
    		
    		public var balls:Array;
    		public var basicP:Point;
    		public var pointArray:Array;
    		
    		public var margin:int = 55;
    		
        public function calender():void{
            init();
        }
        
        public function init():void{
        		dateLength = DateUtil.getMaxDateLength(new Date());
        		var date:Date = new Date;
        		dat = date.getDate();
        		day = date.getDay();
        		firstDay = new Date(date.getFullYear(),date.getMonth(),1).getDay();
        		
        		balls = [];
        		var daycount:int = firstDay;
        		for (var i:int = 0;i < dateLength;i++){
        			if(dat-1 == i) {
		   			ball = new Ball(25,0xAAAAAA);
        			} else {
        				ball = new Ball(20);
        			}
        			addChild(ball);
        			if(i==0){
        				ball.x = ball.y = margin * (firstDay+1);	
        			} else {
        				ball.x = balls[i-1].x + margin;
        				ball.y = balls[i-1].y;
        			}
        			if (daycount > 6){
        				ball.x = margin;
        				ball.y = balls[i-1].y + margin;	
        				daycount = 0;
        			}
        			daycount++;
        			balls.push(ball);
        			
        			var text:TextField = new TextField();
        			var format:TextFormat = new TextFormat();
        			format.size = 15;
        			format.color = 0xFFFFFF;
        			text.defaultTextFormat = format;
        			text.text = String(i+1);
        			text.x = -ball.width/5;
        			text.y = -ball.height/5;
        			ball.addChild(text);  			
        		}
        		
        		pointArray = [];
        		for (i = 0;i<7;i++){
        				pointArray.push(new Point(margin * (i+1),0));       				
        		}
        		
        		addEventListener(Event.ENTER_FRAME,onenterframe);
        }
        
        public function onenterframe(e:Event):void{
        		this.graphics.clear();
        		this.graphics.lineStyle(1);
        		var daycount:int = (firstDay+1);
        		
        		for (var i:int = 0;i<dateLength;i++){
        			
        			if (i > 6){
        				moveTo(balls[i],balls[i-7].x,balls[i-7].y)	
        			} else {
        				moveTo(balls[i],pointArray[((i+1)%7)].x,pointArray[((i+1)%7)].y)	
        			}

        			if(daycount != 7){
	        			graphics.moveTo(balls[i].x,balls[i].y);
 	       			graphics.lineTo(balls[i+1].x,balls[i+1].y);
        			}else {daycount = 0};
        			
        			if(balls[i+7]){
        				graphics.moveTo(balls[i].x,balls[i].y);
        				graphics.lineTo(balls[i+7].x,balls[i+7].y);
        			}
        			
        			if (i < 7){
        				graphics.moveTo(balls[i].x,balls[i].y);
        				graphics.lineTo(pointArray[((i+1)%7)].x,pointArray[((i+1)%7)].y)	
        			}
        			daycount++;
        		}
        }
        
       // public var springLength:Number = margin;
        
        public function moveTo(ball:Ball, tX:Number, tY:Number ):void {

        		var dx:Number = ball.x - tX;
        		var dy:Number = ball.y - tY;
        	
        		var angle:Number = Math.atan2(dy, dx);
        		var targetX:Number = tX + Math.cos(angle) * margin;
        		var targetY:Number = tY + Math.sin(angle) * margin;
			
        		ball.vx += (targetX - ball.x) * spring;
        		ball.vy += (targetY - ball.y) * spring;
        		
        		ball.vx *= friction;
        		ball.vy *= friction;
        		
        		
        		
        		ball.vy += gravity;
        		
        		ball.x += ball.vx;
        		ball.y += ball.vy;
        	
        }
    }
}

import flash.display.Sprite;
class Ball extends Sprite{
	
	public var vx:Number = 0;
	public var vy:Number = 0;

	public function Ball(radius:int = 20,color:uint=0x000000):void{
		this.graphics.beginFill(color);
		this.graphics.lineStyle(1);
		this.graphics.drawCircle(0,0,radius);
		this.graphics.endFill()
	}
}