/**
 * Copyright alpicola ( http://wonderfl.net/user/alpicola )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/NEqn
 */

// forked from 5ivestar's flash on 2009-4-25

package {
	import flash.display.*;
	import flash.events.*;
	import flash.geom.Point;
	import flash.geom.Matrix;

	[SWF(backgroundColor="#000000", frameRate="30")]

	public class Test extends Sprite {

		private const NUM_RECTANGLES:int = 500;

		private var rectangles:Vector.<Rectangle> = new Vector.<Rectangle>(NUM_RECTANGLES, true);
		private var commands:Vector.<int> = new Vector.<int>(4, true);
		private var matrix:Matrix = new Matrix();

		public function Test() {
			var w:int = stage.stageWidth;
			var h:int = stage.stageHeight;
			for (var i:int = 0; i < NUM_RECTANGLES; i++) {
				matrix.identity();
				matrix.scale(w * (Math.random() - 0.5), h * (Math.random() - 0.5));
				matrix.rotate(Math.PI * Math.random());
				matrix.translate(w * Math.random(), h * Math.random());
				var rectangle:Rectangle = new Rectangle(new Point(0, 0), new Point(1, 0), new Point(1, 1), new Point(0, 1));
				rectangle.transform(matrix);
				rectangles[i] = rectangle;
			}
			commands[0] = 1;
			commands[1] = 2;
			commands[2] = 2;
			commands[3] = 2;

			addEventListener(Event.ENTER_FRAME, draw);
		}

		public function draw(e:Event):void {
			var w:int = stage.stageWidth;
			var h:int = stage.stageHeight;
			var g:Graphics = graphics;
			g.clear();
			g.beginFill(0xffffff);
			for each (var rectangle:Rectangle in rectangles) {
				matrix.identity();
				matrix.scale(1 + (Math.random() - 0.5) * 0.01, 1 + (Math.random() - 0.5) * 0.01);
				matrix.rotate(Math.PI * (Math.random() - 0.5) * 0.01);
				matrix.translate(w * (Math.random() - 0.5) * 0.01, h * (Math.random() - 0.5) * 0.01);
				rectangle.transform(matrix);
				g.drawPath(commands, rectangle.data);
			}
			g.endFill();
		}

	}
}

import flash.geom.Point;
import flash.geom.Matrix;

class Rectangle {

	public var points:Vector.<Point> = new Vector.<Point>(4, true);
	public var data:Vector.<Number> = new Vector.<Number>(8, true);

	public function Rectangle(p1:Point, p2:Point, p3:Point, p4:Point) {
		points[0] = p1;
		points[1] = p2;
		points[2] = p3;
		points[3] = p4;
		for (var i:int = 0; i < 4; i++) {
			data[i*2]   = points[i].x;
			data[i*2+1] = points[i].y;
		}
	}

	public function transform(matrix:Matrix):void {
		for (var i:int = 0; i < 4; i++) {
			points[i] = matrix.transformPoint(points[i]);
			data[i*2]   = points[i].x;
			data[i*2+1] = points[i].y;
		}
	}

}
