/**
 * Copyright h_kamizono ( http://wonderfl.net/user/h_kamizono )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/NDsR
 */

// forked from h_kamizono's test
// ref 
// Flash Math & Physics Design ActionScript 3.0による数学・物理学表現[実践編]
// Case10のベジェ曲線のところだけ

package {
    import flash.display.MovieClip;
    import flash.display.Sprite;
    import flash.utils.Timer;
    import flash.events.TimerEvent;
    import flash.events.MouseEvent;
    import flash.geom.Point;
    public class FlashTest extends Sprite {
        private var loc:Array = new Array();
        private var locNum:Number = 10;
        private var timer:Timer = new Timer(33);
        
        private var pigment:Number = 0;
        
        public function FlashTest() {
            // write as3 code here..
            for (var i:int = 0; i < locNum; ++i) {
                loc.push(new Point(Math.random()*stage.stageWidth/2, Math.random()*stage.stageHeight/2));
            }
            
            timer.addEventListener(TimerEvent.TIMER, loop);
            timer.start();
        }
        
        private function loop(ev:TimerEvent) :void {
            this.graphics.clear();
            pigment++;
            for (var i:int = -1; i < locNum - 4; ++i) {
                var col:uint = Functions.hsbToRgb(pigment/2,1,1);
                this.graphics.lineStyle(4, col);
                Functions.bezierCurveTo(this.mouseX, this.mouseY,
                                        loc[i+1].x, loc[i+1].y,
                                        loc[i+2].x, loc[i+2].y,
                                        loc[i+3].x, loc[i+3].y,
                                        this);
                
            }
        }

    }
}
import flash.display.Sprite;
import flash.geom.Point;
class Functions {
    public static function hsbToRgb(h:Number,
                                    s:Number,
                                    b:Number) :uint {
        while (h < 0) {
            h+=360;
        }
        while (h >= 360) {
            h -= 360;
        }
        var h2:Number = Math.floor(h/60);
        var f:Number = h/60 - h2;
        var parFull:Number = 255;
        var parEmp:Number = 0;
        var parZoka:Number = 255*f;
        var parGensho:Number = 255*(1-f);
        var red:Number = 0;
        var green:Number = 0;
        var blue:Number = 0;
        
        switch (h2) {
          case 0:
            red = parFull; green = parZoka; blue = parEmp;
            break;
          case 1:
            red = parGensho; green = parFull; blue = parEmp;
            break;
          case 2:
            red = parEmp; green = parFull; blue = parZoka;
            break;
          case 3:
            red = parEmp; green = parGensho; blue = parFull;
            break;
          case 4:
            red = parZoka; green = parEmp; blue = parFull;
            break;
          case 5:
            red = parFull; green = parEmp; blue = parGensho;
            break;
        }
        var max:Number = Math.max(Math.max(red, green), blue);
        red = max - (max - red)*s;
        green = max - (max - green)*s;
        blue = max - (max - blue)*s;
        red *= b; green *= b; blue *= b;
        var ret:uint = int(red) << 16 | int(green) << 8 | int(blue);
        return ret; 
    }
    public static function bezierCurveTo(x0:Number, y0:Number,
                                         x1:Number, y1:Number,
                                         x2:Number, y2:Number,
                                         x3:Number, y3:Number,
                                         sp:Sprite) :void {
        var div:Number = 24;
        var pt:Array = new Array();
        for (var i:Number = 0; i <= div; ++i) {
            var t:Number = i / div;
            var w0:Number = (1 - t) * (1 - t) * (1 - t);
            var w1:Number = 3*t*(1-t)*(1-t);
            var w2:Number = 3*t*t*(1-t);
            var w3:Number = t*t*t;
            var x:Number = w0*x0 + w1*x1 + w2*x2 + w3*x3;
            var y:Number = w0*y0 + w1*y1 + w2*y2 * w3*y3;
            pt.push(new Point(x, y));
        }
        drawContinuousCurve(pt, sp);
    }
    
    public static function drawContinuousCurve(pt:Array, sp:Sprite) :void {
        if (pt.length >= 3) {
            sp.graphics.lineTo(pt[0].x, pt[0].y);
            for (var i:Number = 1; i <= pt.length - 3; ++i) {
                sp.graphics.curveTo(pt[i].x, pt[i].y,
                                    (pt[i].x + pt[i+1].x)/2,
                                    (pt[i].y + pt[i+1].y)/2);
            }
            sp.graphics.curveTo(pt[pt.length - 2].x, pt[pt.length - 2].y,
                                pt[pt.length - 1].x, pt[pt.length - 1].y);
        }
    }

}
