/**
 * Copyright weBBBBB ( http://wonderfl.net/user/weBBBBB )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/N2sL
 */

package 
{
    import flash.display.Sprite;
    import flash.display.Graphics;
    import flash.utils.Timer;
    import flash.events.Event;
    import flash.events.TimerEvent;
    
    import Box2D.Dynamics.*;
    import Box2D.Collision.*;
    import Box2D.Collision.Shapes.*;
    import Box2D.Common.Math.*;
    
    public class Box2D_Index extends Sprite
    {
        private var m_world:b2World;
        private var m_scale:Number = 30;
        public function Box2D_Index()
        {
            // *1ワールドの定義-----------------------------------------------------------------
            var worldAABB:b2AABB = new b2AABB();
            worldAABB.lowerBound.Set(-100.0,-100.0);
            worldAABB.upperBound.Set(100.0,100.0);
            var gravity:b2Vec2 = new b2Vec2(0.0,10.0);
            var doSleep:Boolean = true;
            m_world = new b2World(worldAABB,gravity,doSleep);
            //2*地面の設定----------------------------------------------------------------------
            var body:b2Body;
            var bodyDef:b2BodyDef;
            var boxDef:b2PolygonDef;
            var circleDef:b2CircleDef;
            
            var insWidth:Number = 0;
            var insHeight:Number = stage.stageHeight / m_scale;
            
            var floorWidth:Number = stage.stageWidth / m_scale;
            var floorHeight:Number = 3;
            
            bodyDef = new b2BodyDef();
            bodyDef.position.Set(insWidth,insHeight + floorHeight);
            
            boxDef = new b2PolygonDef();
            boxDef.SetAsBox(floorWidth,floorHeight);
            boxDef.friction = 0.3;
            boxDef.density = 0;
            
            body = m_world.CreateBody(bodyDef);
            body.CreateShape(boxDef);
            body.SetMassFromShapes();
            //3*タイマーとENTER_FRAMEの設定-----------------------------------------------------
            var timer:Timer = new Timer(100);
            timer.addEventListener(TimerEvent.TIMER,onTimerHandler);
            timer.start();
            
            addEventListener(Event.ENTER_FRAME,onUpdateHandler);
            tage.addEventListener(Event.RESIZE, resizeHandler);
        }
        //リサイズ処理
        private function resizeHandler(event : Event) : void {
            //床の大きさ・位置を変更
            for (var b2body : b2Body = _world.m_bodyList;b2body; b2body = b2body.m_next) {
                if (b2body.m_userData) {
                    if (b2body.m_userData.id == "wall") {
                        
                        var wallShapeDef : b2PolygonDef = new b2PolygonDef();
                        wallShapeDef.SetAsBox(stage.stageWidth / _physScale, 10 / _physScale);
                        b2body.CreateShape(wallShapeDef);
                        b2body.SetXForm(new b2Vec2(b2body.GetPosition().x, stage.stageHeight / _physScale), 0);
                    }
                }
            }
        }
        
        private function onUpdateHandler(event:Event = null):void
        {
            var m_iterations:int = 20;
            var m_timeStep:Number = 3.0 / 60.0;//ここではフレームレートを設定しています。
            m_world.Step(m_timeStep,m_iterations);
            
            for (var bb:b2Body = m_world.m_bodyList; bb; bb = bb.m_next)
            {
                if (bb.m_userData is Sprite)
                {
                    bb.m_userData.x = bb.GetPosition().x * 30;
                    bb.m_userData.y = bb.GetPosition().y * 30;
                    bb.m_userData.rotation = bb.GetAngle() * (180 / Math.PI);
                }
            }
        }
        
        private function onTimerHandler(event:Event):void
        {
            
            //*1タイマーとENTER_FRAMEの設定-----------------------------------------------------
            var body:b2Body;
            var userData:Sprite = new Sprite();
            var graphics:Graphics = userData.graphics;
            graphics.beginFill(Math.random() * 16777216,1);
            
            var bodyDef:b2BodyDef = new b2BodyDef();
            bodyDef.position.Set(Math.random() * stage.stageWidth / m_scale, -1);
            var rX:Number = 1;
            var rY:Number = 1;
            //2*ランダムでオブジェクトを呼び出す------------------------------------------------
            if (Math.random() < 0.33)
            {
                var boxDef:b2PolygonDef = new b2PolygonDef();
                boxDef.SetAsBox(rX, rY);
                boxDef.density = 1.0;
                boxDef.friction = 0.5;
                boxDef.restitution = 0.2;
                
                graphics.drawRect( -rX / 2, -rY / 2, rX,rY);
                graphics.endFill();
                
                bodyDef.userData = userData;
                bodyDef.userData.width = rX * 2 * 30;
                bodyDef.userData.height = rY * 2 * 30;
                body = m_world.CreateBody(bodyDef);
                body.CreateShape(boxDef);
            }
            if(Math.random() < 0.66)
            {
                var circleDef:b2CircleDef = new b2CircleDef();
                circleDef.radius = rX;
                circleDef.density = 1.0;
                circleDef.friction  = 0.5;
                circleDef.restitution = 0.2;
                
                graphics.drawCircle(0,0,rX);
                graphics.endFill();
                
                bodyDef.userData = userData;
                bodyDef.userData.width = rX * 2 * 30;
                bodyDef.userData.height = rY * 2 * 30;
                body = m_world.CreateBody(bodyDef);
                body.CreateShape(circleDef);
            }
            else
            {
                var radius:Number = rX;
                var triangle_h:Number = Math.tan(60 * Math.PI / 180) * radius;
                
                var tryangleDef:b2PolygonDef = new b2PolygonDef();
                tryangleDef.vertexCount = 3;
                tryangleDef.vertices[0].Set(-1 * radius, -1 * triangle_h / 2);
                tryangleDef.vertices[1].Set(radius, -1  * triangle_h /2);
                tryangleDef.vertices[2].Set(0, triangle_h / 2);
                tryangleDef.density = 1.0;
                tryangleDef.friction = 0.5;
                tryangleDef.restitution = 0.2;
                
                graphics.moveTo(-1 * radius, -1 * triangle_h / 2);
                graphics.lineTo(radius, -1 * triangle_h / 2);
                graphics.lineTo(0,triangle_h / 2);
                graphics.endFill();
                
                bodyDef.userData = userData;
                bodyDef.userData.width = rX * 2 * 30;
                bodyDef.userData.height = rY * 2 * 30;
                body = m_world.CreateBody(bodyDef);
                body.CreateShape(tryangleDef);
            }
            //3*完了処理-------------------------------------------------------------------------
            body.SetMassFromShapes();
            addChild(bodyDef.userData);
            
            onUpdateHandler();
        }
    }
}