/**
 * Copyright mutantleg ( http://wonderfl.net/user/mutantleg )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/MaDA
 */

package {
    import flash.events.Event;
    import flash.ui.Keyboard;
    import flash.events.KeyboardEvent;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        public function FlashTest() {
   
           mw = 32;
           mh = 32;
           vecGrid = new Vector.<int>(mw*mh,false);
           
           var i:int;
           for (i=0;i<64;i+=1)
           {
             setWall(Math.random()*32,Math.random()*32, 6+Math.random()*64);               
           }//nexti
           
           stage.addEventListener(KeyboardEvent.KEY_DOWN, onKdown);
           stage.addEventListener(KeyboardEvent.KEY_UP, onKup); 
           stage.addEventListener(Event.ENTER_FRAME, onEnter); 
        }//ctor
 
        public var cx:Number = 230;
        public var cz:Number = 230;
 
        public function onEnter(e:Event):void
        {
           graphics.clear();
           graphics.lineStyle(2, 0);
           drawBox(0,0,0, 1024, 64, 1024);
           drawBox(0,0,0, 32, 64, 32);
           
           var h:Number;
           h = getWall(cx/cw,cz/ch);
           drawBox2(cx,h+32,cz,16,32,16);

            var i:int; var k:int; var yt:int; var t:int;
            for(i=0;i<mh;i+=1)
            { yt = i*mw;
              for (k=0;k<mw;k+=1)
              {
                 t = vecGrid[yt+k];
                 if (t > 0)
                 { drawBox3(k*cw,0,i*ch,cw, t, ch);  } 
               }//nextk
            }//nexti

            var dx:Number; var dz:Number;
            dx=0;dz=0;
            if (isKeyDown(Keyboard.UP)) { dz-=1;}            
            if (isKeyDown(Keyboard.DOWN)) { dz+=1;}            
            if (isKeyDown(Keyboard.LEFT)) { dx-=1;}            
            if (isKeyDown(Keyboard.RIGHT)) { dx+=1;}            
            
            var ms:Number;
            var ta:Number;
            ms = 8; 
            ta = 0;
            if (dx!=0||dz!=0) 
            {
              ta = Math.atan2(dz,dx);
              ta+=3.1415*-0.25;
              cx += Math.cos(ta) * ms;
              cz += Math.sin(ta) * ms;
            }//endif
            
            camx += ((cx-230)-camx) *0.1;
            camz += ((cz-230)-camz) *0.1;
            
            
        }//onenter
 
        public var vecGrid:Vector.<int> = null; //new Vector.<int>(32*32,false);
        public var mw:int = 0;
        public var mh:int = 0;
        public var cw:Number = 32;
        public var ch:Number = 32;

        public function setWall(ax:int,ay:int, t:int):void
        { if(ax<0||ax>=mw||ay<0||ay>=mh){return;} vecGrid[(ay*mw)+ax] = t;  }        
    
        public function getWall(ax:int, ay:int):int
        { if(ax<0||ax>=mw||ay<0||ay>=mh){return 0;} return vecGrid[(ay*mw)+ax]; }
    

        
        public var vecKey:Vector.<Boolean> = new Vector.<Boolean>(512, false);
        public function onKdown(e:KeyboardEvent):void { vecKey[e.keyCode] = true; }
        public function onKup(e:KeyboardEvent):void { vecKey[e.keyCode] = false; }
        public function isKeyDown(k:int):Boolean { return vecKey[k]; }    
        
        
        
        public var camx:Number = 0;        public var camy:Number = 0;        public var camz:Number = 0; 
        public var rendw:Number = 465 * 0.5;        public var rendh:Number = 465 * 0.5; 
        public function drawLine(ax:Number, ay:Number, az:Number,
        bx:Number, by:Number, bz:Number):void
        {
           var sx:Number; var sy:Number;     
           ax -= camx; ay -= camy; az -= camz;
           bx -= camx; by -= camy; bz -= camz;
            sx = ax - az + rendw;     sy = (ax * 0.5) + (az * 0.5) - ay;
            graphics.moveTo(sx,sy);
            sx = bx - bz + rendw;     sy = (bx * 0.5) + (bz * 0.5) - by;
            graphics.lineTo(sx, sy);
        }//drawline 

        public function drawBox3(ax:Number,ay:Number,az:Number,
        aw:Number,ah:Number,ad:Number):void
        { drawBox(ax,ay,az, ax+aw,ay+ah,az+ad); }
        
        public function drawBox2(ax:Number,ay:Number,az:Number,
        rx:Number,ry:Number,rz:Number):void
        { drawBox(ax-rx,ay-ry,az-rz,ax+rx,ay+ry,az+rz); }
           
         public function drawBox(ax:Number, ay:Number, az:Number,
          bx:Number, by:Number, bz:Number):void
        {
          drawLine(ax, ay, az,   bx, ay, az);
          drawLine(ax, by, az,   bx, by, az);
          drawLine(ax, ay, bz,   bx, ay, bz);
          drawLine(ax, by, bz,   bx, by, bz);
          
          drawLine(ax, ay, az,   ax, by, az);
          drawLine(bx, ay, az,   bx, by, az);
          drawLine(ax, ay, bz,   ax, by, bz);
          drawLine(bx, ay, bz,   bx, by, bz);
          
          drawLine(ax, ay, az,   ax, ay, bz);
          drawLine(bx, ay, az,   bx, ay, bz);
          drawLine(ax, by, az,   ax, by, bz);
          drawLine(bx, by, az,   bx, by, bz);
        }//drawbox  
        
        
    }//classend
}