/**
 * Copyright miyaoka ( http://wonderfl.net/user/miyaoka )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/MQlh
 */

package 
{
	import flash.display.Sprite;
	[SWF(width="465", height="465", backgroundColor= 0xffffff, frameRate="60")]
	public class OdekochanBlink
	extends Sprite
	{
		public function OdekochanBlink():void 
		{
			var face:Face = new Face();
			addChild(face);
		}
	}	
}

	import flash.events.MouseEvent;
	import caurina.transitions.Tweener;
import flash.display.Graphics;
import flash.display.Sprite;
import flash.display.LineScaleMode;
import flash.display.CapsStyle;
	import flash.events.Event;
	
class Face
extends Sprite
{
	public function Face():void 
	{		
		addEventListener(Event.ADDED_TO_STAGE, function ():void 
		{
			init();
		});
	}
	private function init():void 
	{		
		var g:Graphics = graphics;
		//head
		g.beginFill(0xffddcc);
		g.drawCircle(stage.stageWidth/2, stage.stageHeight/2, stage.stageWidth / 2);
		g.beginFill(0xffddcc);
		g.drawRect(0, stage.stageHeight / 2, stage.stageWidth, stage.stageHeight);
		g.endFill();
		

		var eyes:Eyes = new Eyes();
		eyes.y = 380;
		eyes.x = 465/2;
		addChild(eyes);
		
		//mouth
		g.lineStyle(5, 0x990000);
		g.moveTo(stage.stageWidth * 0.4, stage.stageHeight+10);
		g.curveTo(stage.stageWidth * 0.5, stage.stageHeight + 50, stage.stageWidth * 0.6, stage.stageHeight+10);
				
		//hair
		var h:Hair = new Hair();
		addChild(h);
		h.x = stage.stageWidth / 2;
		h.y = 0;
		h.width = stage.stageWidth*1.2*1.2;
		h.height = stage.stageHeight * 1.0 * 1.2;
		
		//evt
		stage.addEventListener(MouseEvent.MOUSE_MOVE, function ():void { h.update(); });
		stage.addEventListener(MouseEvent.MOUSE_DOWN, function ():void { pyokon(); });
		pyokon();
	}
	private function pyokon():void 
	{
		y = stage.stageHeight * 0.6;
		Tweener.addTween(this, {
			y : 0,
			time: 1.0,
			transition: "easeOutBack"
		});
		
	}
}
class Eyes
extends Sprite
{
	private var eyeL:Eye;
	private var eyeR:Eye;
	public function Eyes():void 
	{
		eyeL = new Eye();
		eyeR = new Eye();
		eyeL.x = -180;
		eyeR.x = 180;
		addChild(eyeL);
		addChild(eyeR);
		
		open();
	}
	public function open():void 
	{
		var top:Number = -40 - Math.random()*20
		Tweener.addTween(eyeL, {
			top: top,
			time:0.1
		});		
		Tweener.addTween(eyeR, {
			top: top,
			time:0.1,
			onComplete: close
		});		
	}
	public function close():void 
	{
		var bottom:Number = eyeL.bottom -1;
		var time:Number = 0.1 + Math.random() * 0.3;
		var delay:Number = 0.1 + Math.random() * 3;
		Tweener.addTween(eyeL, {
			top: bottom,
			time: time,
			delay:delay
		});		
		Tweener.addTween(eyeR, {
			top: bottom,
			time: time,
			delay:delay,
			onComplete: open
		});		
	}
}
class Eye
extends Sprite
{
	private var eyelid:Sprite = new Sprite();
	private var eyelidMask:Sprite = new Sprite();
	private var eyeball:Sprite = new Sprite();
	
	public var top:Number = -40;
	public var bottom:Number = 40;
	private var left:Number = -40;
	private var right:Number = 40;
	public function Eye():void 
	{
		var g:Graphics = eyeball.graphics;
		g.beginFill(0);
		g.drawCircle(0, 0, 30);
		
		addChild(eyelidMask);
		mask = eyelidMask;
		addChild(eyelid);
		addChild(eyeball);
		update(null);
		
		addEventListener(Event.ENTER_FRAME, update);
		

		
	}
	public function update(e:Event):void 
	{
		var lg:Graphics = eyelid.graphics;
		var mg:Graphics = eyelidMask.graphics;
		lg.clear();
		mg.clear();

		lg.beginFill(0xFFFFFF);
		lg.lineStyle(5, 0x000000);		
		lg.moveTo( left, 0); 
		lg.curveTo(0, top, right, 0);
		lg.lineStyle(NaN);
		lg.curveTo(0, bottom, left, 0);
		lg.endFill();
		
		mg.beginFill(0xFFFFFF);
		mg.lineStyle(1, 0x000000);		
		mg.moveTo(left, 0); 
		mg.curveTo(0, top, right, 0);
		mg.curveTo(0, bottom, left, 0);
		mg.endFill();
		
	}
}
class Hair
extends Sprite
{
	public function Hair():void 
	{
		update();
	}
	public function update():void 
	{
		var g:Graphics = graphics;
		g.clear();
		g.lineStyle(8, 0x332222, 0.95, false, LineScaleMode.NORMAL, CapsStyle.ROUND);
		var i:int;
		for (i = 0; i < 10; i++)
		{
			g.moveTo(0, 0); 
			g.curveTo(100 + i * 10, 0, 100 + i * 10 * 0.6, 300 - i*5);
		}
		for (i = 0; i < 10; i++)
		{
			g.moveTo(0, 0); 
			g.curveTo(-100 - i * 10, 0, -100 - i * 10 * 0.6, 300 - i*5);
		}
		g.lineStyle(5, 0x332222, 0.8, false, LineScaleMode.NORMAL, CapsStyle.ROUND);
		for (i = -30; i < 31; i++)
		{
			g.moveTo(0, 0);
			var hx:Number = i*3;
			if (mouseY < 150 && ((0 < mouseX && 0 < i && hx < mouseX) || (0 > mouseX &&  0 > i && hx > mouseX)))
			{
				g.curveTo(hx, 0, mouseX, mouseY);
				g.lineTo(mouseX, 170);
			}
			else
			{
				g.curveTo(hx, 0, hx, 170);
			}
		}
	}
}