/**
 * Copyright umhr ( http://wonderfl.net/user/umhr )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/MIPh
 */

/*
 * FileReferenceでテキストと画像をzip圧縮してローカルPCに保存。
 * 
 * テキストは、テキストフィールドに入力した文字
 * 画像は、BitmapDataをjpg化
 * 共にバイナリとしてZip化
 * 
 * 参考
 * Zip Libraryで複数ファイルを圧縮してみる
 * http://www.5ive.info/blog/archives/98
 * 
 * Flash Player 10 のローカルファイルアクセス機能 (FileReference クラス)
 * http://blogs.adobe.com/akamijo/archives/2008/07/flash_player_10_5.html
 * 
 * */
package
{
    import com.adobe.images.JPGEncoder;
    import com.bit101.components.PushButton;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.net.FileReference;
    import flash.text.TextField;
    import flash.utils.ByteArray;
    import nochump.util.zip.ZipEntry;
    import nochump.util.zip.ZipOutput;

    /**
     * ...
     * @author umhr
     */
    public class Main extends Sprite
    {
        private var _tf:TextField;
        public function Main():void
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            
            //入力テキストフィールド
            _tf = new TextField();
            _tf.width = 400;
            _tf.height = 300;
            _tf.type = "input";
            _tf.border = true;
            _tf.backgroundColor = 0xEEEEEE;
            _tf.background = true;
            _tf.text = "これは UTF-8 の文字列として保存されます";
            _tf.multiline = true;
            _tf.wordWrap = true;
            this.addChild(_tf);
            
            new PushButton(this, 300, 300, "Save", atClick);
        }
        
        private function atClick(event:MouseEvent):void {
            
            //zip化
            var zipOut:ZipOutput = new ZipOutput();
            
            //-----[ファイル1]
            var dat:String = _tf.text;
            //Windowsの改行に置換
            dat = dat.replace(/\r/g, "\r\n");
            
            var fileData1:ByteArray = new ByteArray();
            fileData1.writeUTFBytes(dat);
            zipOut.putNextEntry(new ZipEntry("userinput.txt"));
            zipOut.write(fileData1);
            zipOut.closeEntry();
            
            //-----[ファイル2]
            var fileData2:ByteArray = new ByteArray();
            fileData2.writeUTFBytes("ハローワールド！");
            zipOut.putNextEntry(new ZipEntry("helloworld.txt"));
            zipOut.write(fileData2);
            zipOut.closeEntry();
            
            //-----[ファイル3]
            //jpegファイル作成
            var bitmapData:BitmapData = new BitmapData(stage.stageWidth, stage.stageHeight);
            bitmapData.draw(this);
            var jpgEncoder:JPGEncoder = new JPGEncoder(80);
            
            var fileData3:ByteArray = new ByteArray();
            fileData3 = jpgEncoder.encode(bitmapData);
            zipOut.putNextEntry(new ZipEntry("image.jpg"));
            zipOut.write(fileData3);
            zipOut.closeEntry();
            
            zipOut.finish();
            
            //ファイルリファレンスで保存
            var fr:FileReference = new FileReference();
            fr.save(zipOut.byteArray, "files.zip"); // ダイアログを表示する
            function onComplete(e:Event):void {
                trace(fr.name);
            }
            
        }
    }
}
