/**
 * Copyright John_Blackburne ( http://wonderfl.net/user/John_Blackburne )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/Lhew
 */

// forked from John_Blackburne's getter performance test
// forked from John_Blackburne's Accessor performance test
// forked from John_Blackburne's flash on 2011-12-16
package {
    import flash.display.Sprite;
    import flash.text.TextField;
    import flash.utils.getTimer;

    public class FlashTest extends Sprite {
        
        public const kNumTrials:int    = 5000000;
        public const kNumData:int      = 512;
        public const kNumDataMask:int  = 511;

        public var aData:Vector.<Vec3>;
        public var aData2:Vector.<Bmp>;
       
        public var tf:TextField;

        public function FlashTest() {
            var iTime:int;
            
            InitText();
            InitData();
            
            // run the first test without timing; sometimes the first
            // test takes a lot longer than it should, as the program
            // reaches a certain size, so do something first without
            // timing it.
            Test1();

            iTime = getTimer();
            Test1();
            tf.appendText("\nVector3D, custom members: " + String(getTimer() - iTime));

            iTime = getTimer();
            Test2();
            tf.appendText("\nVector3D, built-in members: " + String(getTimer() - iTime));
            
            iTime = getTimer();
            Test3();
            tf.appendText("\nBitmap, custom members: " + String(getTimer() - iTime));

            iTime = getTimer();
            Test4();
            tf.appendText("\nBitmap, built-in members: " + String(getTimer() - iTime));
            
            tf.appendText("\nDone");
            
        }
        
        public function InitText():void {
            tf = new TextField();
            tf.width = 400;
            tf.text = "Initialised";
            addChild(tf);
        }

        public function InitData():void {
            var iIndex:int, bmp:Bmp;
            
            aData = new Vector.<Vec3>();
            aData2 = new Vector.<Bmp>();
            
            for (iIndex = 0; iIndex < kNumData; iIndex++) {
                aData.push(new Vec3(iIndex % 7, iIndex % 11, iIndex % 13));
                bmp = new Bmp;
                bmp.x = bmp.fX = iIndex % 7;
                bmp.y = bmp.fY = iIndex % 11;
                aData2.push(bmp);
            }
        }


        public function Test1():void {
            var iTrial:int, fSum:Number, v:Vec3;
            fSum = 0;
            for (iTrial = 0; iTrial < kNumTrials; iTrial++) {
                v = aData[iTrial & kNumDataMask];
                fSum += v.fX + v.fY + v.fZ;
            }
        }

        public function Test2():void {
            var iTrial:int, fSum:Number, v:Vec3;
            fSum = 0;
            for (iTrial = 0; iTrial < kNumTrials; iTrial++) {
                v = aData[iTrial & kNumDataMask];
                fSum += v.x + v.y + v.z;
            }
        }
        
        public function Test3():void {
            var iTrial:int, fSum:Number, b:Bmp;
            fSum = 0;
            for (iTrial = 0; iTrial < kNumTrials; iTrial++) {
                b = aData2[iTrial & kNumDataMask];
                fSum += b.fX + b.fY;
            }
        }

        public function Test4():void {
            var iTrial:int, fSum:Number, b:Bmp;
            fSum = 0;
            for (iTrial = 0; iTrial < kNumTrials; iTrial++) {
                b = aData2[iTrial & kNumDataMask];
                fSum += b.x + b.y;
            }
        }
    }
}

import flash.geom.Vector3D;

class Vec3 extends flash.geom.Vector3D {
    public var fX:Number;
    public var fY:Number;
    public var fZ:Number;
    
    public function Vec3(_x:Number, _y:Number, _z:Number) {
        fX = _x;
        fY = _y;
        fZ = _z;
        super(_x, _y, _z);}
 
}

import flash.display.Bitmap;

class Bmp extends flash.display.Bitmap {
    public var fX:Number;
    public var fY:Number;
}

