/**
 * Copyright bradsedito ( http://wonderfl.net/user/bradsedito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/LJCH
 */

// forked from ProjectNya's TimeSignal (時報)
////////////////////////////////////////////////////////////////////////////////
// TimeSignal (時報)
////////////////////////////////////////////////////////////////////////////////

package {

    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    //import flash.system.Security;
    import flash.filters.DropShadowFilter;

    [SWF(backgroundColor="#FFFFFF", width="465", height="465", frameRate="30")]

    public class Main extends Sprite {
        private var clock:Clock;
        private var label:Label;
        private var se:SoundEffect;
        private static var signalPath:String = "http://www.project-nya.jp/images/flash/timesignal.mp3";

        public function Main() {
            //Wonderfl.capture_delay(1);
            init();
        }

        private function init():void {
            //Security.allowDomain("www.project-nya.jp");
            //Security.loadPolicyFile("http://www.project-nya.jp/crossdomain.xml");
            clock = new Clock();
            clock.addEventListener(Clock.UPDATE, update, false, 0, true);
            clock.addEventListener(Clock.UPDATE_SECONDS, updateSeconds, false, 0, true);
            clock.addEventListener(Clock.UPDATE_MINUTES, updateMinutes, false, 0, true);
            label = new Label(40);
            addChild(label);
            label.x = 132;
            label.y = 212;
            label.textColor = 0xFFFFFF;
            label.filters = [new DropShadowFilter(2, 90, 0x000000, 0.4, 8, 8, 2, 3, false, false, false)];
            se = new SoundEffect();
            se.addEventListener(Event.COMPLETE, loaded, false, 0, true);
            se.load(signalPath);
        }
        private function loaded(evt:Event):void {
            addEventListener(Event.ENTER_FRAME, update, false, 0, true);
        }
        private function update(evt:Event):void {
            label.text = clock.time;
        }
        private function updateSeconds(evt:Event):void {
            if (clock.second == 57) {
                se.play(1);
            }
        }
        private function updateMinutes(evt:Event):void {
        }

    }

}


//////////////////////////////////////////////////
// Clockクラス
//////////////////////////////////////////////////

import flash.utils.Timer;
import flash.events.TimerEvent;

class Clock extends EventDispatcher {
    private var timer:Timer;
    private static var interval:uint = 50;
    public var time:String;
    public var hour:uint;
    public var minute:uint;
    public var second:uint;
    private var prevsec:uint;
    private var prevmin:uint;
    public static const UPDATE:String = "update";
    public static const UPDATE_SECONDS:String = "update_seconds";
    public static const UPDATE_MINUTES:String = "update_minutes";

    public function Clock() {
        init();
    }

    public function init():void {
        update();
        timer = new Timer(interval);
        timer.addEventListener(TimerEvent.TIMER, update, false, 0, true);
        timer.start();
    }
    private function update(evt:TimerEvent = null):void {
        var date:Date = new Date();
        hour = date.hours;
        minute = date.minutes;
        second = date.seconds;
        time = hour + ":" + displayTime(minute) + ":" + displayTime(second);
        dispatchEvent(new Event(Clock.UPDATE));
        if (!prevsec) prevsec = second;
        if (second != prevsec) {
            dispatchEvent(new Event(Clock.UPDATE_SECONDS));
            prevsec = second;
        }
    }
    private function displayTime(n:uint):String {
        var t:String = "0" + n;
        return t.substr(-2);
    }

}


//////////////////////////////////////////////////
// SoundEffectクラス
//////////////////////////////////////////////////

import flash.events.EventDispatcher;
import flash.events.Event;
import flash.events.ProgressEvent;
import flash.media.Sound;
import flash.media.SoundChannel;
import flash.media.SoundTransform;
import flash.net.URLRequest;

class SoundEffect extends EventDispatcher {
    public var id:String;
    private var sound:Sound;
    private var channel:SoundChannel;
    private var level:Number;
    private var volume:Number = 1;
    private var looping:Boolean = false;
    public var initialized:Boolean = false;
    public var playing:Boolean = false;

    public function SoundEffect() {
    }

    public function init(Snd:Class):void {
        sound = new Snd();
    }
    public function load(filePath:String):void {
        sound = new Sound();
        sound.load(new URLRequest(filePath));
        sound.addEventListener(ProgressEvent.PROGRESS, progress, false, 0, true);
        sound.addEventListener(Event.COMPLETE, initialize, false, 0, true);
    }
    private function progress(evt:ProgressEvent):void {
        dispatchEvent(evt);
    }
    private function initialize(evt:Event):void {
        initialized = true;
        channel = sound.play();
        channel.stop();
        dispatchEvent(evt);
    }
    public function play(lv:Number, loop:Boolean = false):void {
        playing = true;
        channel.stop();
        level = lv;
        looping = loop;
        channel = sound.play();
        var transform:SoundTransform = channel.soundTransform;
        transform.volume = level*volume;
        channel.soundTransform = transform;
        if (looping) {
            channel.addEventListener(Event.SOUND_COMPLETE, complete, false, 0, true);
        }
    }
    public function stop():void {
        playing = false;
        channel.stop();
        channel.removeEventListener(Event.SOUND_COMPLETE, complete);
    }
    public function setVolume(v:Number):void {
        volume = v;
        var transform:SoundTransform = channel.soundTransform;
        transform.volume = level*volume;
        channel.soundTransform = transform;
    }
    private function complete(evt:Event):void {
        channel.removeEventListener(Event.SOUND_COMPLETE, complete);
        if (looping) {
            channel = sound.play(0);
            channel.addEventListener(Event.SOUND_COMPLETE, complete, false, 0, true);
            var transform:SoundTransform = channel.soundTransform;
            transform.volume = level*volume;
            channel.soundTransform = transform;
        } else {
            playing = false;
        }
    }

}


//////////////////////////////////////////////////
//    Labelクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.text.TextField;
import flash.text.TextFieldType;
import flash.text.TextFieldAutoSize;
import flash.text.AntiAliasType;
import flash.text.TextFormat;
import flash.text.TextFormatAlign;

class Label extends Sprite {
    private var txt:TextField;
    private var fontSize:uint;
    private static var fontType:String = "_ゴシック";
    private static var _width:uint = 200;
    private static var _height:uint = 40;

    public function Label(s:uint) {
        fontSize = s;
        draw();
    }

    private function draw():void {
        txt = new TextField();
        addChild(txt);
        txt.width = _width;
        txt.height = _height;
        txt.autoSize = TextFieldAutoSize.CENTER;
        txt.type = TextFieldType.DYNAMIC;
        txt.selectable = false;
        //txt.embedFonts = true;
        //txt.antiAliasType = AntiAliasType.ADVANCED;
        var tf:TextFormat = new TextFormat();
        tf.font = fontType;
        tf.size = fontSize;
        tf.align = TextFormatAlign.LEFT;
        txt.defaultTextFormat = tf;
    }
    public function set text(param:String):void {
        txt.text = param;
    }
    public function set textColor(param:uint):void {
        txt.textColor = param;
    }

}
