/**
 * Copyright mousepancyo ( http://wonderfl.net/user/mousepancyo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/L3oy
 */

/*
画面上の「木の芽」をクリックした後は、
ひたすら木が育っていくのを
やさしく見守ってやってください。
*/
package {
    import flash.display.Sprite;
    import flash.events.MouseEvent;
    import flash.events.Event;
    import flash.geom.ColorTransform;
    import flash.geom.Point;
    
    [SWF(width="465", height="465", backgroundColor="#FFFFFF", frameRate="30")]
    
    public class Main extends Sprite {
        private var _bud:Sprite;
        private var _list:Vector.<Line> = new Vector.<Line>();
        private var _w:int = stage.stageWidth;
        private var _h:int = stage.stageHeight;
        private var _rad:Number = Math.PI/12;
        private var _acc:Number;
        private var _tickness:Number;       
        private var _color1:ColorTransform = new ColorTransform(0.48,0.4,0,1,0,0,0,0);
        private var _color2:ColorTransform = new ColorTransform(0.5,1,0.3,1,0,0,0,0);
        
        public function Main() {
            _tickness = 30;
            init();
        }
        
        private function init():void{
            _bud = new Bud();
            addChild(_bud);
            _bud.x = _w/2-100;
            _bud.y = _h-80;
            stage.addEventListener(MouseEvent.CLICK, mouseClick);    
        }
        
        private function mouseClick(e:MouseEvent):void {
            stage.removeEventListener(MouseEvent.CLICK, mouseClick);
            addEventListener(Event.ENTER_FRAME, update);
            var line:Line = new Line(new Point(_w/2, _h), new Point(_w/2, _h-50), _tickness);
            _list.push(line);
            addChild(line);
            removeChild(_bud);
            line.transform.colorTransform = _color1;
        }
        
        private function update(e:Event):void {
            if(_tickness>=25){
                _tickness-=2;
                _color1 = new ColorTransform(0.5,0.42,0.01,1,0,0,0,0);
            }else if(_tickness<25 && _tickness>=20){
                _tickness-=1.5;
                _color1 = new ColorTransform(0.52,0.43,0.02,1,0,0,0,0);
            }else if(_tickness<20 && _tickness>=15){
                _tickness-=1;
                _color1 = new ColorTransform(0.56,0.46,0.05,1,0,0,0,0);
            }else if(_tickness<15 && _tickness>=10){
                _tickness-=0.5;
                _color1 = new ColorTransform(0.6,0.5,0.1,1,0,0,0,0);
            }else if(_tickness<10 && _tickness>=5){
                _tickness-=0.2;
                _color1 = new ColorTransform(0.63,0.53,0.1,1,0,0,0,0);
            }else if(_tickness<5 && _tickness>=4){
                _tickness-=0.05;
                _color1 = new ColorTransform(0.67,0.57,0.1,1,0,0,0,0);
                _color2 = new ColorTransform(0.7,1.3,0.6,1,0,0,0,0);
            }else if(_tickness<4 && _tickness>=3){
                _tickness-=0.01;
                _color1 = new ColorTransform(0.7,0.6,0.1,1,0,0,0,0);
            }else if(_tickness<3 && _tickness>=1){
                _tickness-=0.005
                _color1 = new ColorTransform(0.7,0.6,0.1,1,0,0,0,0);
            }else{
                _tickness=1;
                _color1 = new ColorTransform(0.73,0.65,0.15,1,0,0,0,0);
                _color2 = new ColorTransform(0.8,1.5,0.9,1,0,0,0,0);
            }
            //
            _list[0].transform.colorTransform = _color1;
            _acc = Math.random()*0.4+0.6;
            var currentLine:Line=_list[0];
            _list.splice(0, 1);
            //
            var p:Point = new Point(currentLine.endPos.x + currentLine.distance * _acc * Math.cos(currentLine.angle + _rad), currentLine.endPos.y + currentLine.distance * _acc * Math.sin(currentLine.angle+_rad));
            var newLine:Line = new Line(currentLine.endPos, p, _tickness);
            _list.push(newLine);
            addChild(newLine);
            newLine.transform.colorTransform = _color2;
            //
            p = new Point((currentLine.endPos.x + currentLine.distance * _acc * Math.cos(currentLine.angle - _rad))+(Math.random()*20-10), (currentLine.endPos.y + currentLine.distance * _acc * Math.sin(currentLine.angle - _rad))+(Math.random()*20-10));
            newLine = new Line(currentLine.endPos, p, _tickness);
            _list.push(newLine);
            addChild(newLine);
            newLine.transform.colorTransform = _color2;
            //
            if (currentLine.distance < 0) {
                removeEventListener(Event.ENTER_FRAME, update);
            }
        }
    }
}

//
import flash.display.Sprite;
import flash.geom.Point;

class Line extends Sprite {
    public var _startPos:Point;
    public var _endPos:Point;
    public var _distance:Number;
    public var _angle:Number;
    
    public function Line(start:Point, end:Point, tickness:Number=1) {
        _startPos = start;
        _endPos = end;
        _angle = Math.atan2(end.y-start.y, end.x-start.x);
        _distance = Point.distance(start, end);
        graphics.lineStyle(tickness,0x996600);
        graphics.moveTo(start.x, start.y);
        graphics.lineTo(end.x, end.y);
        graphics.endFill();
    }
    
    public function get distance():Number{
        return _distance
    }
    public function get endPos():Point{
        return _endPos
    }
    public function get angle():Number{
        return _angle
    }
}

//
import flash.display.Sprite;

class Bud extends Sprite {
    
    private var _base:Sprite = new Sprite
    private var _leaf1:Sprite = new Sprite
    private var _leaf2:Sprite = new Sprite
    
    public function Bud() {
        _base.graphics.lineStyle(5,0x5A7B39);
        _base.graphics.moveTo(0, 0);
        _base.graphics.lineTo(0, 60);
        _base.graphics.endFill();
        _base.x = 100
        _base.y = 40
        //
        _leaf1.graphics.beginFill(0x7EA918)
        _leaf1.graphics.drawEllipse(0,0,60,25)
        _leaf1.graphics.endFill()
        _leaf1.rotation = 15
        _leaf1.x = 47
        _leaf1.y = 15
        //
        _leaf2.graphics.beginFill(0x639330)
        _leaf2.graphics.drawEllipse(0,0,45,18)
        _leaf2.graphics.endFill()
        _leaf2.rotation = -10
        _leaf2.x = 98
        _leaf2.y = 33
        //
        addChild(_base)
        addChild(_leaf1)
        addChild(_leaf2)
    }
    
}