/**
 * Copyright 178ep3 ( http://wonderfl.net/user/178ep3 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/L02u
 */

package
{
    import flash.display.BitmapData;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.events.Event;
    
    public class Boid extends Sprite
    {
        private var _max:int = 30;
        private var _list:Array = [];;
        
        public function Boid()
        {
    this.graphics.beginFill(0x000000);
    this.graphics.drawRect(0,0,stage.stageWidth,stage.stageHeight);
    this.graphics.endFill();
            init();
            addEventListener(Event.ENTER_FRAME,loop);
        }
        
        private function init():void
        {
            var bmd:BitmapData = createSrc();
            
            for (var i:uint = 0; i < _max; i++)
            {
                var b:One = addChild(new One(bmd,stage)) as One;
                b.px = stage.stageWidth * Math.random();
                b.py = stage.stageHeight * Math.random();
                b.vx = Math.random() * 20 - 10;
                b.vy = Math.random() * 20 - 10;
                b.cx = b.px + 7.5;
                b.cy = b.px + 5;
                _list.push(b);
            }
        }
        
        private function createSrc():BitmapData
        {
        	var shape:Shape = new Shape();
            shape.graphics.beginFill(0xffffff);
            shape.graphics.moveTo(15,3);
            shape.graphics.lineTo(0,6);
            shape.graphics.lineTo(5,3);
            shape.graphics.lineTo(0,0);
            shape.graphics.lineTo(15,3);
            shape.graphics.endFill();
            
            var bmd:BitmapData = new BitmapData(15,10,true,0x00);
            bmd.draw(shape);
            return bmd;
        }
        
        private function loop(e:Event):void
        {
        	for (var i:int = 0; i < _max; i++)
            {
                var b:One = _list[i];
                b.action(_list);
                b.Move();
            }
        }
    }
}
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Stage;
	import flash.geom.Point;
	
class One extends Bitmap
{
    public var px:Number;
    public var py:Number;
    public var vx:Number;
    public var vy:Number;
    public var cx:Number;
    public var cy:Number;
    private var ax:Number;
    private var ay:Number;
    
    private var _area:uint = 80;
    
    private var _stage:Stage;
    
    public function One(src:BitmapData,stg:Stage)
    {
    	this.bitmapData = src;
    	_stage = stg;
    }
    
    public function action(list:Array):void
    {
        var _target:One = null;
        var dx:Number;
        var dy:Number;
        
        var _maxDist:Number;
        var _minDist:Number = Number.POSITIVE_INFINITY;
        
        var i:String;
        var b:One;
        var count:uint = 0;
        var ncx:Number = 0;
        var ncy:Number = 0;
        var nvx:Number = 0;
        var nvy:Number = 0;
        
        for (i in list)
        {
            b = list[i];
            if (b == this)continue;
                
            _maxDist = Point.distance(new Point(b.cx,b.cy),new Point(cx,cy));
            if(_maxDist<_minDist)
            {
            	_minDist = _maxDist;
            	_target = b;
            }
            
            if (_maxDist < _area)
            {
                ncx += b.cx;
                ncy += b.cy;
                nvx += b.vx;
                nvy += b.vy;
                count++;
            }
        }
        
        if(_target == null)return;
        
        ax = ay = 0;
                 
        dx = (ncx/count - cx);
        dy = (ncy/count - cy);
        _maxDist = Point.distance(new Point(_target.cx,_target.cy),new Point(cx,cy));
        var rad:Number = Math.atan2(dy,dx);
        
        	ax += Math.cos(rad) * (_maxDist - 40) * 0.9;
        	ay += Math.sin(rad) * (_maxDist - 40) * 0.9;
        	
        	ax += (nvx/count)*0.2;
        	ay += (nvy/count)*0.2;

        	dx = (ncx/count - cx);
        	dy = (ncy/count - cy);
        	ax += dx * 0.2;
        	ay += dy * 0.2;
        	ax += (Math.random()*6 - 3);
        	ay += (Math.random()*6 - 3);
        	
        	ax += _target.vx * 0.01;
        	ay += _target.vy * 0.01;
        
        
        if (px < 50)ax += (50 - px) * 0.05;
        else if (px > _stage.stageWidth-50)ax += (_stage.stageWidth-50 - px) * 0.05;
        
        if (py < 50)ay += (50 - py) * 0.05;
        else if (py > _stage.stageHeight-50)ay += (_stage.stageHeight-50 - py) * 0.05;
    }
    
    public function Move():void
    {
        var v:Number = Math.sqrt(vx * vx + vy * vy);
        if (v > 16)
        {
            vx = vx / v * 16;
            vy = vy / v * 16;
        }
        else if (v < 8)
        {
            vx = vx / v * 8;
            vy = vy / v * 8;
        }
        
        vx += ax * (1.0/15);
        vy += ay * (1.0/15);
        
        cx += vx * (1.0/15);
        cy += vy * (1.0/15);
        px += vx * (1.0/15);
        py += vy * (1.0/15);
        
        this.x = px;
        this.y = py;
        this.rotation = Math.atan2(vy,vx)*180/Math.PI;
    }
}
