/**
 * Copyright WLAD ( http://wonderfl.net/user/WLAD )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/KqjZ
 */

// forked from seo's forked from: flash on 2013-6-14
// forked from mwelsh's flash on 2013-6-14
    

package {

    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.Point;

    public class Wiggle extends Sprite {
        public const NUM_POINTS : int = 50;
        public const MAX_DIFF : Number = 3;
        public const NUM_PASSES : int = 5;
        public const GRAVITY : Number = .5;
        
        private var wigglePoints : Vector.<WigglePoint>;
        private var pointDistance : Number;
        private var mouseDistance : Number;

        public function Wiggle() {
            wigglePoints = new Vector.<WigglePoint>();

            for(var i:int = 0; i<NUM_POINTS; i++) {
                var x : Number = i / (NUM_POINTS - 1) * stage.stageWidth;
                var y : Number = stage.stageHeight / 2;
                wigglePoints[i] = new WigglePoint(x, y);
            }
            pointDistance = stage.stageWidth / (NUM_POINTS - 1);
            mouseDistance = stage.stageWidth * 0.1;
            
            stage.frameRate = 30;
            addEventListener(Event.ENTER_FRAME, onEnterFrame);

        }

        private function onEnterFrame(e : Event) : void {
            verletIntegrate();
            for(var i:int=0; i<NUM_PASSES; i++) satisfyConstraints();
            drawWiggle();
        }
        
        private function verletIntegrate() : void {
            for(var i:int = 0; i<NUM_POINTS; i++) {
                var point : WigglePoint = wigglePoints[i];
                var pos : Point = point.pos;
                var posX : Number  = point.pos.x;
                var posY : Number = point.pos.y
                var oldPos : Point = point.oldPos;
                pos.x += (pos.x - oldPos.x);
                pos.y += (pos.y - oldPos.y) + GRAVITY;
                oldPos.x = posX;
                oldPos.y = posY;
            }

        }
        

        private function satisfyConstraints() : void {
            var i : int;
            var pt : Point;
            var delta : Point;
            var len : Number;
            var lengthDiff : Number;
            var mousePos : Point = new Point(mouseX, mouseY);
            
            // CONSTRAINT 1: Keep away from mouse
            for(i = 0; i<NUM_POINTS; i++) {
                pt = wigglePoints[i].pos;
                delta = mousePos.subtract(pt);
                len = delta.length;
                if(len <= mouseDistance)
                {
                    lengthDiff = (len - mouseDistance) / len;
                    
                    delta.x *= lengthDiff;
                    delta.y *= lengthDiff;

                    pt.x += delta.x;
                    pt.y += delta.y;
                }
            }

            
            var pt0 : Point;
            var pt1 : Point;
            // CONSTRAINT 2: Keep distance between points constant
            for(i = 1; i<NUM_POINTS; i++) {
                pt0 = wigglePoints[i-1].pos;
                pt1 = wigglePoints[i].pos;
                
                // move points toward required distance
                delta = pt1.subtract(pt0);
                len = delta.length;
                lengthDiff = (len - pointDistance) / len;
                
                delta.x *= lengthDiff*0.5;
                delta.y *= lengthDiff*0.5;
                
                pt0.x += delta.x;
                pt0.y += delta.y;
                
                pt1.x -= delta.x;
                pt1.y -= delta.y;
            }
            //trace(wigglePoints[1].pos);
            // CONSTRAINT 2: Keep beginning and end of rope tied to edge
            wigglePoints[0].pos.x = 0;
            wigglePoints[0].pos.y = stage.stageHeight / 2;
            wigglePoints[NUM_POINTS-1].pos.x = stage.stageWidth;
            wigglePoints[NUM_POINTS-1].pos.y = stage.stageHeight / 2;
         
        }


        
        private function drawWiggle() : void {
            graphics.clear();
            graphics.lineStyle(2, 0xff0000);
            graphics.moveTo(wigglePoints[0].pos.x, wigglePoints[0].pos.y);
            for(var i:int = 1; i<NUM_POINTS; i++) {
                var point : Point = wigglePoints[i].pos;
                graphics.lineTo(point.x, point.y);
            }
        }

    }
}


import flash.geom.Point;

class WigglePoint {
    public var pos : Point;
    public var oldPos : Point;

    public function WigglePoint(x : Number, y : Number) {
        pos = new Point(x, y);
        oldPos = new Point(x, y);
    }
}