/**
 * Copyright and ( http://wonderfl.net/user/and )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/Kp0l
 */

// forked from Hiiragi's Fusion : forked from: SPEC vol.5 投稿用コード
// forked from Event's SPEC vol.5 投稿用コード

//

// BGM / SE ：フリー音楽素材 Senses Circuit

// http://www.senses-circuit.com/

//

// SE : TAM MUSIC FACTORY

// http://www.tam-music.com/index.html



// 魔法陣

// http://www.pixiv.net/member_illust.php?mode=medium&illust_id=28640536

//

//



package 

{

    import a24.tween.Tween24;

    import flash.display.DisplayObjectContainer;

    import flash.display.Loader;

    import flash.display.MovieClip;

    import flash.display.Sprite;

    import flash.events.Event;

    import flash.media.Sound;

    import flash.media.SoundLoaderContext;

    import flash.media.SoundTransform;

    import flash.net.URLRequest;

    import flash.system.ApplicationDomain;

    import flash.system.LoaderContext;

    import flash.system.Security;

    import flash.system.System;

    import flash.utils.Dictionary;

    

    /**

     * ...

     * @author Hiiragi

     */

    [SWF(width="465", height="465", backgroundColor="0x0", frameRate="60")]

    public class Main extends Sprite 

    {

        private var _loadAssets:Array = [ { id:"card1", url:"http://melancholy.raindrop.jp/flash/wonderfl_6/card1.jpg" }

                                            ,  { id:"card2", url:"http://melancholy.raindrop.jp/flash/wonderfl_6/card2.jpg" }

                                            ,  { id:"card3", url:"http://melancholy.raindrop.jp/flash/wonderfl_6/card3.jpg" }

                                            ,  { id:"card4", url:"http://melancholy.raindrop.jp/flash/wonderfl_6/card4.jpg" }

                                            ,  { id:"card5", url:"http://melancholy.raindrop.jp/flash/wonderfl_6/card5.jpg" }

                                            ,  { id:"card6", url:"http://melancholy.raindrop.jp/flash/wonderfl_6/card6.jpg" }

                                            ,  { id:"base_before", url:"http://melancholy.raindrop.jp/flash/wonderfl_6/base_before.jpg" }

                                            ,  { id:"base_after", url:"http://melancholy.raindrop.jp/flash/wonderfl_6/base_after.jpg" }

                                            ,  { id:"magical_circle", url:"http://melancholy.raindrop.jp/flash/wonderfl_6/magic.png" }

                                            ,  { id:"bgm1", url:"http://melancholy.raindrop.jp/flash/wonderfl_6/bgm.mp3" }

                                            ,  { id:"se_ascension1", url:"http://melancholy.raindrop.jp/flash/wonderfl_6/ascension1.mp3" }

                                            ,  { id:"se_ascension2", url:"http://melancholy.raindrop.jp/flash/wonderfl_6/ascension2.mp3" }

                                            ,  { id:"se_burst", url:"http://melancholy.raindrop.jp/flash/wonderfl_6/burst.mp3" }

                                            ,  { id:"se_burst2", url:"http://melancholy.raindrop.jp/flash/wonderfl_6/burst2.mp3" }

                                            ,  { id:"se_complete", url:"http://melancholy.raindrop.jp/flash/wonderfl_6/complete.mp3" }

                                            ,  { id:"se_attack", url:"http://melancholy.raindrop.jp/flash/wonderfl_6/attack.mp3" }

                                            ,  { id:"se_kira", url:"http://melancholy.raindrop.jp/flash/wonderfl_6/kira.mp3" }

                                            ,  { id:"se_condensation", url:"http://melancholy.raindrop.jp/flash/wonderfl_6/condensation.mp3" }

                                            ,  { id:"se_appearance", url:"http://melancholy.raindrop.jp/flash/wonderfl_6/appearance.mp3" }

                                            ];

                                            

        

        

        

        public function Main():void 

        {

            if (stage) init();

            else addEventListener(Event.ADDED_TO_STAGE, init);

        }

        

        private function init(e:Event = null):void 

        {

            removeEventListener(Event.ADDED_TO_STAGE, init);

            

            var count:int = 0;

            var maxCount:int = _loadAssets.length;

            var vo:Object;

            var loader:Loader = new Loader();

            var sound:Sound;

            loader.contentLoaderInfo.addEventListener(Event.COMPLETE, onLoadCompleteHandler);

            var req:URLRequest = new URLRequest();

            var lc:LoaderContext = new LoaderContext(true);

            var slc:SoundLoaderContext = new SoundLoaderContext(1000, true);

            load();

            

            function load():void

            {

                vo = _loadAssets[count];

                req.url = vo.url;

                if (req.url.indexOf(".mp3") > -1)

                {

                    sound = new Sound();

                    sound.addEventListener(Event.COMPLETE, onSoundLoadCompleteHandler);

                    sound.load(req, slc);

                }

                else

                {

                    loader.load(req, lc);

                }

                

            }

            

            function onSoundLoadCompleteHandler(event:Event):void

            {

                sound.removeEventListener(Event.COMPLETE, onSoundLoadCompleteHandler);

                AssetDictionary.dictionary[vo.id] = sound;

                checkNextTask();

            }

            

            function onLoadCompleteHandler(event:Event):void

            {

                AssetDictionary.dictionary[vo.id] = loader.content;

                checkNextTask();

            }

            

            function checkNextTask():void

            {

                count++;

                if (count >= maxCount)

                {

                    loader.contentLoaderInfo.removeEventListener(Event.COMPLETE, onLoadCompleteHandler);

                    

                    AssetDictionary.dictionary["card1"] = new Card("card1", AssetDictionary.dictionary["card1"]);

                    AssetDictionary.dictionary["card2"] = new Card("card2", AssetDictionary.dictionary["card2"]);

                    AssetDictionary.dictionary["card3"] = new Card("card3", AssetDictionary.dictionary["card3"]);

                    AssetDictionary.dictionary["card4"] = new Card("card4", AssetDictionary.dictionary["card4"]);

                    AssetDictionary.dictionary["card5"] = new Card("card5", AssetDictionary.dictionary["card5"]);

                    AssetDictionary.dictionary["card6"] = new Card("card6", AssetDictionary.dictionary["card6"]);

                    AssetDictionary.dictionary["base_after"] = new Card("base_after", AssetDictionary.dictionary["base_after"]);

                    

                    

                    //bgm

                    var s:Sound = AssetDictionary.dictionary["bgm1"] as Sound;

                    s.play(0, int.MAX_VALUE, new SoundTransform(0.6));

                    

                    //scene

                    startFirstState();

                    //startSecondState();

                    //startThirdState();

                    

                    

                }

                else

                {

                    load();

                }

            }

        }

        

        private function startFirstState():void

        {

            var w:int = this.stage.stageWidth / 3;

            var h:int = this.stage.stageHeight / 2;

            

            var container:Sprite = new Sprite();

            var rect1:Scene1Rect = new Scene1Rect(w, h, 0xBB0000, AssetDictionary.dictionary["card1"]);

            container.addChild(rect1);

            

            var rect2:Scene1Rect = new Scene1Rect(w, h, 0x00BB00, AssetDictionary.dictionary["card2"]);

            rect2.x = w;

            container.addChild(rect2);

            

            var rect3:Scene1Rect = new Scene1Rect(w, h, 0x0000BB, AssetDictionary.dictionary["card3"]);

            rect3.x = w * 2;

            container.addChild(rect3);

            

            var rect4:Scene1Rect = new Scene1Rect(w, h, 0xBB00BB, AssetDictionary.dictionary["card4"]);

            rect4.y = h;

            container.addChild(rect4);

            

            var rect5:Scene1Rect = new Scene1Rect(w, h, 0xBBBB00, AssetDictionary.dictionary["card5"]);

            rect5.x = w;

            rect5.y = h;

            container.addChild(rect5);

            

            var rect6:Scene1Rect = new Scene1Rect(w, h, 0x00BBBB, AssetDictionary.dictionary["card6"]);

            rect6.x = w * 2;

            rect6.y = h;

            container.addChild(rect6);

            

            this.addChild(container);

            rect1.addEventListener(Event.COMPLETE, scene1CompleteHandler);

            

            rect1.startAnimation();

            rect2.startAnimation();

            rect3.startAnimation();

            rect4.startAnimation();

            rect5.startAnimation();

            rect6.startAnimation();

            



            

            function scene1CompleteHandler(event:Event):void

            {

                startSecondState();

            }

        }

        

        protected function startSecondState():void

        {

            var blackSp:Sprite = new Sprite();

            blackSp.graphics.beginFill(0x0);

            blackSp.graphics.drawRect(0, 0, this.stage.stageWidth, this.stage.stageHeight);

            blackSp.graphics.endFill();

            blackSp.y = -blackSp.height;

            blackSp.alpha = 0;

            this.addChild(blackSp);

            

            var scene:Scene2Rect = new Scene2Rect(this.stage.stageWidth, this.stage.stageHeight, 0x000022, [AssetDictionary.dictionary["card1"]

                                                                                                    , AssetDictionary.dictionary["card2"]

                                                                                                    , AssetDictionary.dictionary["card3"]

                                                                                                    , AssetDictionary.dictionary["card4"]

                                                                                                    , AssetDictionary.dictionary["card5"]

                                                                                                    , AssetDictionary.dictionary["card6"]

                                                                                                    ]

                                                                                                    , AssetDictionary.dictionary["magical_circle"]);

            scene.alpha = 0;

            scene.addEventListener(Event.COMPLETE, onCompleteHandler);

            this.addChild(scene);

            

            Tween24.serial(

                            Tween24.parallel(

                            Tween24.tween(scene, 0.5).alpha(1)

                            , Tween24.tween(blackSp, 0.5).y(0).alpha(1)

                            )

                        , Tween24.func(scene.startAnimation)

                        ).play();

            

            var that:DisplayObjectContainer = this;

            function onCompleteHandler(event:Event):void

            {

                startThirdState();    

            }

        }

        

        protected function startThirdState():void

        {

            var scene:Scene3Rect = new Scene3Rect(this.stage.stageWidth, this.stage.stageHeight, 0xFFFF99, AssetDictionary.dictionary["base_after"]);

            this.addChild(scene);

            scene.startAnimation();

            

        }

        

    }

    

    

    

}







import a24.tween.Ease24;

import a24.tween.EventTween24;

import a24.tween.Tween24;

import a24.tween.Tween24Event;

import flash.display.Bitmap;

import flash.display.BitmapData;

import flash.display.BlendMode;

import flash.display.ColorCorrection;

import flash.display.DisplayObject;

import flash.display.GradientType;

import flash.display.Sprite

import flash.display.StageQuality;

import flash.events.Event;

import flash.filters.BlurFilter;

import flash.filters.GlowFilter;

import flash.geom.ColorTransform;

import flash.geom.Matrix;

import flash.geom.Point;

import flash.geom.Rectangle;

import flash.geom.Vector3D;

import flash.media.Sound;

import flash.media.SoundTransform;

import flash.utils.Dictionary;



internal class AssetDictionary

{

    public static var dictionary:Dictionary = new Dictionary();

}



internal class SceneRectBase extends Sprite

{

    protected var _width:int;

    protected var _height:int;

    protected var _color:uint;

    

    

    protected var _lightColor:uint;

    protected var _backSp:Sprite;

    protected var _lightBmp:Bitmap;

    protected var _lightBmpd:BitmapData;

    protected var _maskSp:Sprite;

    

    protected var _particles:Vector.<LightArrow>;

    

    public function SceneRectBase(width:int, height:int, color:uint)

    {

        _width = width;

        _height = height;

        _color = color;

        

        _backSp = new Sprite();

        var r:uint = Math.min((color >> 16 & 0xFF) + 200, 255);

        var g:uint = Math.min((color >> 8 & 0xFF)+ 200, 255);

        var b:uint = Math.min((color & 0xFF) + 200, 255);

        _lightColor = r << 16 | g << 8 | b;

        

        //back

        var mtx:Matrix = new Matrix();

        mtx.createGradientBox(width, height);

        _backSp.graphics.beginGradientFill(GradientType.LINEAR, [ color, _lightColor, color], [1, 1, 1], [0, 127, 255], mtx);

        _backSp.graphics.drawRect(0, 0, width, height);

        _backSp.graphics.endFill();

        this.addChild(_backSp);

        

        //light

        _lightBmpd = new BitmapData(width, height, true, 0x0);

        _lightBmp = new Bitmap(_lightBmpd);

        this.addChild(_lightBmp);

        _particles = new Vector.<LightArrow>();

        for (var i:int = 0; i < 30; i++)

        {

            var p:LightArrow = new LightArrow();

            p.x = width * Math.random();

            p.y = (height + 200) * Math.random() - 100;

            p.thickness = 5 * Math.random();

            _particles.push(p);

        }

        

        startMoveLight();

    }

    

    

    public function startAnimation():void

    {

    }

    

    public function startMoveLight():void

    {

        this.addEventListener(Event.ENTER_FRAME, drawLight);

    }

    

    private function drawLight(e:Event):void 

    {

        var len:int = _particles.length;

        var rect:Rectangle = new Rectangle();

        _lightBmpd.lock();

        _lightBmpd.colorTransform(_lightBmpd.rect, new ColorTransform(1, 1, 1, 0.8));

        

        for (var i:int = 0; i < len; i++)

        {

            var p:LightArrow = _particles[i];

            p.y += p.thickness * 4;

            if (p.y > _height + 200) p.y = -200;

            

            rect.x = p.x - p.thickness / 2;

            rect.y = p.y;

            rect.width = p.thickness;

            rect.height = 200 / p.thickness;

            

            _lightBmpd.fillRect(rect, 0xFFFFFFFF);

        }

        _lightBmpd.unlock();

    }

    

    public function stopMoveLight():void

    {

        this.removeEventListener(Event.ENTER_FRAME, drawLight);

        //_lightBmpd.fillRect(_lightBmpd.rect, 0x0);

    }

}





internal class Scene1Rect extends SceneRectBase

{

    protected var _cardContainer:Sprite;

    

    protected var _mirrorLightSp:Sprite;

    

    

    protected var _cardImage:DisplayObject;

    

    protected var _tween:Tween24;

    

    public function Scene1Rect(width:int, height:int, color:uint, cardImage:DisplayObject)

    {

        super(width, height, color);

        

        _cardImage = cardImage;

        

        //card

        _cardContainer = new Sprite();

        _cardContainer.x = width / 2;

        _cardContainer.y = -1000;

        _cardContainer.addChild(cardImage);

        cardImage.scaleX = cardImage.scaleY = 2;

        

        this.addChild(_cardContainer);

        

        _mirrorLightSp = new Sprite();

        _mirrorLightSp.graphics.beginFill(0xFFFFFF, 0.9);

        var diagonalLength:Number = Math.sqrt(width * width + height * height) + 100;

        var mirrorLightHeight:Number = 90;

        _mirrorLightSp.graphics.drawRect( -diagonalLength / 2, -mirrorLightHeight / 2, diagonalLength, mirrorLightHeight);

        _mirrorLightSp.rotation = -45;

        

        //mask

        _maskSp = new Sprite();

        _maskSp.graphics.beginFill(0x0);

        _maskSp.graphics.drawRect(0, 0, width, height);

        _maskSp.graphics.endFill();

        this.addChild(_maskSp);

        this.mask = _maskSp;

        

        

        var that:Sprite = this;

        

        _tween = Tween24.serial(

                Tween24.wait(0.3)

                , Tween24.func(function():void { var s:Sound = AssetDictionary.dictionary["se_appearance"] as Sound; s.play(0, 0, new SoundTransform(0.15)); } )

                , Tween24.tween(_cardContainer, 0.5, Ease24._6_ExpoOut).y(_height / 2)

                , Tween24.wait(0.1)

                , Tween24.addChild(this, _mirrorLightSp)

                , Tween24.func(function():void { var s:Sound = AssetDictionary.dictionary["se_kira"] as Sound; s.play(0, 0, new SoundTransform(0.04)); } )

                , Tween24.tween(_mirrorLightSp, 0.2).x(0).y(0)

                , Tween24.removeChild(_mirrorLightSp)

                , Tween24.wait(0.4)

                , Tween24.tween(_cardContainer, 0.3, null).scaleX(0.5).scaleY(0.5).rotationY(720)

                , Tween24.wait(0.9)

                ,Tween24.tween(_cardContainer, 0.4, null).y(_height / 2 + 20).color(_lightColor).blur()

                , Tween24.parallel(

                                Tween24.func(function():void { that.addEventListener(Event.ENTER_FRAME, drawAfterimage); } )

                                , Tween24.func(function():void { var s:Sound = AssetDictionary.dictionary["se_ascension1"] as Sound; s.play(0, 0, new SoundTransform(0.5)); } )

                                , Tween24.tween(_cardContainer, 0.3).y( -1000)

                                )

                , Tween24.wait(0.5)

                , Tween24.func(function():void { that.removeEventListener(Event.ENTER_FRAME, drawAfterimage); } )

                , Tween24.func(function():void { that.dispatchEvent(new Event(Event.COMPLETE));  } )

                );

    }

    

    private function drawAfterimage(event:Event):void

    {

        _lightBmpd.draw(this);

    }

    

    override public function startAnimation():void

    {

        _mirrorLightSp.x = _width;

        _mirrorLightSp.y = _height;

        

        _tween.play();

    }

}



internal class Scene2Rect extends SceneRectBase

{

    protected var _container:Sprite;

    protected var _cardImages:Array;

    protected var _magicalCircle:DisplayObject;

    

    protected var _afterimageBmp:Bitmap;

    protected var _afterimageBmpd:BitmapData;

    

    protected var _currentZPosition:Number;

    protected var _currentRadian:Number;

    protected var _currentRadius:Number;

    

    protected var _breakCardParticles:Array;

    

    protected var _breakCardParticlesContainer:Sprite;

    

    protected var _whiteFlashSp:Sprite;

    

    protected var _whiteBurstFlashSp:Sprite;

    

    public function Scene2Rect(width:int, height:int, color:uint, cardImages:Array, magicalCircle:DisplayObject)

    {

        super(width, height, color);

        

        

        var afterimageContainer:Sprite = new Sprite();

        afterimageContainer.x = width / 2;

        afterimageContainer.y = height / 2;

        this.addChild(afterimageContainer);

        

        _afterimageBmpd = new BitmapData(width, height, true, 0x0);

        afterimageContainer.addChild(_afterimageBmp = new Bitmap(_afterimageBmpd));

        _afterimageBmp.x = -width / 2;

        _afterimageBmp.y = -height / 2;

        

        _cardImages = cardImages;

        _magicalCircle = magicalCircle;

        

        _breakCardParticles = [];

        _breakCardParticlesContainer = new Sprite();

        _breakCardParticlesContainer.x = width / 2;

        _breakCardParticlesContainer.y = height / 2;

        _breakCardParticlesContainer.rotationX = -70;

        

        for (var i:int = 0; i < 300; i++)

        {

            var p:BreakCardParticle = new BreakCardParticle(0xFFFFFF * Math.random(), 40);

            p.x = p.y = p.z = 0;

            p.tx = Math.random() * _width * 2 - _width;

            p.ty = Math.random() * _height * 2 - _height;

            p.tz = Math.random() * 2000 - 1000;

            p.rotationX = 70;

            p.tween = Tween24.tween(p, 1.5, Ease24._6_ExpoOut).x(p.tx).y(p.ty).z(p.tz);

            _breakCardParticlesContainer.addChild(p);

            _breakCardParticles.push(p);

        }

        

        _whiteFlashSp = new Sprite();

        _whiteFlashSp.graphics.beginFill(0xFFFFFF);

        _whiteFlashSp.graphics.drawRect(0, 0, width, height);

        _whiteFlashSp.graphics.endFill();

        

        _whiteBurstFlashSp = new Sprite();

        _whiteBurstFlashSp.x = width / 2;

        _whiteBurstFlashSp.y = height / 2;

        var mtx:Matrix = new Matrix();

        mtx.createGradientBox(width, height, 0, -width / 2, -height / 2);

        _whiteBurstFlashSp.graphics.beginGradientFill(GradientType.RADIAL, [0xFFFF99, 0xFFFFFF], [1, 0.1], [0, 255], mtx);

        _whiteBurstFlashSp.graphics.drawCircle(0, 0 , width / 2);

        _whiteBurstFlashSp.graphics.endFill();

        _whiteBurstFlashSp.filters = [new BlurFilter(8, 8), new GlowFilter(0xFFFFFF, 1, 32, 32)];

        _whiteBurstFlashSp.scaleX = _whiteBurstFlashSp.scaleY = 0;



        

    }

    

    override public function startAnimation():void

    {

        _container = new Sprite();

        _container.rotationX = -70;

        _container.x = _width / 2;

        _container.y = _height / 2;

        this.addChild(_container);

        

        var len:int = _cardImages.length;

        _currentRadian = 0;

        var startRadian:Number = -Math.PI / 2;

        var diffRadian:Number = Math.PI * 2 / len;

        _currentRadius = 300;

        _currentZPosition = 500;

        

        for (var i:int = 0; i < len; i++)

        {

            var card:Card = _cardImages[i] as Card;

            card.scaleX = card.scaleY = 0.5;

            card.radian = startRadian + diffRadian * i;

            card.rotationX = 70;

            _container.addChild(card);

        }

        

        calcuratePositionOfCards();

        

        _magicalCircle.x = -_magicalCircle.width / 2;

        _magicalCircle.y = -_magicalCircle.height / 2;

        _magicalCircle.z = -300;

        _container.addChild(_magicalCircle);

        

        var s:Sound = AssetDictionary.dictionary["se_ascension2"] as Sound;

        s.play(0, 0, new SoundTransform(0.5));

        

        this.addEventListener(Event.ENTER_FRAME, drawSpiral);

    }

    

    protected function drawSpiral(event:Event):void

    {

        _currentRadius -= 2.5;

        

        if (_currentZPosition > 200) _currentZPosition -= 10;

        else _currentZPosition -= 1;

        

        _currentRadian += 0.01;

        if (_currentRadian > 0.5) _currentRadian = 0.5;

        

        calcuratePositionOfCards();

        

        //_afterimageBmpd.colorTransform(_afterimageBmpd.rect, new ColorTransform(1, 1, 1, 0.8, 200, 200, 200));

        //_afterimageBmpd.draw(this, new Matrix(1, 0, 0, 1, width / 2, height / 2));

        

        if (_currentRadius < 0)

        {

            this.removeEventListener(Event.ENTER_FRAME, drawSpiral);

            startImpactAnimation();

        }

    }

    

    protected function startImpactAnimation():void

    {

        _breakCardParticlesContainer.visible = false;

        this.addChild(_breakCardParticlesContainer);

        

        Tween24.serial(

                    Tween24.parallel(

                                    Tween24.tween(_cardImages, 0.2).z(-50)

                                    , Tween24.tween(_magicalCircle, 0.2).z(0)

                                    , Tween24.tween(_container, 0.2, Ease24._6_ExpoOut).scaleX(2).scaleY(2)

                                    )

                    , Tween24.func( stopMoveLight )

                    , Tween24.func( function():void

                        {

                            _whiteFlashSp.alpha = 1;

                            addChild(_whiteFlashSp);

                        })

                    , Tween24.tween(_whiteFlashSp, 0.25, Ease24._4_QuartIn).alpha(0)

                    , Tween24.tween(_whiteFlashSp, 0).alpha(1)

                    , Tween24.tween(_whiteFlashSp, 0.25, Ease24._4_QuartIn).alpha(0)

                    , Tween24.func( function():void

                        {

                            removeChild(_whiteFlashSp);

                        })

                    , Tween24.func( startMoveLight )

                    , Tween24.func(function():void { _magicalCircle.filters = [new GlowFilter(0xFF0000, 1, 8, 8, 2)]; _magicalCircle.transform.colorTransform = new ColorTransform(3, 1, 1, 1, 255, 0, 0); } )

                    , Tween24.func( removeCards )

                    , Tween24.func( breakCardAnimation )

                    ).play();

                        

    }

    

    protected function removeCards():void

    {

        var len:int = _cardImages.length;

        

        for (var i:int = 0; i < len; i++)

        {

            _container.removeChild(_cardImages[i]);

        }

    }

    

    protected var _breakDrawBmpd:BitmapData;

    protected var _breakDrawBmp:Bitmap;

    

    protected function breakCardAnimation():void

    {

        _breakDrawBmpd = new BitmapData(_width, _height, true, 0x0);

        this.addChild(_breakDrawBmp = new Bitmap(_breakDrawBmpd));

        

        var len:int = _breakCardParticles.length;

        for (var i:int = 0; i < len; i++)

        {

            var p:BreakCardParticle = _breakCardParticles[i];

            if (i == len - 1)

            {

                p.tween.addEventListener(Tween24Event.COMPLETE, breakCompleted);

            }

            p.tween.play();

        }

        _breakCardParticlesContainer.visible = true;

        var s:Sound = AssetDictionary.dictionary["se_burst"] as Sound;

        s.play(0, 0, new SoundTransform(0.5));

        

        function breakCompleted(event:Tween24Event):void

        {

            event.target.removeEventListener(Tween24Event.COMPLETE, breakCompleted);

            var s:Sound = AssetDictionary.dictionary["se_condensation"] as Sound;

            s.play(0, 0, new SoundTransform(0.7));

            addEventListener(Event.ENTER_FRAME, drawBreakAnimation);

        }

        

    }

    

    private var burstFlag:Boolean = false;

    private function drawBreakAnimation(e:Event):void 

    {

        var len:int = _breakCardParticles.length;

        var pt:Point = new Point();

        var diffRadian:Number = -0.2;

        var cos:Number = Math.cos(diffRadian);

        var sin:Number = Math.sin(diffRadian);

        

        for (var i:int = 0; i < len; i++)

        {

            var p:BreakCardParticle = _breakCardParticles[i];

            var length:Number = Math.sqrt(p.x * p.x + p.y + p.y + p.z * p.z) * 0.98; 

            var rad:Number = Math.atan2(p.y, p.x) - 0.2;

            pt = Point.polar(length, rad);

            

            //var tx:int = p.x * cos - p.y * sin;

            //var ty:int = p.x * sin + p.y * cos;

            p.x = pt.x;

            p.y = pt.y;

            p.z *= 0.9;

            p.scaleX = p.scaleY *= 0.96;

        }

        

        if (!burstFlag && p.scaleX < 0.2)

        {

            this.addChild(_whiteBurstFlashSp);

        

            var s:Sound = AssetDictionary.dictionary["se_burst2"] as Sound;

            s.play(0, 0, new SoundTransform(0.8));

        

            Tween24.serial(

                            Tween24.tween(_whiteBurstFlashSp, 1, Ease24._6_ExpoOut).scaleX(4).scaleY(4)

                            , Tween24.func(function():void { dispatchEvent(new Event(Event.COMPLETE)); } )

                            ).play();

                            

            burstFlag = true;

        }

        

        if (p.scaleX < 0.1)

        {

            removeEventListener(Event.ENTER_FRAME, drawBreakAnimation);

        }

        //_breakDrawBmpd.lock();

        //

        //_breakDrawBmpd.colorTransform(_breakDrawBmpd.rect, _ctf);

        //_breakDrawBmpd.draw(_breakCardParticlesContainer);

        //

        //_breakDrawBmpd.unlock();

    }

    

    protected function calcuratePositionOfCards():void

    {

        var len:int = _cardImages.length;

        

        for (var i:int = 0; i < len; i++)

        {

            var card:Card = _cardImages[i] as Card;

            card.radian += _currentRadian;

            card.x = Math.cos(card.radian) * _currentRadius;

            card.y = Math.sin(card.radian) * _currentRadius;

            card.z = _currentZPosition;

        }

        

        //y位置によって順序変え

        _cardImages.sortOn("y", Array.NUMERIC);

        

        for (i = 0; i < len; i++)

        {

            card = _cardImages[i] as Card;

            _container.addChild(card);

        }

    }

}



internal class Scene3Rect extends SceneRectBase

{

    protected var _card:Card;

    

    public function Scene3Rect(width:int, height:int, color:uint, card:Card)

    {

        super(width, height, color);

        _card = card;

        _card.x = width / 2;

        _card.y = height / 2;

        _card.scaleX = _card.scaleY = 2;

        this.addChild(_card);

    }

    

    override public function startAnimation():void

    {

        this.scaleX = this.scaleY = 3;

        Tween24.serial(

                Tween24.parallel(

                        Tween24.func(function():void { x = -200;  } )

                        , Tween24.func(function():void { var s:Sound = AssetDictionary.dictionary["se_attack"] as Sound; s.play(0, 0, new SoundTransform(0.25)); } )

                        , Tween24.wait(0.5)

                        )

                , Tween24.parallel(

                        Tween24.func(function():void

                            {

                                x = stage.stageWidth - width + 200;

                                y = stage.stageHeight - height + 200;

                            } )

                        , Tween24.func(function():void { var s:Sound = AssetDictionary.dictionary["se_attack"] as Sound; s.play(0, 0, new SoundTransform(0.25)); } )

                        , Tween24.wait(0.5)

                        )

                , Tween24.parallel(

                        Tween24.func(function():void

                            {

                                x = stage.stageWidth / 2 - width / 2;

                                y = stage.stageHeight / 2 - height / 2;

                            } )

                        , Tween24.func(function():void { var s:Sound = AssetDictionary.dictionary["se_attack"] as Sound; s.play(0, 0, new SoundTransform(0.25)); } )

                        , Tween24.wait(0.5)

                        )

                , Tween24.func(function():void { var s:Sound = AssetDictionary.dictionary["se_complete"] as Sound; s.play(0, 0, new SoundTransform(0.4)); } )

                , Tween24.tween(this, 0.3).scaleX(1).scaleY(1).x(0).y(0)

                //, Tween24.func( function():void

                        //{

                            //var cnt:int = 0;

                            //var maxCnt:int = 10;

                            //addEventListener(Event.ENTER_FRAME, function(event:Event):void

                                //{

                                    //cnt++;

                                    //

                                    //if (cnt <= maxCnt)

                                    //{

                                        //_card.x = width / 2 + Math.random() * 20 - 10;

                                        //_card.y = height / 2 + Math.random() * 20 - 10;

                                    //}

                                    //else

                                    //{

                                        //event.target.removeEventListener(Event.ENTER_FRAME, arguments.callee);

                                    //}

                                //});

                        //})

                ).play();

    }

}





internal class Particle extends Object

{

    public var x:int = 0;

    public var y:int = 0;

}



internal class LightArrow extends Particle

{

    public var thickness:int = 0;

}



internal class BreakCardParticle extends Sprite

{

    public var tx:int;

    public var ty:int;

    public var tz:int;

    public var tween:Tween24;

    

    public function BreakCardParticle(color:uint, radius:int)

    {

        this.blendMode = BlendMode.ADD;

        

        this.graphics.beginFill(color, 0.5);

        this.graphics.drawCircle( -radius, -radius, radius);

        this.graphics.endFill();

    }

}



internal class Card extends Sprite

{

    protected var _cardId:String;

    public function get cardId():String 

    {

        return _cardId;

    }

    

    

    protected var _radian:Number;

    

    public function get radian():Number 

    {

        return _radian;

    }

    

    public function set radian(value:Number):void 

    {

        _radian = value;

    }

    

    

    

    

    

    protected var _cardImage:DisplayObject;

    

    public function Card(cardId:String, cardImage:DisplayObject)

    {

        _cardId = cardId;

        _cardImage = cardImage;

        _cardImage.x = -_cardImage.width / 2;

        _cardImage.y = -_cardImage.height / 2;

        this.addChild(cardImage);

    }

}

