/**
 * Copyright hakerlab ( http://wonderfl.net/user/hakerlab )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/Kk8U
 */

// forked from majoraze's chain spring basic
// forked from majoraze's basic springing
// forked from majoraze's basic easing
// forked from majoraze's Throwing
package {
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.events.MouseEvent;
    
    public class Spring extends Sprite {
        private var spring:Number = .1;
        private var friction:Number = .8;
        private var gravity:Number = 5;
        private var balls:Array;
        private var numBalls:Number = 5;
        
        
        public function Spring() {
            init();
        }
        
        
        private function init():void {
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            
            balls = [];
            for (var i:int = 0; i < numBalls; i++) {
                var ball:Ball = new Ball(20);
                addChild(ball);
                balls.push(ball);
            }
            
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
        
        private function onEnterFrame(e:Event):void {
            //making a line to make more visible
            graphics.clear();
            graphics.lineStyle(1);
            graphics.moveTo(mouseX, mouseY);
            moveBall(balls[0], mouseX, mouseY);
            graphics.lineTo(balls[0].x, balls[0].y);
            
            for (var i:int = 1; i < numBalls; i++) {
                var ballA:Ball = balls[i-1];
                var ballB:Ball = balls[i];
                moveBall(ballB, ballA.x, ballA.y);
                graphics.lineTo(ballB.x, ballB.y);
            }

        }
        
        private function moveBall(ball:Ball, targetX:Number, targetY:Number):void {
            ball.vx += (targetX - ball.x) * spring;
            ball.vy += (targetY - ball.y) * spring;
            ball.vy += gravity;
            ball.vx *= friction;
            ball.vy *= friction;
            ball.x += ball.vx;
            ball.y += ball.vy;
        }

    }
}



//ball class

import flash.display.Sprite;

class Ball extends Sprite {
    public var radius:Number;
    private var color:uint;
    public var vx:Number = 0;
    public var vy:Number = 0;    
    
    public function Ball(radius:Number = 40, color:uint = 0xff0000) {
        this.radius = radius;
        this.color = color;
        
        init();
    }
    
    public function init():void {
        graphics.beginFill(color);
        graphics.drawCircle(0,0,radius);
        graphics.endFill()
    }
}
