/**
 * Copyright OKASUKE ( http://wonderfl.net/user/OKASUKE )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/KZ4l
 */

// forked from Event's Simple MediaRSS Viewer
/*
* 2010/08/29 OKASUKE
* Marble MediaRSS Viewer 
* 2010/08/30
* ローディング完了後、一瞬左上のMinimalのPushButtonが大きくなるのので
* RadioButtonに変更　
*  
* 
*/


package  
{    
    import flash.display.Sprite;
    import flash.events.Event;           
    import net.hires.debug.Stats;    
    
    [SWF(frameRate = 30,  backgroundColor=0x000000)]
    public class MediaRSSReader extends Sprite
    {            
        private var _state:Stats;        
        private var _imgView:RSSView;
        
        
        public function MediaRSSReader() 
        {
            if (stage) { _init() } else { addEventListener(Event.ADDED_TO_STAGE, _init) } ;
            //_state = new Stats();
            //addChildAt(_state, 1);
        }
        
        private function _init():void {
            removeEventListener(Event.ADDED_TO_STAGE, _init);   
                        
            //wonderflスクリーンショット背景用
            var bg:Sprite = new Sprite();    
            bg.graphics.beginFill(0x000000);
            bg.graphics.drawRect(0, 0, stage.stageHeight, stage.stageWidth);
            addChild(bg);
                                     
            _imgView = new RSSView();
            addChild(_imgView);  
            Wonderfl.capture_delay(30);                      
        }        
    }
}

//********************************************************************

    import com.bit101.components.ProgressBar;
    import com.bit101.components.Label;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.display.Loader;
    import flash.display.Sprite;
    import flash.display.Stage;
    import flash.display.Graphics;
    import flash.net.URLRequest;    
    import flash.net.URLLoader;
    import flash.system.LoaderContext;
    import flash.events.Event;
    import flash.geom.Point;    
    import jp.progression.commands.lists.SerialList;
    import jp.progression.commands.net.LoadBitmapData;
    import jp.progression.data.getResourceById;
    
    internal class RSSView extends Sprite
    {
            
        private var _btnController:BtnController;
        private var _imgController2:ImgController2;        
        
        public var _sp:Vector.<Sphere> = new Vector.<Sphere>;
        
        //private var _feed:String = "http://api.flickr.com/services/feeds/photos_public.gne?tags=kamakura&format=rss_200";
        private var media:Namespace = new Namespace("http://search.yahoo.com/mrss/");
            
        private var _contentURL_List:Array;
        private var _feed:String; 
        private var _feed2:String; 
        private var _feed3:String;
        private var _tag:String = "kamakura";
        
        private var _progbar:ProgressBar;
        private var _titleList:Vector.<String>;
        public static const KANKAKU:int = -100;
        private var _totalheight:int = 0;
                
        public function RSSView() 
        {            
            Init();
        }
        
        public function search(tags:String):void {
            _imgController2 = null
            for (var i:int = 0; i < _contentURL_List.length; ++i) {
                _sp[i]._moveflg = false;
                removeChild(_sp[i]);                
            }
            removeChild(_btnController);
            removeChild(_err);                        
            _tag = tags;
            
            _progbar.value = 0;            
            Init();
        }
        
        private function Init():void {
            
            _titleList = new Vector.<String>();
            _err = new Label(this, 220, 220, "");
            
            var ldr:URLLoader = new URLLoader;
            ldr.addEventListener(Event.COMPLETE, function _load(e:Event):void {
                ldr.removeEventListener(Event.COMPLETE, _load);
            
                for each(var item:String in XML(ldr.data)..media::title){
                    _titleList.push(item)
                }
                //contentからだと大きすぎる
                //_sをはずせば元のサムネイルではなくなる丁度いい大きさ                    
                onImageLoaded(XML(ldr.data)..media::thumbnail.@url.toXMLString().split('\n'));                
            });
            _feed = "http://api.flickr.com/services/feeds/photos_public.gne?tags="
            _feed2 = _tag;
            _feed3 = "&format=rss_200"
            _feed = _feed + _feed2 + _feed3;
            
            ldr.load(new URLRequest(_feed));
        }
                     
        private function onImageLoaded($images:Array):void {    
            
            _progbar = new ProgressBar(this, 200, 200);    
            _progbar.visible = true;
            
            _contentURL_List = $images;
            var list:SerialList = new SerialList();    
            list.onPosition = function():void {
                _progbar.value = list.position / list.numCommands;                
            }
            for (var i:int = 0; i < $images.length; i++) {
                list.addCommand(new LoadBitmapData(new URLRequest($images[i].replace("_s", "")), { context: new LoaderContext(true)}));
            } 
            list.onComplete = function():void {     dummyImage($images); }
            list.onError = function():void { errimg();}
            list.execute();    
            
        }
        
        //Tagが存在しないときのエラー追加
        private var _err:Label;
        private function errimg() {
            _err.text = "Tag Not Found!!";
            _progbar.visible = false;
            _btnController = new BtnController(this);
            addChild(_btnController);              
            _contentURL_List = [];
        }        
        
            
        private function dummyImage($images:Array):void {        
            
            _progbar.visible = false;
            //_progbar = null;
            
            var maximages:int = Math.min(20, $images.length);
            
            
            _totalheight = maximages * KANKAKU;
            for (var i:int = 0; i < maximages; ++i) {
                
                var bmd:BitmapData = getResourceById($images[i].replace("_s", "")).toBitmapData();                
                _sp[i] = new Sphere(bmd, _titleList[i], _totalheight);    //オブジェクト生成                            
                addChild(_sp[i]);                    
                _sp[i].x = 80;                
                _sp[i].y = i * KANKAKU  + stage.stageHeight;                
            }
                            
            //イメージ生成後
            _btnController = new BtnController(this);
            addChild(_btnController);
            _imgController2 = new ImgController2(this, _btnController);    
        }
        
        public function get feed2():String {
            return _feed2;
        }
        
        public function get totalheight():int {
            return _totalheight;
        }
    }

//*****************************************************

    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;    
    import org.libspark.betweenas3.BetweenAS3;
    import org.libspark.betweenas3.easing.*;
    import org.libspark.betweenas3.tweens.ITween;
    
    import jp.progression.ui.ToolTip;    
    
    //Sphereオブジェ
    internal class Sphere extends Sprite
    {
        private var _spleaf:Sprite;
        private var _vertexs:Array;
        private var _defvertexs:Array;
        private var IMG_W:int = 320;
        private var IMG_H:int = 200;
        private static const SEGMENT:uint = 20;
        private var CENTERX:uint = 130;
        private var CENTERY:uint = 80;
        
        private var _bmd:BitmapData;
        private var _indices:Vector.<int> = new Vector.<int>();        
         
        public var _gy:Number = 3;
        private var _prevy:Number = 0;
        private var _prevx:Number = 80;
        
        private var _totalheight:int = 0;
        private var _openflg:Boolean = false;
        public var _moveflg:Boolean = true;
        private var updownflg:Boolean = false;
        
        
        public function Sphere(bmdata:BitmapData, title:String, totalheight:int)
        {            
            _bmd = bmdata;
            //広げると画像がつぶれるので...
            IMG_W = _bmd.width/1.5;
            IMG_H = _bmd.height/1.5;            
            
            _totalheight = totalheight;
            vertex();            
            setdata();    
            
            var tp:ToolTip = new ToolTip(this);
            tp.textColor = 0x000000;            
            tp.delay = 0;
            tp.text = title;
            
            
            addEventListener(Event.ENTER_FRAME, draw);            
        }
        
        private function draw(e:Event):void {
            
            var vertices:Vector.<Number> = new Vector.<Number>();            
            var uvtData:Vector.<Number> = new Vector.<Number>();
            //private var indices:Vector.<int> = new Vector.<int>();//1回にしとく
            
            for (var xx:int = 0; xx < SEGMENT; xx++) {
                for (var yy:int = 0; yy < SEGMENT; yy++) {
                    vertices[vertices.length] = _defvertexs[xx][yy].x
                    vertices[vertices.length] = _defvertexs[xx][yy].y
                    uvtData[uvtData.length] = xx / SEGMENT;
                    uvtData[uvtData.length] = yy / SEGMENT;
                }
            }            
            
            if(_moveflg) moving();            
            
            _spleaf = new Sprite();
            var g:Graphics = this.graphics;
            g.clear();
            g.beginBitmapFill(_bmd);
            //g.lineStyle(1, 0);
            g.drawTriangles(vertices, _indices, uvtData);
            g.endFill();
        }
            
        private function moving():void {            
            
            if (!updownflg) this.y += _gy;    
            else this.y -= _gy
            
            if (!updownflg && this.y - this.height >= stage.stageHeight ) {                
                this.y = _totalheight + stage.stageHeight + this.height;
                            } 
            
            if (updownflg && this.y  < _totalheight + stage.stageHeight + this.height) {
                this.y = stage.stageHeight + this.height;
                
            }
        
        }
        
        public function updownset(flg:Boolean):void {
            updownflg = flg;
        }        
        
        private function vertex():void {
            
            var rad:Number = Math.PI / 180 ;        
            
            _vertexs = [];
            _defvertexs = [];
            
            var radian:Number = Math.PI * 2 / 120;
            var offset:Number = 0
            for (var xx:int = 0; xx < SEGMENT; xx++) {
                _vertexs[xx] = [];
                _defvertexs[xx] = [];                    
                
                for (var yy:int = 0; yy < SEGMENT; yy++) {    
                    var angle1:Number = Math.PI * 2 / (SEGMENT-1) * yy
                    var angle2:Number = Math.PI * xx / (SEGMENT - 1) - Math.PI / 2;
                    var ypos:Number = Math.cos(angle1) * 20 * Math.cos(angle2);
                    var xpos:Number = Math.sin(angle2) * 20                 
                    
                    _defvertexs[xx][yy] = new Point(xpos , ypos);
                    _vertexs[xx][yy] = new Point(xpos, ypos);
                }                
            }               
        }
                
        private function setdata():void {
            var vertices:Vector.<Number> = new Vector.<Number>();            
            var uvtData:Vector.<Number> = new Vector.<Number>();        
            
            for (var xx:int = 0; xx < SEGMENT; xx++) {
                for (var yy:int = 0; yy < SEGMENT; yy++) {
                    vertices[vertices.length] = _defvertexs[xx][yy].x
                    vertices[vertices.length] = _defvertexs[xx][yy].y
                    uvtData[uvtData.length] = xx / SEGMENT;
                    uvtData[uvtData.length] = yy / SEGMENT;
                }
            }
            
            for (var i:int = 0; i < SEGMENT - 1; i++) {
                for (var j:int = 0; j < SEGMENT - 1; j++) {
                    _indices.push(i * SEGMENT + j, i * SEGMENT + j + 1, (i + 1) * SEGMENT + j);
                    _indices.push(i * SEGMENT + j + 1, (i + 1) * SEGMENT + 1 + j, (i + 1) * SEGMENT + j);
                }
            }            
        }
        
        //参考(Ginny Effect Modoki)　see→ http://wonderfl.net/c/qnTR
        public function openimg(py:Number):void {            
            
            _openflg = true;
            _prevy = py;    
            var tweens:Array = [];
            var xx:int, yy:int, delay:Number;
            var px:Number = SEGMENT * (mouseX / IMG_W);
            var py:Number = SEGMENT * (mouseY / IMG_H);            
            
            var tt1:ITween = BetweenAS3.tween(this, { x:CENTERX }, null, 1, Cubic.easeInOut);
            var tt2:ITween = BetweenAS3.tween(this, { y:CENTERY }, null, 1, Cubic.easeInOut);
            for (xx = 0; xx < SEGMENT; xx++) {
                    for (yy = 0; yy < SEGMENT; yy++) {
                        
                        //delay = Math.sqrt(yy * Math.sin(60 / Math.PI * 180) + xx * Math.cos(60 / Math.PI * 180)) / 4;
                        delay = Math.sqrt(yy * Math.cos(60 / Math.PI * 180) + xx * Math.sin(60 / Math.PI * 180)) / 4;                        
                        //delay = Math.sqrt((yy - px) * (yy - px) + (xx - py) * (xx - py)) / 20;                         
                        
                        tweens.push(                            
                            BetweenAS3.delay(
                            BetweenAS3.tween(_defvertexs[xx][yy], {
                                x : xx * IMG_W / SEGMENT,
                                y : yy * IMG_H / SEGMENT
                            },null, delay, Bounce.easeOut),
                            delay / 2
                        )
                        
                    )
                }
            }        
            
            var itw:ITween = BetweenAS3.parallelTweens(tweens); 
            var t:ITween = BetweenAS3.serial(tt1, tt2, itw);
            t.play();            
            t.addEventListener(Event.COMPLETE, completeOpen);                
        }
        
        public function completeOpen(e:Event):void 
        {            
            removeEventListener(Event.COMPLETE, completeOpen);            
            dispatchEvent(e);            
        }
        
        public function closeimg(py:Number):void {
            
            _openflg = false;
            
            //元に戻す用
            vertex2();            
            
            var tweens:Array = [];
            var xx:int, yy:int, delay:Number;
            var px:Number = SEGMENT * (mouseX / IMG_W);
            var py:Number = SEGMENT * (mouseY / IMG_H);            
            
            var tt1:ITween = BetweenAS3.tween(this, { y:_prevy }, null, 1, Cubic.easeInOut);
            var tt2:ITween = BetweenAS3.tween(this, { x:_prevx }, null, 1, Cubic.easeInOut);
            
            for (xx = 0; xx < SEGMENT; xx++) {
                    for (yy = 0; yy < SEGMENT; yy++) {                        
                        
                        delay = Math.sqrt((xx - px) * (xx - px) + (yy - py) * (yy - py)) / 20;                           
                        tweens.push(                            
                            BetweenAS3.delay(                            
                            BetweenAS3.tween(_defvertexs[xx][yy], {
                                x : _vertexs[xx][yy].x,
                                y : _vertexs[xx][yy].y
                            },null, delay, Quad.easeIn),
                            delay / 2
                        )
                    )
                }
            }                    
            
            var itw:ITween = BetweenAS3.parallelTweens(tweens);  
            var t:ITween = BetweenAS3.serial(itw, tt1, tt2);
            t.play();                    
            t.addEventListener(Event.COMPLETE, completeClose);
        }
        
        private function vertex2():void {                
            
            _vertexs = [];            
                
            for (var xx:int = 0; xx < SEGMENT; xx++) {
                _vertexs[xx] = [];
                                
                for (var yy:int = 0; yy < SEGMENT; yy++) {    
                    var angle:Number = Math.PI * 2 / (SEGMENT-1) * yy
                    var angle2:Number = Math.PI * xx / (SEGMENT - 1) - Math.PI / 2;
                    var ypos:Number = Math.cos(angle ) * 20 * Math.cos(angle2);
                    var xpos:Number = Math.sin(angle2) * 20;                    
                    
                    _vertexs[xx][yy] = new Point(xpos, ypos);
                }                
            }               
        }        

        
        private function completeClose(e:Event):void 
        {            
            removeEventListener(Event.COMPLETE, completeClose);        
            dispatchEvent(e);            
        }
        
        public function get openflg():Boolean {
            return _openflg;
        }
        
        public function set openflg(value:Boolean):void {
            _openflg = value;
        }
    }    


//***********************************************************************    
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    
    internal class ImgController2
    {
        private var _btncontroller:BtnController;
        private var _imgview:RSSView;    
        private var _prevopen:Sphere
        
        public function ImgController2(view:RSSView, btncontroller:BtnController) 
        {
            _imgview = view;
            _btncontroller = btncontroller;
            
            var imglist:Vector.<Sphere> = new Vector.<Sphere>
            imglist = _imgview._sp;
            for (var i:int = 0;  i < imglist.length; i++) {
                imglist[i].addEventListener(MouseEvent.MOUSE_DOWN, DownEvent);
            }            
        }
            
        private var _sp:Sphere;
        private function DownEvent(e:MouseEvent):void 
        {            
            _sp = e.target as Sphere;                    
            
            if (!_sp.openflg)  {                 
                
                //前回のものを元に戻す
                if (_prevopen) {                     
                    _prevopen.closeimg(_prevopen.y);
                    _prevopen.addEventListener(Event.COMPLETE, onAllComp);
                } else {                    
                    _sp.openimg(_sp.y);
                    _sp.addEventListener(Event.COMPLETE, onOpen);
                }        
                
                _prevopen = _sp;
                movestop();
                
            } else  {                                
                _prevopen = null;                
                _sp.closeimg(_sp.y);
                _sp.addEventListener(Event.COMPLETE, onClose);
            }
            
            mouseLock();
            
            _sp.addEventListener(Event.COMPLETE, onDownComp);
        }
            
        private function onAllComp(e:Event = null):void {
            _prevopen.removeEventListener(Event.COMPLETE, onAllComp);            
            _sp.openimg(_sp.y);            
        }
        
        private function onClose(e:Event):void {
            _sp.removeEventListener(Event.COMPLETE, onClose);
            //trace("onClose");
            movestart();
        }
        
        private function onOpen(e:Event):void {
            _sp.removeEventListener(Event.COMPLETE, onOpen);
            //trace("ONOPEN");
        }
        
        private function movestop():void {
            //trace("STOP");
            var imglist:Vector.<Sphere> = new Vector.<Sphere>
            imglist = _imgview._sp;
            for (var i:int = 0;  i < imglist.length; i++) {
                imglist[i]._moveflg = false;
            }        
        }
        
        private function movestart():void {
            //trace("START");
            var imglist:Vector.<Sphere> = new Vector.<Sphere>
            imglist = _imgview._sp;
            for (var i:int = 0;  i < imglist.length; i++) {
                imglist[i]._moveflg = true;
            }        
        }        
        
        private function mouseLock():void {
            //trace("MOUSELOCK");
            var imglist:Vector.<Sphere> = new Vector.<Sphere>
            imglist = _imgview._sp;
            for (var i:int = 0;  i < imglist.length; i++) {
                imglist[i].mouseEnabled = false;
            }                
        }
        
        private function mouseOpen():void {
            //trace("MOUSEOPEN");
            var imglist:Vector.<Sphere> = new Vector.<Sphere>
            imglist = _imgview._sp;
            for (var i:int = 0;  i < imglist.length; i++) {
                imglist[i].mouseEnabled = true;
            }        
        }
        
        private function onDownComp(e:Event):void {    
            //trace("ONDOWNCOMP");
            _sp.removeEventListener(MouseEvent.MOUSE_DOWN, DownEvent);
            _sp.removeEventListener(Event.COMPLETE, onDownComp);
            _sp.addEventListener(MouseEvent.MOUSE_DOWN, DownEvent);            
            mouseOpen();            
        }        
    }


//********************************************************************
    import flash.display.Sprite;
    import flash.events.Event;    
    import com.bit101.components.*;    
    
    internal class BtnController extends Sprite
    {        
        private var _searchBtn:PushButton;
        private var _updownBtn:PushButton;
        private var _updownRadio:RadioButton;
        private var _textBox:Text;
        private var _imgview:RSSView;
        
        public function BtnController(view:RSSView) 
        {
            _imgview = view;
            _searchBtn = new PushButton(this, 360, 430, "TAGS SEARCH", clickSearch);
                      
            //これだと一瞬ボタンが大きくなる。
            //_updownBtn = new PushButton(this, 10, 10, "↑" , clickupdown);
            //_updownBtn.width = 10;
            //_updownBtn.height = 10;
            
            _updownRadio = new RadioButton(this, 10, 10, "", false, checkupdown);       
            
            _textBox = new Text(this, 230, 430, _imgview.feed2);
            _textBox.height = _searchBtn.height;
            _textBox.width = 120;
        }
            
        private function clickSearch(e:Event):void {            
            _imgview.search(_textBox.text);
        }
        
        private var _sp:Sphere;
        private var _updownflg:Boolean = true;
        //PushButton用
        private function clickupdown(e:Event):void {
            _updownflg = !_updownflg;                                                                                                                                                                                                                                                                                                                                                                       
            var imglist:Vector.<Sphere> = new Vector.<Sphere>
            imglist = _imgview._sp;
            for (var i:int = 0;  i < imglist.length; i++) {                
                imglist[i].updownset(!_updownflg);
            }        
        }
        //こちらを使用RadioButton用             
        private function checkupdown(e:Event):void {
            _updownflg = !_updownflg;                                                                                                                                                                                                                                                                                                                                                                       
            var imglist:Vector.<Sphere> = new Vector.<Sphere>
            imglist = _imgview._sp;
            for (var i = 0;  i < imglist.length; i++) {                
                imglist[i].updownset(!_updownflg);
            }        
        }               
        
    }
