/**
 * Copyright WLAD ( http://wonderfl.net/user/WLAD )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/KMGB
 */

package {
    import flash.display.Sprite;
	[SWF(width = "465", height = "465" )]
	public class WFLPortable extends Sprite
	{
		public function WFLPortable() 
		{
			WG.INIT( stage );
			
			var C:Canvas = new Canvas( this );
			C.DrawText( "WFLPortable\nVERSION 1\n\nMy classes\ncollection", WG.W2, WG.H2, true, 0xFFFFFF, 68, -1, "Consolas" );
		}
	}
}


// Minified single line WFLPortalbe ( http://wonderfl.net/c/KMGB )
// import flash.text.*;import flash.display.*;import flash.events.*;import flash.geom.*;class WG { static public var W2:int; static public var H2:int; static public var W:int; static public var H:int; static private var canvas:Shape; public static function INIT(stage:Stage, bgColor:uint=0x000000, frameRate:int=60, preventScale:Boolean=true):void{ canvas=new Shape();stage.addChildAt(canvas, 0); var onStageResize:Function=function(any:*=null):void { W=stage.stageWidth;W2=W>>1; H=stage.stageHeight;H2=H>>1; canvas.graphics.clear(); canvas.graphics.beginFill(bgColor); canvas.graphics.drawRect(0,0,W,H); canvas.graphics.endFill(); exe(onResize);}; stage.addEventListener('resize', onStageResize); stage.addEventListener('rightMouseDown', function(e:*):void{exe(onRightMouseDown);}); stage.addEventListener('rightMouseUp', function(e:*):void{exe(onRightMouseUp);}); stage.addEventListener('mouseDown', function(e:*):void{exe(onMouseDown);}); stage.addEventListener('mouseUp', function(e:*):void{exe(onMouseUp);}); stage.addEventListener('enterFrame', function(e:*):void{exe(onFrame);}); if(preventScale){stage.align='tl';stage.scaleMode='noScale';} stage.frameRate=frameRate; exe(onInit); onStageResize();} static private function exe(m:Function):void{if(m !=null)m();} static public var onMouseDown:Function=null; static public var onMouseUp:Function=null; static public var onRightMouseDown:Function=null; static public var onRightMouseUp:Function=null; static public var onFrame:Function=null; static public var onResize:Function=null; static public var onInit:Function=null;}class Canvas { public var limitMinX:Number=0; public var limitMinY:Number=0; public var limitMaxX:Number=500; public var limitMaxY:Number=500; protected function limitMinMax(val:Number, x:Boolean):Number{ if(x)return val<limitMinX?limitMinX :(val>limitMaxX?limitMaxX : val); return val<limitMinY?limitMinY :(val>limitMaxY?limitMaxY : val);}  public function Canvas(target:DisplayObjectContainer){ this.target=target; canvas=new Shape(); target.addChild(canvas);}  public function get display():Shape{return canvas;} private var target:DisplayObjectContainer; private var canvas:Shape; public function Clear():void{ canvas.graphics.clear();} public function DrawRect(color:uint, x:Number, y:Number, w:Number, h:Number):void{ canvas.graphics.lineStyle(); canvas.graphics.beginFill(color); canvas.graphics.drawRect(x, y, w, h); canvas.graphics.endFill();} public function DrawsRectangle(color:uint, area:Rectangle):void{ canvas.graphics.lineStyle(); canvas.graphics.beginFill(color); canvas.graphics.drawRect(area.x, area.y, area.width, area.height); canvas.graphics.endFill();} public function DrawCircle(color:uint, radius:Number, x:Number, y:Number):void{ canvas.graphics.lineStyle(); canvas.graphics.beginFill(color); canvas.graphics.drawCircle(x, y, radius); canvas.graphics.endFill();} public function DrawPoint(color:uint, point:Point):void{ DrawCircle(color, 4, point.x, point.y);}  public function DrawText(text:String, x:Number, y:Number, origin:Boolean=false, color:uint=0x808080, size:int=16, background:int=-1, font:String="_sans", bold:Boolean=false):void{ var tf:TextField=new TextField(); tf.autoSize='left'; tf.defaultTextFormat=new TextFormat(font, size, color, bold); tf.text=text; if(background !=-1){tf.background=true;tf.backgroundColor=background;} target.addChild(tf);var b:Rectangle=tf.getBounds(target); var bd:BitmapData=new BitmapData(b.width, b.height, true, 0x00000000); bd.draw(tf); target.removeChild(tf); tf=null; canvas.graphics.lineStyle(); var tx:Number=x-(origin?b.width/2 : 0); var ty:Number=y-(origin?b.height/2 : 0); canvas.graphics.beginBitmapFill(bd, new Matrix(1,0,0,1,tx,ty), false); canvas.graphics.drawRect(tx, ty, b.width, b.height); canvas.graphics.endFill();}} class DragBox extends Sprite { private var size:Number; private var min:Number; private var max:Number; private var onDrag:Function=null; private var color:uint=0x0; private var limitColor:uint=0xFF0000; private var oriantationHorizontal:Boolean;   public function DragBox(size:Number=20, color:uint=0xFF8000, min:Number=NaN, max:Number=NaN, oriantationHorizontal:Boolean=true, onDrag:Function=null){ this.size=size; this.oriantationHorizontal=oriantationHorizontal; this.color=color; this.min=min; this.max=max; this.onDrag=onDrag;  if(oriantationHorizontal)rotation=-90;  if(!isNaN(min))oriantationHorizontal?x=min : y=min;  scaleX=scaleY=1.4;  draw(0);  useHandCursor=buttonMode=true;  addEventListener("addedToStage", function(e:*=null):void { addEventListener("mouseDown",  function(e:*=null):void{ addEventListener("enterFrame", drag); });  stage.addEventListener("mouseUp", function(e:*=null):void{ scaleX=scaleY=1; removeEventListener("enterFrame", drag); });  });}   public function get travelArea():Rectangle { if(isNaN(min)||isNaN(max))return null;  var rect:Rectangle=new Rectangle(this.x-size/2, this.y-size/2, size+max-min, size+max-min);  if(oriantationHorizontal) { rect.height=size; rect.x=min-size/2; } else { rect.width=size; rect.y=min-size/2; }  return rect;}   public function get value():Number{ if(isNaN(min)||isNaN(max))return 0;  var N:Number=oriantationHorizontal?x : y;  return(N-min)/(max-min);}   public function draw(limit:int):void{  graphics.beginFill(limit==0?color : limitColor); graphics.drawRoundRect(-size/2,-size/2, size, size, size*(7/20)); graphics.endFill(); graphics.beginFill(0xFFFFFF);  if(limit<0) { graphics.moveTo(0,-size/4); graphics.lineTo(size/4, size/10); graphics.lineTo(-size/4, size/10); graphics.lineTo(0,-size/4); }  else if(limit>0) { graphics.moveTo(0, size/4); graphics.lineTo(size/4,-size/10); graphics.lineTo(-size/4,-size/10); graphics.lineTo(0, size/4);  } else graphics.drawCircle(0, 0, size/4); graphics.endFill();}  private function drag(e:*=null):void{ scaleX=scaleY=1.4;  var N:Number=oriantationHorizontal?parent.mouseX : parent.mouseY;  if(!isNaN(min)&&N<min) { N=min; scaleX=scaleY=1; draw(1); } else if(!isNaN(max)&&N>max) { N=max; scaleX=scaleY=1; draw(-1); }  else draw(0);  oriantationHorizontal?x=N : y=N;  if(onDrag !=null)onDrag();}} class DragPoint extends Sprite { public var dragBounds:Rectangle=null; public function styleAll( FillColor:uint=0x550200,  Radius:Number=6,  LineColor:uint=0xFB0600,  LineThikness:Number=2,  LineAlpha:Number=1,  Alpha:Number=1):void{ styleDown={lineThikness : LineThikness,lineColor : LineColor,lineAlpha : LineAlpha,fillColor : FillColor,radius : Radius,alpha : Alpha}; styleStatic={lineThikness : LineThikness,lineColor : LineColor,lineAlpha : LineAlpha,fillColor : FillColor,radius : Radius,alpha : Alpha}; styleNormal={lineThikness : LineThikness,lineColor : LineColor,lineAlpha : LineAlpha,fillColor : FillColor,radius : Radius,alpha : Alpha};}  public var styleDown:Object=null; public var styleStatic:Object=null; public var styleNormal:Object=null;  private var radius:Number=0; private var isStatic:Boolean; private var onMove:Function;   public function DragPoint(onMove:Function=null , isStatic:Boolean=false){  styleAll();  this.onMove=onMove; this.isStatic=isStatic; useHandCursor=buttonMode=true; addEventListener('addedToStage', function(e:*):void{  draw(isStatic?styleStatic : styleNormal); addEventListener('mouseDown', onMD);  });}  private function onMD(e:*):void { draw(styleDown); stage.addEventListener('mouseUp', onMU); stage.addEventListener('mouseMove', update);}  private function update(e:MouseEvent):void { if(!isStatic)this.x=parent.mouseX; this.y=parent.mouseY; if(dragBounds) { if(!isStatic) { if(this.x-radius<dragBounds.x) this.x=dragBounds.x+radius; if(this.x+radius>dragBounds.right) this.x=dragBounds.right-radius; }  if(this.y-radius<dragBounds.y) this.y=dragBounds.y+radius;  if(this.y+radius>dragBounds.bottom) this.y=dragBounds.bottom-radius; } if(onMove !=null) { if(onMove.length==1)onMove(this); else onMove(); }}  private function onMU(e:*):void { if(!stage)return; stage.removeEventListener('mouseUp', onMU); stage.removeEventListener('mouseMove', update); draw(isStatic?styleStatic : styleNormal);}  public function draw(style:Object):void{ graphics.clear(); graphics.lineStyle(style.lineThikness, style.lineColor, style.lineAlpha); graphics.beginFill(style.fillColor); graphics.drawCircle(0, 0, style.radius); graphics.endFill();  alpha=style.alpha; radius=style.radius+style.lineThikness/2;}}


/*
	Authod: http://wonderfl.net/user/WLAD 
	Contact : @WL4D3R

	WFLPortable classes [ VERSION 1 ]
	
	

---------------------------------------------------
Class [WG] wonder FL global class 
---------------

> WG.INIT( 
	stage:Stage, 
	bgColor:uint = 0x000000, 
	frameRate:int = 60, 
	preventScale:Boolean = true 
)

	WG.W = stageWidth
	WG.H = stageHeight
	WG.W2 = W / 2
	WG.H2 = H / 2
	
empty event functions ( EEF ):

	WG.onMouseDown
	WG.onMouseUp
	WG.onRightMouseDown
	WG.onRightMouseUp
	WG.onFrame 					- enter frame 
	WG.onResize 				- stage window size change 
	
override EEF inside constractor like so:
	
	MyClass() { 
	
		WG.INIT( stage );
	
		WG.onFrame = function():void {
			//...
		};
	}
	
	
	
---------------------------------------------------
Class [Canvas]
--------------

> Canvas( target:DisplayObjectContainer )

this class containes a shape object and 
accept a DisplayObjectContainer target 
as it's constractor argument. 
The shape object is then added to the target.

Change the limit values to allow wider drawing range:
	limitMinX
	limitMinY
	limitMaxX
	limitMaxY

use varius draw methods starting with the draw... prefix

call Clear() to clear graphics

access to the shape object threw the property 'display'



---------------------------------------------------
Class [DragBox]
--------------

Method onDrag passed in the constractor has no input arguments

> DragBox( 
	size:Number = 20, 
	color:uint = 0xFF8000, 
	min:Number = NaN, 
	max:Number = NaN,
	oriantationHorizontal:Boolean = true, 
	onDrag:Function = null 
) 

Check the component value / position relative to min, max.
the returned value range is between 0 and 1. Method will always 
return 0 if min, or max is NaN

>	get value():Number
	
The travel area of the drag box relevent to the parent. Return null if min or max is NaN.
	
>	get travelArea():Rectangle 

*/



import flash.text.*;
import flash.display.*;
import flash.events.*;
import flash.geom.*;

class WG /** @VERSION 1.3 : @Author @WL4D3R : 03.JAN.2016 */
{
	static public var W2:int;
	static public var H2:int;
	static public var W:int;
	static public var H:int;
	static private var canvas:Shape;
	public static function INIT( stage:Stage, bgColor:uint = 0x000000, frameRate:int = 60, preventScale:Boolean = true ):void {
		canvas = new Shape(); stage.addChildAt( canvas, 0 );
		var onStageResize:Function = function( any:* = null ):void  {
			W = stage.stageWidth;		W2 = W >> 1;
			H = stage.stageHeight;		H2 = H >> 1;
			canvas.graphics.clear();
			canvas.graphics.beginFill( bgColor );
			canvas.graphics.drawRect( 0,0,W,H);
			canvas.graphics.endFill();
			exe(onResize); };
		stage.addEventListener('resize', onStageResize );
		stage.addEventListener('rightMouseDown', function(e:*):void { exe(onRightMouseDown);  } );
		stage.addEventListener('rightMouseUp', function(e:*):void { exe(onRightMouseUp);  } );
		stage.addEventListener('mouseDown', function(e:*):void { exe(onMouseDown);  } );
		stage.addEventListener('mouseUp', function(e:*):void { exe(onMouseUp);  } );
		stage.addEventListener('enterFrame', function(e:*):void { exe(onFrame); } );
		if( preventScale ) { stage.align = 'tl'; stage.scaleMode = 'noScale'; }
		stage.frameRate = frameRate;
		exe(onInit);
		onStageResize();
	}
	static private function exe( m:Function ):void {if ( m != null ) m();}
	static public var onMouseDown:Function = null;
	static public var onMouseUp:Function = null;
	static public var onRightMouseDown:Function = null;
	static public var onRightMouseUp:Function = null;
	static public var onFrame:Function = null;
	static public var onResize:Function = null;
	static public var onInit:Function = null;
}

class Canvas /** @VERSION 1.2 : @Author @WL4D3R : 03.JAN.2016 */
{
	public var limitMinX:Number = 0;
	public var limitMinY:Number = 0;
	public var limitMaxX:Number = 500;
	public var limitMaxY:Number = 500;
	protected function limitMinMax( val:Number, x:Boolean ):Number
	{
		if ( x ) return val < limitMinX ? limitMinX : ( val > limitMaxX ? limitMaxX : val );
		return val < limitMinY ? limitMinY : ( val > limitMaxY ? limitMaxY : val );
	}
	
	public function Canvas( target:DisplayObjectContainer )
	{
		this.target = target;
		canvas = new Shape();
		target.addChild( canvas );
	}
	
	public function get display():Shape { return canvas; }
	private var target:DisplayObjectContainer;
	private var canvas:Shape;
	public function Clear():void{
		canvas.graphics.clear(); }
	public function DrawRect( color:uint, x:Number, y:Number, w:Number, h:Number ):void{
		canvas.graphics.lineStyle();
		canvas.graphics.beginFill( color );
		canvas.graphics.drawRect( x, y, w, h );
		canvas.graphics.endFill(); }
	public function DrawsRectangle( color:uint, area:Rectangle ):void{
		canvas.graphics.lineStyle();
		canvas.graphics.beginFill( color );
		canvas.graphics.drawRect( area.x, area.y, area.width, area.height );
		canvas.graphics.endFill(); }
	public function DrawCircle( color:uint, radius:Number, x:Number, y:Number ):void {
		canvas.graphics.lineStyle();
		canvas.graphics.beginFill( color );
		canvas.graphics.drawCircle( x, y, radius );
		canvas.graphics.endFill(); }
	public function DrawPoint( color:uint, point:Point ):void	{
		DrawCircle( color, 4, point.x, point.y ); }
	/** if origin is true, x & y repesent the text mid point  */
	public function DrawText( text:String, x:Number, y:Number, origin:Boolean = false, color:uint = 0x808080, size:int = 16, background:int = -1, font:String = "_sans", bold:Boolean = false ):void {
		var tf:TextField = new TextField();
		tf.autoSize = 'left';
		tf.defaultTextFormat = new TextFormat(font, size, color, bold);
		tf.text = text;
		if ( background != -1 ) {tf.background = true;tf.backgroundColor = background;}
		target.addChild( tf );var b:Rectangle = tf.getBounds(target);
		var bd:BitmapData = new BitmapData( b.width, b.height, true, 0x00000000 );
		bd.draw( tf );
		target.removeChild( tf );
		tf = null;
		canvas.graphics.lineStyle();
		var tx:Number = x - ( origin ? b.width / 2 : 0 );
		var ty:Number = y - ( origin ? b.height / 2 : 0 );
		canvas.graphics.beginBitmapFill( bd, new Matrix(1,0,0,1,tx,ty), false );
		canvas.graphics.drawRect( tx, ty, b.width, b.height );
		canvas.graphics.endFill();
	}
}

/* Original Source : http://wonderfl.net/c/4dXR */
class DragBox extends Sprite /** @VERSION 1.1 : @Author @WL4D3R : 03.JAN.2016 */
{
	private var size:Number;
	private var min:Number;
	private var max:Number;
	private var onDrag:Function = null;
	private var color:uint = 0x0;
	private var limitColor:uint = 0xFF0000;
	private var oriantationHorizontal:Boolean;
	
	/** onDrag method with no input arguments */
	public function DragBox( size:Number = 20, color:uint = 0xFF8000, min:Number = NaN, max:Number = NaN, oriantationHorizontal:Boolean = true, onDrag:Function = null ) 
	{
		this.size = size;
		this.oriantationHorizontal = oriantationHorizontal;
		this.color = color;
		this.min = min;
		this.max = max;
		this.onDrag = onDrag;
		
		if ( oriantationHorizontal ) rotation = -90;
		
		if ( !isNaN( min ) ) oriantationHorizontal ? x = min : y = min;
		
		scaleX = scaleY = 1.4;
		
		draw( 0 );
		
		useHandCursor = buttonMode = true;
		
		addEventListener("addedToStage", function(e:*= null):void
		{        
			addEventListener("mouseDown", 
				 function(e:*= null):void {
					addEventListener("enterFrame", drag);
			});
			
			stage.addEventListener("mouseUp",
				 function(e:*= null):void {
					scaleX = scaleY = 1; 
					removeEventListener("enterFrame", drag);
			});
			
		});
	}
	
	/** The travel area of the drag box relevent to the parent. Return null if min or max is NaN. */
	public function get travelArea():Rectangle 
	{
		if ( isNaN( min ) || isNaN( max ) ) return null;
		
		var rect:Rectangle = new Rectangle( this.x - size / 2, this.y - size / 2, size + max - min, size + max - min );
		
		if ( oriantationHorizontal ) 
		{
			rect.height = size;
			rect.x = min - size / 2;
		}
		else
		{
			rect.width = size;
			rect.y = min - size / 2;
		}
		
		return rect;
	}
	
	/** return value from 0 to 1 ( min, max ). If min or max is NaN return 0 */
	public function get value():Number
	{
		if ( isNaN( min ) || isNaN( max ) ) return 0;
		
		var N:Number = oriantationHorizontal ? x : y;
		
		return ( N - min ) / ( max - min );
	}
	 
	/** 0 : circle, -1 : up, +1, down */
	public function draw( limit:int ):void
	{
	  
	  graphics.beginFill( limit == 0 ? color : limitColor );
	  graphics.drawRoundRect(-size/2, -size/2, size, size, size*(7/20));
	  graphics.endFill();
	  graphics.beginFill(0xFFFFFF);
	 
	  if( limit < 0 ) 
	  {
			graphics.moveTo( 0, -size/4 );
			graphics.lineTo( size/4, size/10 );
			graphics.lineTo( -size/4, size/10 );
			graphics.lineTo( 0, -size/4 );
	  }
	  
	  else if ( limit > 0 ) 
	  {
			graphics.moveTo( 0, size/4 );
			graphics.lineTo( size/4, -size/10 );
			graphics.lineTo( -size/4, -size/10 );
			graphics.lineTo( 0, size/4 );
			
	  }
	  else graphics.drawCircle(0, 0, size/4 );
	  graphics.endFill();
	}
	
	private function drag(e:*= null):void
	{
		scaleX = scaleY = 1.4; 
		
		var N:Number = oriantationHorizontal ? parent.mouseX : parent.mouseY;
		
		if ( !isNaN( min ) && N < min ) 
		{
			N = min;
			scaleX = scaleY = 1;
			draw( 1 );
		}
		else if ( !isNaN( max ) && N > max ) 
		{
			N = max;
			scaleX = scaleY = 1;
			draw( -1 );
		}
		
		else draw( 0 ); 
		
		oriantationHorizontal ? x = N : y = N;
		
		if ( onDrag != null ) onDrag();
	}
}

/* Original Source : http://wonderfl.net/c/k28Z */
class DragPoint extends Sprite /** @VERSION 1.1 : @Author @WL4D3R : 03.JAN.2016 */
{
	public var dragBounds:Rectangle = null;
	public function styleAll( 
		FillColor:uint = 0x550200, 
		Radius:Number = 6, 
		LineColor:uint = 0xFB0600, 
		LineThikness:Number = 2, 
		LineAlpha:Number = 1, 
		Alpha:Number = 1
	) :void {
		styleDown = {lineThikness : LineThikness,lineColor : LineColor,lineAlpha : LineAlpha,fillColor : FillColor,radius : Radius,alpha : Alpha};
		styleStatic = {lineThikness : LineThikness,lineColor : LineColor,lineAlpha : LineAlpha,fillColor : FillColor,radius : Radius,alpha : Alpha};
		styleNormal = {lineThikness : LineThikness,lineColor : LineColor,lineAlpha : LineAlpha,fillColor : FillColor,radius : Radius,alpha : Alpha};
	}
	
	public var styleDown:Object = null;
	public var styleStatic:Object = null;
	public var styleNormal:Object = null;
		
	private var radius:Number = 0;
	private var isStatic:Boolean;
	private var onMove:Function;
	
	/** onMove can have 1 or no arguments, were the 1 agrumnet will pass the DragPoint itself */
	public function DragPoint( onMove:Function = null , isStatic:Boolean = false ) 
	{
		/* Aplly default style */
		styleAll();
		
		this.onMove = onMove;
		this.isStatic = isStatic;
		useHandCursor = buttonMode = true;
		addEventListener('addedToStage', function( e:*):void {
			
			draw( isStatic ? styleStatic : styleNormal );
			addEventListener('mouseDown', onMD);
			
		});
	}
		
	private function onMD(e:*):void 
	{
		draw( styleDown );
		stage.addEventListener('mouseUp', onMU);
		stage.addEventListener('mouseMove', update);
	}
	
	private function update(e:MouseEvent):void 
	{
		if ( !isStatic ) this.x = parent.mouseX;
		this.y = parent.mouseY;
		if ( dragBounds )
		{
			if ( !isStatic) 
			{
				if ( this.x - radius < dragBounds.x )
				this.x = dragBounds.x + radius;
				if ( this.x + radius > dragBounds.right )
				this.x = dragBounds.right - radius;                
			}
			
			if ( this.y - radius < dragBounds.y )
			this.y = dragBounds.y + radius;
			
			if ( this.y + radius > dragBounds.bottom )
			this.y = dragBounds.bottom - radius;
		}
		if ( onMove != null ) 
		{
			if ( onMove.length == 1 ) onMove( this );
			else onMove();
		}
	}
	
	private function onMU(e:*):void 
	{
		if ( !stage ) return;
		stage.removeEventListener('mouseUp', onMU);
		stage.removeEventListener('mouseMove', update);
		draw( isStatic ?  styleStatic : styleNormal );
	}
	
	public function draw( style:Object ):void
	{
		graphics.clear();
		graphics.lineStyle( style.lineThikness, style.lineColor, style.lineAlpha );
		graphics.beginFill( style.fillColor );
		graphics.drawCircle( 0, 0, style.radius );
		graphics.endFill();
		
		alpha = style.alpha;
		radius = style.radius + style.lineThikness / 2;
	}
}