/**
 * Copyright Cheshir ( http://wonderfl.net/user/Cheshir )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/KKK8
 */

package {
    import flash.events.MouseEvent;
    import flash.events.Event;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        
        public var wt:int = 96
        public var ht:int = 96;
        public var life:int = 32;
        public var field:Bitmap;
        public var check:Array = [];
        public var state_0:uint = 0xccffcc;
        public var state_1:uint = 0x44cc44;
        
        public function FlashTest() {
            // окей, попробуем создать саморазвивающийся клеточный автомат
            field = new Bitmap(new BitmapData(wt, ht, false, state_0));
            field.x = 32;  field.y = 32;
            field.scaleX = field.scaleY = 4;
            addChild(field);
            
            for(var tx:int=0; tx<wt; tx++){
                check[tx]=[];
                for(var ty:int=0; ty<ht; ty++){
                    check[tx][ty] = state_0;
                }
            }
            
            stage.addEventListener(Event.ENTER_FRAME, loop);
            stage.addEventListener(MouseEvent.CLICK, change);
        }
        
        private var checkStep:Boolean = true;
        // Шаг автомата
        private function loop(e:Event):void{
            var tx:int, ty:int;
            if(life<=0){
                return;
            }

            if(checkStep){
                for(tx=0; tx<wt; tx++){
                    for(ty=0; ty<ht; ty++){
                       check[tx][ty] = automat_01(tx, ty);
                    }
                }
            } else {
                for(tx=0; tx<wt; tx++){
                    for(ty=0; ty<ht; ty++){
                        field.bitmapData.setPixel(tx, ty, check[tx][ty]);
                    }
                }
            }
            checkStep = !checkStep;
            life--;
        }
        // Правила автомата
        private function automat_01(tx:int, ty:int):int{
            var state:uint = field.bitmapData.getPixel(tx,ty);
            var ar:uint = around(tx, ty);
            if(state==state_0){ // Клетка 0
                if(ar>0){
                    return state_1;
                }
            } else { // Клетка 1
                if(ar>1){
                    return state_0;
                } else {
                    return state_1;
                }
            }
            return state_0;
        }
        
        
        // Изменяем клетки мышкой.
        private function change(e:MouseEvent):void{
            var tx:int = (mouseX - 32)/4;
            var ty:int = (mouseY - 32)/4;
            if(field.bitmapData.getPixel(tx,ty)==state_0){
                field.bitmapData.setPixel(tx,ty,state_1);
            } else {
               field.bitmapData.setPixel(tx,ty,state_0); 
            }
        }
        // Определяем соседей по их типу
        private function around(tx:int, ty:int):int{
            var ar:int = 0;
            if(getLoopPixel(tx+1, ty)==state_1) ar += 1;
            if(getLoopPixel(tx-1, ty)==state_1) ar += 1;
            if(getLoopPixel(tx, ty+1)==state_1) ar += 1;
            if(getLoopPixel(tx, ty-1)==state_1) ar += 1;
            return ar;
        }
        private function getLoopPixel(tx:int, ty:int):uint{
            if(tx<0) tx += wt;
            if(ty<0) ty += ht;
            if(tx>wt-1) tx -= wt;
            if(ty>ht-1) ty -= ht;
            return field.bitmapData.getPixel(tx,ty);
        }
    }
}