/**
 * Copyright yangliu9812 ( http://wonderfl.net/user/yangliu9812 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/KA0U
 */

// forked from WLAD's forked from: Adaptive normalization test
// forked from makc3d's Adaptive normalization test
package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.media.SoundChannel;
    import flash.media.SoundMixer;
    import flash.utils.ByteArray;

    /**
     * Adatptive normalization test.
     */
    [SWF(backgroundColor=0)]
    public class NormalizerTest extends Sprite {
        public var mp3:ClientMP3Loader;
        public var bmp:BitmapData;
        public var song:SoundChannel;
        public function NormalizerTest () {
            mp3 = new ClientMP3Loader;
            mp3.addEventListener (Event.COMPLETE, loaded);

            bmp = new BitmapData (400, 100, true, 0);
            with (addChild (new Bitmap (bmp))) {
                x = 30; y = 260;
            }

            stage.addEventListener (MouseEvent.CLICK, click);
            stage.addEventListener (Event.ENTER_FRAME, loop);
        }
        public function click (e:MouseEvent):void {
            mp3.load ();
        }
        public function loaded (e:Event):void {
            if (song) song.stop ();
            song = mp3.sound.play (0, int.MAX_VALUE);
        }
        public var ba:ByteArray = new ByteArray, a:Array = [], b:Array = [];
        public function loop (e:Event):void {
            SoundMixer.computeSpectrum (ba, true);
            for (var i:int = 0; i < 100; i++) {
                a [i] = 0.5 * (ba.readFloat () + ba.readFloat ());
                if (i >= b.length) b [i] = new Normalizer;
            }

            graphics.clear ();

            // as is
            graphics.beginFill (0xFF0000);
            for (i = 0; i < 100; i++) {
                graphics.drawRect (30 + i * 4, 120, 4, -100 * a [i]);
            }
            graphics.endFill ();

            // normalized
            graphics.beginFill (0xFF00);
            for (i = 0; i < 100; i++) {
                graphics.drawRect (30 + i * 4, 240, 4, -100 * Normalizer (b [i]).f (a [i]));
            }

            // + max values
            for (i = 0; i < 100; i++) {
                graphics.drawRect (30 + i * 4, 120 -100 * Normalizer (b [i]).maximum (), 4, 1);
            }
            graphics.endFill ();

            // graph
            var va:Number = a [4];
            var vb:Number = Normalizer (b [4]).lastValue ();
            bmp.scroll ( -1, 0);
            bmp.setPixel32 (399, 0, 0xFFFFFFFF - bmp.getPixel32 (398, 0));
            for (i = 1; i < 99; i++) {
                var c:uint = 0xFF000000;
                if (i > 100 * (1 - va)) c += 0xFF0000;
                if (i > 100 * (1 - vb)) c += 0x00FF00;
                bmp.setPixel32 (399, i, c);
            }
            bmp.setPixel32 (399, 99, 0xFFFFFFFF);
        }
    }
}

/**
 * 1st draft of Normalizer class.
 */
class Normalizer {
    /** Damping. */
    public var d:Number = 0.9;
    /** Maximum minimum. */
    public var e:Number = 0.1;

    private var max:Number = e;
    private var val:Number = 0;

    public function maximum ():Number { return max; }
    public function lastValue ():Number { return val; }

    public function f (x:Number):Number {
        if (x < max) {
            max = d * max + (1 - d) * x; if (max < e) max = e;
            val = x / max;
        } else {
            max = x; if (max < e) max = e;
            val = d * val + (1 - d) * x / max;
        }
        return val;
    }
}

    import com.codeazur.as3swf.SWF;
    import com.codeazur.as3swf.SWFData;
    import com.codeazur.as3swf.data.SWFScene;
    import com.codeazur.as3swf.data.SWFSymbol;
    import com.codeazur.as3swf.data.consts.SoundCompression;
    import com.codeazur.as3swf.data.consts.SoundRate;
    import com.codeazur.as3swf.data.consts.SoundSize;
    import com.codeazur.as3swf.data.consts.SoundType;
    import com.codeazur.as3swf.tags.TagDefineSceneAndFrameLabelData;
    import com.codeazur.as3swf.tags.TagDefineSound;
    import com.codeazur.as3swf.tags.TagDoABC;
    import com.codeazur.as3swf.tags.TagEnd;
    import com.codeazur.as3swf.tags.TagFileAttributes;
    import com.codeazur.as3swf.tags.TagSetBackgroundColor;
    import com.codeazur.as3swf.tags.TagShowFrame;
    import com.codeazur.as3swf.tags.TagSymbolClass;
    import flash.display.Loader;
    import flash.display.LoaderInfo;
    import flash.events.Event;
    import flash.events.EventDispatcher;
    import flash.media.Sound;
    import flash.net.FileFilter;
    import flash.net.FileReference;
    import flash.utils.ByteArray;
    /**
     * This loads MP3 from HDD.
     * 
     * @see http://wiki.github.com/claus/as3swf/play-mp3-directly-from-bytearray
     * @see http://github.com/claus/as3swf/raw/master/bin/as3swf.swc
     */
    class ClientMP3Loader extends EventDispatcher {

        /**
         * Use this object after Event.COMPLETE.
         */
        public var sound:Sound;

        /**
         * Call this to load MP3 from HDD.
         */
        public function load ():void {
            file = new FileReference;
            file.addEventListener (Event.CANCEL, onUserCancelled);
            file.addEventListener (Event.SELECT, onFileSelected);
            file.addEventListener (Event.COMPLETE, onFileLoaded);
            file.browse ([ new FileFilter ("MP3 files", "*.mp3") ]);
        }

        private var file:FileReference;
        private function onUserCancelled (e:Event):void { dispatchEvent (new Event (Event.CANCEL)); }
        private function onFileSelected (e:Event):void { file.load (); }
        private function onFileLoaded (e:Event):void {
            // Wrap the MP3 with a SWF
            var swf:ByteArray = createSWFFromMP3 (file.data);
            // Load the SWF with Loader::loadBytes()
            var loader:Loader = new Loader();
            loader.contentLoaderInfo.addEventListener(Event.INIT, initHandler);
            loader.loadBytes(swf);
        }

        private function initHandler(e:Event):void {
            // Get the sound class definition
            var SoundClass:Class = LoaderInfo(e.currentTarget).applicationDomain.getDefinition("MP3Wrapper_soundClass") as Class;
            // Instantiate the sound class
            sound = new SoundClass() as Sound;
            // Report Event.COMPLETE
            dispatchEvent (new Event (Event.COMPLETE));
        }

        private function createSWFFromMP3(mp3:ByteArray):ByteArray
        {
            // Create an empty SWF
            // Defaults to v10, 550x400px, 50fps, one frame (works fine for us)
            var swf:SWF = new SWF();
            
            // Add FileAttributes tag
            // Defaults: as3 true, all other flags false (works fine for us)
            swf.tags.push(new TagFileAttributes());

            // Add SetBackgroundColor tag
            // Default: white background (works fine for us)
            swf.tags.push(new TagSetBackgroundColor());
            
            // Add DefineSceneAndFrameLabelData tag 
            // (with the only entry being "Scene 1" at offset 0)
            var defineSceneAndFrameLabelData:TagDefineSceneAndFrameLabelData = new TagDefineSceneAndFrameLabelData();
            defineSceneAndFrameLabelData.scenes.push(new SWFScene(0, "Scene 1"));
            swf.tags.push(defineSceneAndFrameLabelData);

            // Add DefineSound tag
            // The ID is 1, all other parameters are automatically
            // determined from the mp3 itself.
            swf.tags.push(TagDefineSound.createWithMP3(1, mp3));
            
            // Add DoABC tag
            // Contains the AS3 byte code for the document class and the 
            // class definition for the embedded sound
            swf.tags.push(TagDoABC.create(abc));
            
            // Add SymbolClass tag
            // Specifies the document class and binds the sound class
            // definition to the embedded sound
            var symbolClass:TagSymbolClass = new TagSymbolClass();
            symbolClass.symbols.push(SWFSymbol.create(1, "MP3Wrapper_soundClass"));
            symbolClass.symbols.push(SWFSymbol.create(0, "MP3Wrapper"));
            swf.tags.push(symbolClass);
            
            // Add ShowFrame tag
            swf.tags.push(new TagShowFrame());

            // Add End tag
            swf.tags.push(new TagEnd());
            
            // Publish the SWF
            var swfData:SWFData = new SWFData();
            swf.publish(swfData);
            
            return swfData;
        }
        
        private static var abcData:Array = [
            0x10, 0x00, 0x2e, 0x00, 0x00, 0x00, 0x00, 0x19, 0x07, 0x6d, 0x78, 0x2e, 0x63, 0x6f, 0x72, 0x65, 
            0x0a, 0x49, 0x46, 0x6c, 0x65, 0x78, 0x41, 0x73, 0x73, 0x65, 0x74, 0x0a, 0x53, 0x6f, 0x75, 0x6e, 
            0x64, 0x41, 0x73, 0x73, 0x65, 0x74, 0x0b, 0x66, 0x6c, 0x61, 0x73, 0x68, 0x2e, 0x6d, 0x65, 0x64, 
            0x69, 0x61, 0x05, 0x53, 0x6f, 0x75, 0x6e, 0x64, 0x12, 0x6d, 0x78, 0x2e, 0x63, 0x6f, 0x72, 0x65, 
            0x3a, 0x53, 0x6f, 0x75, 0x6e, 0x64, 0x41, 0x73, 0x73, 0x65, 0x74, 0x00, 0x15, 0x4d, 0x50, 0x33, 
            0x57, 0x72, 0x61, 0x70, 0x70, 0x65, 0x72, 0x5f, 0x73, 0x6f, 0x75, 0x6e, 0x64, 0x43, 0x6c, 0x61, 
            0x73, 0x73, 0x0a, 0x4d, 0x50, 0x33, 0x57, 0x72, 0x61, 0x70, 0x70, 0x65, 0x72, 0x0d, 0x66, 0x6c, 
            0x61, 0x73, 0x68, 0x2e, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x06, 0x53, 0x70, 0x72, 0x69, 
            0x74, 0x65, 0x0a, 0x73, 0x6f, 0x75, 0x6e, 0x64, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x05, 0x43, 0x6c, 
            0x61, 0x73, 0x73, 0x2a, 0x68, 0x74, 0x74, 0x70, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x61, 
            0x64, 0x6f, 0x62, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x32, 0x30, 0x30, 0x36, 0x2f, 0x66, 0x6c, 
            0x65, 0x78, 0x2f, 0x6d, 0x78, 0x2f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x07, 0x56, 
            0x45, 0x52, 0x53, 0x49, 0x4f, 0x4e, 0x06, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x07, 0x33, 0x2e, 
            0x30, 0x2e, 0x30, 0x2e, 0x30, 0x0b, 0x6d, 0x78, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 
            0x6c, 0x06, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x0c, 0x66, 0x6c, 0x61, 0x73, 0x68, 0x2e, 0x65, 
            0x76, 0x65, 0x6e, 0x74, 0x73, 0x0f, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x44, 0x69, 0x73, 0x70, 0x61, 
            0x74, 0x63, 0x68, 0x65, 0x72, 0x0d, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4f, 0x62, 0x6a, 
            0x65, 0x63, 0x74, 0x11, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x4f, 
            0x62, 0x6a, 0x65, 0x63, 0x74, 0x16, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4f, 0x62, 0x6a, 
            0x65, 0x63, 0x74, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x0a, 0x16, 0x01, 0x16, 
            0x04, 0x18, 0x06, 0x16, 0x07, 0x18, 0x08, 0x16, 0x0a, 0x18, 0x09, 0x08, 0x0e, 0x16, 0x14, 0x03, 
            0x01, 0x01, 0x01, 0x04, 0x14, 0x07, 0x01, 0x02, 0x07, 0x01, 0x03, 0x07, 0x02, 0x05, 0x09, 0x02, 
            0x01, 0x07, 0x04, 0x08, 0x07, 0x04, 0x09, 0x07, 0x06, 0x0b, 0x07, 0x04, 0x0c, 0x07, 0x04, 0x0d, 
            0x07, 0x08, 0x0f, 0x07, 0x04, 0x10, 0x07, 0x01, 0x12, 0x09, 0x03, 0x01, 0x07, 0x04, 0x13, 0x07, 
            0x09, 0x15, 0x09, 0x08, 0x02, 0x07, 0x06, 0x16, 0x07, 0x06, 0x17, 0x07, 0x06, 0x18, 0x0d, 0x00, 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
            0x00, 0x00, 0x00, 0x00, 0x04, 0x01, 0x00, 0x05, 0x00, 0x02, 0x00, 0x02, 0x03, 0x09, 0x03, 0x01, 
            0x04, 0x05, 0x00, 0x05, 0x02, 0x09, 0x05, 0x00, 0x08, 0x00, 0x06, 0x07, 0x09, 0x07, 0x00, 0x0b, 
            0x01, 0x08, 0x00, 0x00, 0x09, 0x00, 0x01, 0x00, 0x04, 0x01, 0x0a, 0x06, 0x01, 0x0b, 0x11, 0x01, 
            0x07, 0x00, 0x0a, 0x00, 0x05, 0x00, 0x01, 0x0c, 0x06, 0x00, 0x00, 0x08, 0x08, 0x03, 0x01, 0x01, 
            0x04, 0x00, 0x00, 0x06, 0x01, 0x02, 0x04, 0x00, 0x01, 0x09, 0x01, 0x05, 0x04, 0x00, 0x02, 0x0c, 
            0x01, 0x06, 0x04, 0x01, 0x03, 0x0c, 0x00, 0x01, 0x01, 0x01, 0x02, 0x03, 0xd0, 0x30, 0x47, 0x00, 
            0x00, 0x01, 0x00, 0x01, 0x03, 0x03, 0x01, 0x47, 0x00, 0x00, 0x03, 0x02, 0x01, 0x01, 0x02, 0x0a, 
            0xd0, 0x30, 0x5d, 0x04, 0x20, 0x58, 0x00, 0x68, 0x01, 0x47, 0x00, 0x00, 0x04, 0x02, 0x01, 0x05, 
            0x06, 0x09, 0xd0, 0x30, 0x5e, 0x0a, 0x2c, 0x11, 0x68, 0x0a, 0x47, 0x00, 0x00, 0x05, 0x01, 0x01, 
            0x06, 0x07, 0x06, 0xd0, 0x30, 0xd0, 0x49, 0x00, 0x47, 0x00, 0x00, 0x06, 0x02, 0x01, 0x01, 0x05, 
            0x17, 0xd0, 0x30, 0x5d, 0x0d, 0x60, 0x0e, 0x30, 0x60, 0x0f, 0x30, 0x60, 0x03, 0x30, 0x60, 0x03, 
            0x58, 0x01, 0x1d, 0x1d, 0x1d, 0x68, 0x02, 0x47, 0x00, 0x00, 0x07, 0x01, 0x01, 0x06, 0x07, 0x03, 
            0xd0, 0x30, 0x47, 0x00, 0x00, 0x08, 0x01, 0x01, 0x07, 0x08, 0x06, 0xd0, 0x30, 0xd0, 0x49, 0x00, 
            0x47, 0x00, 0x00, 0x09, 0x02, 0x01, 0x01, 0x06, 0x1b, 0xd0, 0x30, 0x5d, 0x10, 0x60, 0x0e, 0x30, 
            0x60, 0x0f, 0x30, 0x60, 0x03, 0x30, 0x60, 0x02, 0x30, 0x60, 0x02, 0x58, 0x02, 0x1d, 0x1d, 0x1d, 
            0x1d, 0x68, 0x05, 0x47, 0x00, 0x00, 0x0a, 0x01, 0x01, 0x08, 0x09, 0x03, 0xd0, 0x30, 0x47, 0x00, 
            0x00, 0x0b, 0x02, 0x01, 0x09, 0x0a, 0x0b, 0xd0, 0x30, 0xd0, 0x60, 0x05, 0x68, 0x08, 0xd0, 0x49, 
            0x00, 0x47, 0x00, 0x00, 0x0c, 0x02, 0x01, 0x01, 0x08, 0x23, 0xd0, 0x30, 0x65, 0x00, 0x60, 0x0e, 
            0x30, 0x60, 0x0f, 0x30, 0x60, 0x11, 0x30, 0x60, 0x12, 0x30, 0x60, 0x13, 0x30, 0x60, 0x07, 0x30, 
            0x60, 0x07, 0x58, 0x03, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x68, 0x06, 0x47, 0x00, 0x00
        ];

        private static function abcDataToByteArray():ByteArray {
            var ba:ByteArray = new ByteArray();
            for (var i:uint = 0; i < abcData.length; i++) {
                ba.writeByte(abcData[i]);
            }
            return ba;
        }
        
        private static var abc:ByteArray = abcDataToByteArray();
    }