/**
 * Copyright s8t1h12akj ( http://wonderfl.net/user/s8t1h12akj )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/K7qY
 */

// forked from clockmaker's [Flash 10] Text Engine Demo
/**
 * Flash 10 Text Engine Demo
 * @author Yasu (clockmaker)
 * 
 * Flash 10 の Text Engine を使うと
 * 従来の Text Field のように拡大や移動時に
 * ジャギらないという実験デモ
 */
package {
    import com.bit101.components.*;
    import flash.display.*;
    import flash.system.*;
    import flash.text.engine.*;
    import flash.text.*;
    import flash.net.*;
    import org.libspark.betweenas3.BetweenAS3;
    import org.libspark.betweenas3.easing.Elastic;
    import org.libspark.betweenas3.tweens.ITween;
    
    [SWF(frameRate=60)]
    public class Main extends Sprite {
        static private const MSG:String = "函館＠あき爺の　回転文字　テスト！";
        
        public function Main():void {
            var textBox:Sprite = createTextBlock();
            addChild(textBox);
            textBox.x = stage.stageWidth / 2;
            textBox.y = stage.stageHeight / 2 - 100;
            
            var textField:Sprite = createTextField();
            addChild(textField);
            textField.x = stage.stageWidth / 2;
            textField.y = stage.stageHeight / 2 + 100;
            
            var tw:ITween = BetweenAS3.parallel(
                BetweenAS3.serial(
                    BetweenAS3.tween(textBox, { scaleX:1, scaleY:1 }, { scaleX:0, scaleY:0 }, 4, Elastic.easeOut),
                    BetweenAS3.tween(textBox, { rotation:360 }, { rotation:0 }, 4, Elastic.easeOut)
                    ),
                BetweenAS3.serial(
                    BetweenAS3.tween(textField, { scaleX:1, scaleY:1 }, { scaleX:0, scaleY:0}, 4, Elastic.easeOut),
                    BetweenAS3.tween(textField, { rotation:360 }, { rotation:0 }, 4, Elastic.easeOut)
                    )
                );
            tw.stopOnComplete = false;
            tw.play();
            
            // 説明文(不要)
            new Label(this, 180, 50, "Flash 10 Text Engine");
            new Label(this, 200, 280, "Text Field");
            new PushButton(this, 357, 440, "Link : Tail Festival",function():void {
                navigateToURL(new URLRequest("http://wonderfl.net/tag/%e5%b0%bb%e5%b0%be%e7%a5%ad"))});
        }
        
                   // 設定値
            var txtColor:uint = 0x000033;
            var fontSize:uint = 24;
            
            // フォント情報
            var font:FontDescription = new FontDescription( "メイリオ,ヒラギノ角ゴ Pro W3,ＭＳ Ｐゴシック,_ゴシック,_等幅", FontWeight.NORMAL, FontPosture.NORMAL, FontLookup.DEVICE, RenderingMode.NORMAL );
            
            // 整列フォーマット情報
            var format:ElementFormat = new ElementFormat( font, fontSize, txtColor );
            format.locale = "ja";

            // 段組
            var textBlock :TextBlock = new TextBlock();
            
            // 字の整列方向（縦書き）
            textBlock.lineRotation = TextRotation.ROTATE_0;
            textBlock.textJustifier = new EastAsianJustifier("ja", LineJustification.UNJUSTIFIED );

            // 文字情報設定
            textBlock.content = new TextElement( MSG, format );
            
            var sp:Sprite = new Sprite();
            
                 }
        
              }
    }
}
