/**
 * Copyright irgaly ( http://wonderfl.net/user/irgaly )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/JUgz
 */

package {
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.geom.ColorTransform;
    import flash.utils.Timer;
    import flash.events.TimerEvent;
    import frocessing.color.ColorHSV;
    
    [SWF(width = "465", heightt = "465", frameRate = "30")]
    public class ParticleDraw extends Sprite {
        private var _particles:Vector.<Particle>;
        private var _canvas:BitmapData;
        private var _timer:Timer;
        private var _mouseX:uint = 0, _mouseY:uint = 0;
        private var _color:ColorHSV = new ColorHSV();
        
        public function ParticleDraw() {
            // キャンバスとなるBitmapの作成
            _canvas = new BitmapData(stage.stageWidth, stage.stageHeight, false, 0x000000);
            addChild(new Bitmap(_canvas));
            
            // パーティクル格納変数
            _particles = new Vector.<Particle>();

            // ランダムに線を引くタイマーの作成
            _timer = new Timer(5000);
            _timer.addEventListener(TimerEvent.TIMER, function(e:TimerEvent):void{
                linePixel(Math.random() * _canvas.width, Math.random() * _canvas.height,
                    Math.random() * _canvas.width, Math.random() * _canvas.height, getColor());
            });
            _timer.start();
            
            // マウスイベントの設定
            stage.addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
            stage.addEventListener(MouseEvent.MOUSE_UP, onMouseUp);
            
            // ゲームループ
            stage.addEventListener(Event.ENTER_FRAME, update);
        }
        
        private function update(e:Event):void {
            _canvas.lock(); // Bitmapの再描画停止
            _canvas.colorTransform(_canvas.rect, new ColorTransform(0.9, 0.5, 0.9));
            
            for each(var p:Particle in _particles){
                _canvas.setPixel(p.x, p.y, p.color);
                p.updatePosition();
                if (p.x < 0 || stage.stageWidth < p.x ||
                    p.y < 0 || stage.stageHeight < p.y){
                    _particles.splice(_particles.indexOf(p), 1);
                }
            }

            _canvas.unlock(); // 描画
        }
        
        private function setPixel(x:Number, y:Number, color:uint):void{
            _particles.push(new Particle(x, y, color));
        }
        
        private function linePixel(x0:int, y0:int, x1:int, y1:int, color:uint):void{
            // ブレゼンハムの直線アルゴリズム
            var x:int = x0, y:int = y1;
            var dx:int = Math.abs(x1 - x0), dy:int = Math.abs(y1 - y0);
            var sx:int = (x1 > x0) ? 1: -1, sy:int = (y1 > y0) ? 1: -1;
            
            var err:int, i:int;
            
            if (dx >= dy){
                err = 2*dy - dx;
                for (i = 0; i <= dx; ++i){
                    setPixel(x, y, color);
                    
                    x += sx;
                    err += 2*dy;
                    if (err >= 0){
                        y += sy;
                        err -= 2*dx;
                    }
                }
            }else{
                err = 2*dx - dy;
                for (i = 0; i <= dy; ++i){
                    setPixel(x, y, color);
                    
                    y += sy;
                    err += 2*dx;
                    if (err >= 0){
                        x += sx;
                        err -= 2*dy;
                    }
                }
            }
        }
        
        private function getColor():uint{
            _color.h++;
            return _color.value;
        }
        
        private function onMouseDown(e:MouseEvent):void{
            _mouseX = e.localX;
            _mouseY = e.localY;
            stage.addEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
        }
        
        private function onMouseMove(e:MouseEvent):void{
            linePixel(_mouseX, _mouseY, e.localX, e.localY, getColor());
            _mouseX = e.localX;
            _mouseY = e.localY;
        }
        
        private function onMouseUp(e:MouseEvent):void{
            linePixel(_mouseX, _mouseY, e.localX, e.localY, getColor());
            stage.removeEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
        }
    }
}

import flash.geom.*;
class Particle {
    public var x:Number, y:Number;
    public var vx:Number = 0, vy:Number = 0;
    public var vv:Point; // 加速度
    public var color:uint;
    public function Particle(x:Number, y:Number, color:uint){
        this.x = x;
        this.y = y;
        this.color = color;
        
        var d:Number = 0.01;
        var angle:Number = Math.random() * 2 * Math.PI;
        vv = Point.polar(d, angle);
        vx = vv.x;
        vy = vv.y;
    }
    
    public function updatePosition():void{
        x += vx;
        y += vy;
        vx += vv.x;
        vy += vv.y;
    }
}